/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.generator;

import com.digiwin.athena.bpm.common.util.LoggerUtils;

class SnowflakeIdWorker {
    private final long startTimestamp = 1608466820000L;
    private final long workerIdBits = 3L;
    private final long datacenterIdBits = 3L;
    private final long maxWorkerId = 7L;
    private final long maxDatacenterId = 7L;
    private final long sequenceBits = 6L;
    private final long workerIdShift = 6L;
    private final long datacenterIdShift = 9L;
    private final long timestampLeftShift = 12L;
    private final long sequenceMask = 63L;
    private long workerId;
    private long dataCenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private long offsetOfTimestamp = 0L;

    public SnowflakeIdWorker(long workerId, long dataCenterId) {
        if (workerId > 7L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 7L));
        }
        if (dataCenterId > 7L || dataCenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 7L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
    }

    public synchronized long nextId() {
        long timestamp = this.timeGeneration();
        if (timestamp < this.lastTimestamp) {
            this.offsetOfTimestamp = this.lastTimestamp - timestamp;
            timestamp = this.lastTimestamp;
            LoggerUtils.infoTrace(this.getClass().getName(), "  \u65f6\u949f\u56de\u62e8\uff0c\u65f6\u95f4\u6233\u504f\u79fb\u91cf\u66f4\u65b0\u4e3a\uff1a" + this.offsetOfTimestamp);
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0x3FL;
            if (this.sequence == 0L) {
                timestamp = this.blockNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1608466820000L << 12 | this.dataCenterId << 9 | this.workerId << 6 | this.sequence;
    }

    protected long blockNextMillis(long lastTimestamp) {
        long timestamp = this.timeGeneration();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGeneration();
        }
        return timestamp;
    }

    protected long timeGeneration() {
        return System.currentTimeMillis();
    }
}

