/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.generator;

import com.digiwin.athena.bpm.common.generator.SnowflakeIdWorker;
import com.digiwin.athena.bpm.common.util.LogUtils;
import com.digiwin.athena.bpm.common.util.LoggerUtils;
import com.digiwin.athena.bpm.common.util.NetUtils;
import com.digiwin.athena.bpm.common.util.RedisUtil;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.DisposableBean;
import redis.clients.jedis.Jedis;

public class SnowflakeWorker
implements DisposableBean {
    private final RedisUtil redisUtil = RedisUtil.getRedisUtil();
    private long expire = 4800000L;
    private String module = "BPM";
    private final long dataCenterId = 0L;
    private long workerId = 0L;
    private SnowflakeIdWorker snowflakeIdWorker = null;
    private String hostAddress;
    private String lockKey;
    private boolean initDone = false;
    private static final String POSTPONE_EXPIRE = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('PEXPIRE', KEYS[1], ARGV[2]) else return '0' end";
    private static final String DEL_LOCK = "if redis.call('get',KEYS[1]) == ARGV[1] then return redis.call('del',KEYS[1]) else return 0 end";
    private static final Long POSTPONE_SUCCESS = 1L;

    private SnowflakeWorker() {
    }

    public SnowflakeIdWorker getSnowflakeIdWorker() {
        if (Objects.isNull(this.snowflakeIdWorker)) {
            this.initSnowflakeWorker(this.module, this.getExpire());
        }
        return this.snowflakeIdWorker;
    }

    public void destroy() throws Exception {
        try {
            this.redisUtil.getRedisTemplate().execute(redisConnection -> {
                ArrayList<String> keys = new ArrayList<String>();
                keys.add(this.lockKey);
                ArrayList<String> params = new ArrayList<String>();
                params.add(this.hostAddress);
                Jedis jedis = (Jedis)redisConnection.getNativeConnection();
                Object result = jedis.eval(DEL_LOCK, keys, params);
                return Boolean.TRUE;
            });
        }
        catch (Exception e) {
            LogUtils.getLogger().error("[SnowflakeWorker] del error:{0}", (Throwable)e);
        }
    }

    public static SnowflakeWorker getInstance() {
        return SnowflakeWorkerHolder.INSTANCE;
    }

    public static Long nextId() {
        return SnowflakeWorkerHolder.INSTANCE.getSnowflakeIdWorker().nextId();
    }

    public long getWorkerId() {
        return this.workerId;
    }

    public long getDataCenterId() {
        return 0L;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public String getLockKey() {
        return this.lockKey;
    }

    public String getModule() {
        return this.module;
    }

    public long getExpire() {
        return this.expire;
    }

    public boolean isInitDone() {
        return this.initDone;
    }

    public synchronized void initSnowflakeWorker(String module, long expire) {
        this.expire = expire;
        this.module = module;
        this.hostAddress = NetUtils.getHostAddress();
        for (int i = 1; i < 7; ++i) {
            String key = String.format("Athena:IdWorker:LOCK:%s:%s", this.module, i);
            if (!this.exePostpone(key, this.hostAddress, expire) && !this.lockWorkerId(key, this.hostAddress)) continue;
            this.workerId = i;
            this.lockKey = key;
            break;
        }
        LoggerUtils.infoTrace(this.getClass().getName(), String.format("**%s=%s", this.lockKey, this.hostAddress));
        this.snowflakeIdWorker = new SnowflakeIdWorker(this.workerId, this.dataCenterId);
        this.initDone = true;
    }

    public boolean lockWorkerId(String key, String value) {
        Boolean locked = (Boolean)this.redisUtil.getRedisTemplate().execute(redisConnection -> {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            String result = jedis.set(key, value, "NX", "PX", this.expire);
            if ("OK".equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return Boolean.TRUE.equals(locked);
    }

    public void postpone() {
        try {
            if (this.exePostpone(this.lockKey, this.hostAddress, this.expire)) {
                LoggerUtils.infoTrace(this.getClass().getName(), String.format("***%s -- %s", this.lockKey, "POSTPONE Success\uff01\uff01\uff01"));
            } else {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(60000L);
                            SnowflakeWorker.getInstance().lockWorkerId(SnowflakeWorker.getInstance().getLockKey(), SnowflakeWorker.getInstance().getHostAddress());
                        }
                        catch (InterruptedException exception) {
                            LoggerUtils.infoTrace(this.getClass().getName(), ExceptionUtils.getStackTrace((Throwable)exception));
                            Thread.currentThread().interrupt();
                        }
                    }
                }).start();
            }
        }
        catch (Exception exception) {
            LoggerUtils.infoTrace(this.getClass().getName(), String.format("*****%s -- %s", this.lockKey, ExceptionUtils.getStackTrace((Throwable)exception)));
        }
    }

    private boolean exePostpone(String key, String value, long expire) {
        Boolean isOK = (Boolean)this.redisUtil.getRedisTemplate().execute(redisConnection -> {
            ArrayList<String> keys = new ArrayList<String>();
            keys.add(key);
            ArrayList<String> params = new ArrayList<String>();
            params.add(value);
            params.add(String.valueOf(expire));
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            Object result = jedis.eval(POSTPONE_EXPIRE, keys, params);
            if (POSTPONE_SUCCESS.equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        return Boolean.TRUE.equals(isOK);
    }

    private static class SnowflakeWorkerHolder {
        private static final SnowflakeWorker INSTANCE = new SnowflakeWorker();

        private SnowflakeWorkerHolder() {
        }
    }
}

