/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.security;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.bpm.common.security.UserProfile;
import com.digiwin.athena.bpm.common.util.JsonUtils;
import com.digiwin.athena.bpm.common.util.SpringContextUtil;
import com.digiwin.gateway.token.TokenService;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class SecurityUtil {
    public static final String USER_SID = "userSid";
    public static final String USER_ID = "userId";
    public static final String USER_NAME = "userName";
    public static final String TENANT_SID = "tenantSid";
    public static final String TENANT_ID = "tenantId";
    public static final String TENANT_NAME = "tenantName";

    public static Map<String, Object> getProfile() {
        return DWServiceContext.getContext().getProfile();
    }

    public static UserProfile getUserProfile() {
        UserProfile userProfile = new UserProfile();
        Map<String, Object> profile = SecurityUtil.getProfile();
        userProfile.setUserSid(MapUtils.getLongValue(profile, (Object)USER_SID));
        userProfile.setUserId(MapUtils.getString(profile, (Object)USER_ID));
        userProfile.setUserName(MapUtils.getString(profile, (Object)USER_NAME));
        userProfile.setTenantSid(MapUtils.getLongValue(profile, (Object)TENANT_SID));
        userProfile.setTenantId(MapUtils.getString(profile, (Object)TENANT_ID));
        userProfile.setTenantName(MapUtils.getString(profile, (Object)TENANT_NAME));
        userProfile.setToken(DWServiceContext.getContext().getToken());
        return userProfile;
    }

    public static void userContextHandler(String token) throws DWException {
        try {
            TokenService tokenService = SpringContextUtil.getBean("tokenService", TokenService.class);
            tokenService.verifyIamToken(token);
        }
        catch (Exception e) {
            throw new DWException("PTM_500", " tokenService.verifyIamToken failure !", (Throwable)e);
        }
    }

    public static void userContextHandler(String token, Map<String, Object> profile) {
        DWServiceContext.getContext().setToken(token);
        DWServiceContext.getContext().setProfile(profile);
    }

    public static void userContextHandler(UserProfile userProfile) {
        DWServiceContext.getContext().setToken(userProfile.getToken());
        JSONObject jsonObject = JSONObject.parseObject((String)JsonUtils.toJson(userProfile));
        DWServiceContext.getContext().setProfile((Map)jsonObject);
    }

    public static UserProfile getUserProfile(String token) throws DWException {
        SecurityUtil.userContextHandler(token);
        return SecurityUtil.getUserProfile();
    }
}

