/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.serializer;

import com.digiwin.athena.bpm.common.util.LoggerUtils;
import java.nio.charset.Charset;
import java.util.Objects;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class RedisKeySerializer
implements RedisSerializer<String> {
    private String keyPrefix = "";
    private final Charset charset = Charset.forName("UTF8");

    public RedisKeySerializer(String keyPrefix) {
        this.keyPrefix = Objects.isNull(keyPrefix) || "".equals(keyPrefix) ? "bpm_" : keyPrefix + "_";
    }

    public byte[] serialize(String s) throws SerializationException {
        String key = this.keyPrefix + s;
        return s == null || "".equals(s) ? null : key.getBytes(this.charset);
    }

    public String deserialize(byte[] bytes) throws SerializationException {
        String saveKey = new String(bytes, this.charset);
        int indexOf = saveKey.indexOf(this.keyPrefix);
        if (indexOf > 0) {
            LoggerUtils.infoTrace(this.getClass().getName(), "key missing prefix [digiwin_bpm_]");
        } else {
            saveKey = saveKey.substring(this.keyPrefix.length());
        }
        return saveKey;
    }
}

