/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.util;

import com.digiwin.app.json.gson.DWGsonProvider;
import com.digiwin.athena.bpm.common.serializer.CustomObjectTypeAdapter;
import com.digiwin.athena.bpm.common.serializer.date.DateFormatStyle;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class GsonUtils {
    private static GsonBuilder builder() {
        return new GsonBuilder().setDateFormat(DateFormatStyle.SLASH_END_SECOND.getValue()).registerTypeAdapter(Map.class, (Object)new CustomObjectTypeAdapter());
    }

    private static Gson getGson() {
        return GsonHolder.INSTANCE;
    }

    private static Gson getPrettyGson() {
        return PrettyGsonHolder.INSTANCE;
    }

    public static <T> List<T> toList(String json, Type listType) {
        return (List)GsonUtils.getGson().fromJson(json, listType);
    }

    public static <T> List<T> toList(String json, Class<T[]> clazz) {
        Object[] arr = (Object[])GsonUtils.getGson().fromJson(json, clazz);
        return Arrays.asList(arr);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return (T)GsonUtils.getGson().fromJson(json, clazz);
    }

    public static <T> T toObject(String json, Type type) {
        return (T)GsonUtils.getGson().fromJson(json, type);
    }

    public static String toJson(List<?> list) {
        return GsonUtils.getGson().toJson(list);
    }

    public static String toPrettyJson(List<?> list) {
        return GsonUtils.getPrettyGson().toJson(list);
    }

    public static String toJson(Object o) {
        return GsonUtils.getGson().toJson(o);
    }

    public static String toPrettyJson(Object o) {
        return GsonUtils.getPrettyGson().toJson(o);
    }

    static /* synthetic */ GsonBuilder access$000() {
        return GsonUtils.builder();
    }

    private static class PrettyGsonHolder {
        private static final Gson INSTANCE = GsonUtils.access$000().setPrettyPrinting().create();

        private PrettyGsonHolder() {
        }
    }

    private static class GsonHolder {
        private static final Gson INSTANCE = DWGsonProvider.getGson();

        private GsonHolder() {
        }
    }
}

