/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.util;

import com.digiwin.athena.bpm.common.serializer.date.DateCommonDeserializer;
import com.digiwin.athena.bpm.common.serializer.date.DateFormatStyle;
import com.digiwin.athena.bpm.common.serializer.date.LocalDateDeserializer;
import com.digiwin.athena.bpm.common.serializer.date.LocalDateSerializer;
import com.digiwin.athena.bpm.common.serializer.date.LocalDateTimeDeserializer;
import com.digiwin.athena.bpm.common.serializer.date.LocalDateTimeSerializer;
import com.digiwin.athena.bpm.common.serializer.date.LocalTimeDeserializer;
import com.digiwin.athena.bpm.common.serializer.date.LocalTimeSerializer;
import com.digiwin.athena.bpm.common.serializer.date.TimestampDeserializer;
import com.digiwin.athena.bpm.common.serializer.date.TimestampSerializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtils {
    private static final ObjectMapper BASIC = new ObjectMapper();
    private static final ObjectMapper CUSTOMIZATION = new CustomizationObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonUtils.class);

    public static String toJson(Object input) {
        return JsonUtils.toJson(BASIC, input);
    }

    public static String toCustomizationJson(Object input) {
        return JsonUtils.toJson(CUSTOMIZATION, input);
    }

    public static <T> T jsonToType(String inputJson, Class<T> targetType) {
        return JsonUtils.jsonToType(BASIC, inputJson, targetType);
    }

    public static <T> List<T> jsonToListType(String inputJson, Class<T> targetType) {
        return JsonUtils.jsonToListType(BASIC, inputJson, targetType);
    }

    public static <T> T jsonToType(String inputJson, TypeReference targetType) {
        return JsonUtils.jsonToType(BASIC, inputJson, targetType);
    }

    public static ObjectMapper getCustomizationMapper() {
        return CUSTOMIZATION;
    }

    public static ObjectMapper buildCustomizationMapper() {
        return new CustomizationObjectMapper();
    }

    public static ObjectMapper getBasicMapper() {
        return BASIC;
    }

    private static <T> T jsonToType(ObjectMapper objectMapper, String inputJson, TypeReference targetType) {
        try {
            return (T)objectMapper.readValue(inputJson, targetType);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static <T> T jsonToType(ObjectMapper objectMapper, String inputJson, Class<T> targetType) {
        try {
            return (T)objectMapper.readValue(inputJson, targetType);
        }
        catch (Exception e) {
            LOGGER.error("jsonToType", (Throwable)e);
            return null;
        }
    }

    private static <T> List<T> jsonToListType(ObjectMapper objectMapper, String inputJson, Class<T> targetType) {
        try {
            return (List)objectMapper.readValue(inputJson, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, targetType));
        }
        catch (Exception e) {
            LOGGER.error("jsonToListType", (Throwable)e);
            return null;
        }
    }

    private static String toJson(ObjectMapper objectMapper, Object input) {
        try {
            return objectMapper.writeValueAsString(input);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toJson", (Throwable)e);
            return null;
        }
    }

    static {
        BASIC.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        BASIC.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        BASIC.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        BASIC.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        BASIC.setTimeZone(TimeZone.getDefault());
        BASIC.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        BASIC.setDateFormat((DateFormat)new SimpleDateFormat(DateFormatStyle.SLASH_END_SECOND.getValue()));
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addDeserializer(Date.class, (JsonDeserializer)new DateCommonDeserializer());
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer());
        javaTimeModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer());
        javaTimeModule.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer());
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer());
        javaTimeModule.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer());
        javaTimeModule.addSerializer(Timestamp.class, (JsonSerializer)new TimestampSerializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
        javaTimeModule.addDeserializer(Timestamp.class, (JsonDeserializer)new TimestampDeserializer());
        BASIC.registerModule((Module)javaTimeModule);
    }

    private static class CustomizationObjectMapper
    extends ObjectMapper {
        private CustomizationObjectMapper(DateFormat dateFormat) {
            this.setDateFormat(dateFormat);
            this.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        }

        private CustomizationObjectMapper() {
            this(new SimpleDateFormat(DateFormatStyle.SLASH_END_SECOND.getValue()));
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addSerializer(Long.class, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addSerializer(Long.TYPE, (JsonSerializer)ToStringSerializer.instance);
            simpleModule.addDeserializer(Date.class, (JsonDeserializer)new DateCommonDeserializer());
            simpleModule.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer());
            this.registerModule((Module)simpleModule);
        }
    }
}

