/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.util;

import com.digiwin.athena.bpm.common.serializer.date.DateFormatStyle;
import com.digiwin.athena.bpm.common.util.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggerUtils {
    private static final Log log = LogFactory.getLog(LoggerUtils.class);

    public static void debugTrace(String className, String context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[" + className + "]" + context));
        }
    }

    public static void infoTrace(String className, String context) {
        if (log.isInfoEnabled()) {
            log.info((Object)("[" + className + "]" + context));
        }
    }

    public static void infoTrace(Class<?> clazz, String context) {
        LoggerUtils.infoTrace(clazz.getName(), context);
    }

    public static void errorTrace(String className, String context) {
        if (log.isErrorEnabled()) {
            log.error((Object)("[" + className + "]" + context));
        }
    }

    public static void errorTrace(Class<?> clazz, String context) {
        LoggerUtils.errorTrace(clazz.getName(), context);
    }

    public static void printTrace(String className, String context) {
        System.out.println(DateUtils.currentTimeString(DateFormatStyle.BAR_END_MS.getValue()) + ":" + context);
    }

    public static void printTrace(Class<?> clazz, String context) {
        LoggerUtils.printTrace(clazz.getName(), context);
    }
}

