/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.util;

import com.digiwin.athena.bpm.common.util.IdGenerator;
import com.digiwin.athena.bpm.common.util.LoggerUtils;
import com.digiwin.athena.bpm.common.util.RedisUtil;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import redis.clients.jedis.Jedis;

public class RedLock {
    private final String lockKey;
    private final long expire;
    private final String value;
    private final RedisUtil redisUtil;
    private static final Long RELEASE_SUCCESS = 1L;
    private static final Long POSTPONE_SUCCESS = 1L;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    private static final String RELEASE_LOCK_SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
    private static final String POSTPONE_LOCK_SCRIPT = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('PEXPIRE', KEYS[1], ARGV[2]) else return '0' end";

    private RedLock(String lockKey, long expire) {
        this.lockKey = String.format("TaskEngine:LOCK:%s", lockKey);
        this.expire = expire * 1000L;
        this.value = IdGenerator.nextRandomUUID();
        this.redisUtil = RedisUtil.getModuleRedisUtil();
    }

    public static RedLock build(String key, long expire) {
        return new RedLock(key, expire);
    }

    public static RedLock build(String key) {
        return RedLock.build(key, 3L);
    }

    public boolean lock() {
        return this.lock(5L);
    }

    public boolean lock(long timeout) {
        boolean locked;
        long waitMax = TimeUnit.SECONDS.toMillis(timeout);
        long waitAlready = 0L;
        do {
            if ((locked = this.tryLock()) || timeout <= 0L) continue;
            if (waitAlready > waitMax) break;
            try {
                waitAlready += 200L;
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                LoggerUtils.infoTrace(this.getClass(), ExceptionUtils.getStackTrace((Throwable)e));
                break;
            }
        } while (!locked);
        return locked;
    }

    public boolean tryLock() {
        Boolean locked = (Boolean)this.redisUtil.getRedisTemplate().execute(redisConnection -> {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            String result = jedis.set(this.lockKey, this.value, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, this.expire);
            if (LOCK_SUCCESS.equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
        if (Boolean.TRUE.equals(locked)) {
            Thread thread = new Thread(new LockPostpone(this.lockKey, this.value, this.expire, this));
            thread.setDaemon(Boolean.TRUE);
            thread.start();
        }
        return Boolean.TRUE.equals(locked);
    }

    public Boolean postpone(String key, String value, long expireTime) {
        Boolean exeResult;
        try {
            exeResult = (Boolean)this.redisUtil.getRedisTemplate().execute(redisConnection -> {
                Jedis jedis = (Jedis)redisConnection.getNativeConnection();
                Object result = jedis.eval(POSTPONE_LOCK_SCRIPT, (List)Lists.newArrayList((Object[])new String[]{key}), (List)Lists.newArrayList((Object[])new String[]{value, String.valueOf(expireTime)}));
                if (POSTPONE_SUCCESS.equals(result)) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            });
        }
        catch (Exception e) {
            LoggerUtils.errorTrace(this.getClass().getSimpleName(), ExceptionUtils.getStackTrace((Throwable)e));
            exeResult = Boolean.FALSE;
        }
        return exeResult;
    }

    public void unlock() {
        this.redisUtil.getRedisTemplate().execute(redisConnection -> {
            Jedis jedis = (Jedis)redisConnection.getNativeConnection();
            Object result = jedis.eval(RELEASE_LOCK_SCRIPT, Collections.singletonList(this.lockKey), Collections.singletonList(this.value));
            if (RELEASE_SUCCESS.equals(result)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    public String getValue() {
        return this.value;
    }

    static class LockPostpone
    implements Runnable {
        private final String key;
        private final String value;
        private final long expireTime;
        private final RedLock redisLock;
        private boolean isRunning;

        public LockPostpone(String key, String value, long expireTime, RedLock redisLock) {
            this.key = key;
            this.value = value;
            this.expireTime = expireTime;
            this.isRunning = Boolean.TRUE;
            this.redisLock = redisLock;
        }

        @Override
        public void run() {
            long waitTime = this.expireTime * 2L / 3L;
            while (this.isRunning) {
                try {
                    Thread.sleep(waitTime);
                    if (Boolean.TRUE.equals(this.redisLock.postpone(this.key, this.value, this.expireTime))) {
                        LoggerUtils.infoTrace(this.getClass(), String.format("%s=%s[\u5ef6\u65f6\u6210\u529f]", this.key, this.value));
                        continue;
                    }
                    this.stop();
                }
                catch (Exception e) {
                    this.stop();
                    LoggerUtils.errorTrace(this.getClass().getSimpleName(), ExceptionUtils.getStackTrace((Throwable)e));
                    this.redisLock.postpone(this.key, this.value, this.expireTime);
                    break;
                }
            }
        }

        private void stop() {
            this.isRunning = Boolean.FALSE;
        }
    }
}

