/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.configuration;

import java.math.BigDecimal;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;

public class MongoBigDecimalCodec
implements Codec<BigDecimal> {
    public void encode(BsonWriter writer, BigDecimal value, EncoderContext encoderContext) {
        Decimal128 decimal128 = Decimal128.fromIEEE754BIDEncoding((long)value.unscaledValue().longValue(), (long)value.scale());
        writer.writeDecimal128(decimal128);
    }

    public BigDecimal decode(BsonReader reader, DecoderContext decoderContext) {
        Decimal128 decimal128 = reader.readDecimal128();
        return decimal128.bigDecimalValue();
    }

    public Class<BigDecimal> getEncoderClass() {
        return BigDecimal.class;
    }
}

