/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.configuration;

import com.digiwin.athena.bpm.mq.MQMessageService;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
@EnableRabbit
public class RabbitMQConfiguration {
    @Value(value="${spring.rabbitmq.uri}")
    private String mqURI;
    @Value(value="${spring.rabbitmq.publisherReturns:true}")
    private boolean publisherReturns;
    @Value(value="${spring.rabbitmq.publisherConfirms:true}")
    private boolean publisherConfirms;

    @Bean(value={"connectionFactory"})
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory factory = new CachingConnectionFactory();
        factory.setPublisherReturns(this.publisherReturns);
        factory.setPublisherConfirms(this.publisherConfirms);
        factory.setUri(this.mqURI);
        return factory;
    }

    @Bean(value={"rabbitAdmin"})
    public RabbitAdmin rabbitAdmin(ConnectionFactory connectionFactory) {
        return new RabbitAdmin(connectionFactory);
    }

    @Bean(value={"rabbitTemplate"})
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setBeforePublishPostProcessors(new MessagePostProcessor[]{message -> {
            message.getMessageProperties().setContentType("application/json");
            return message;
        }});
        return rabbitTemplate;
    }

    @Bean(value={"mqMessageService"})
    public MQMessageService mqMessageService(RabbitTemplate rabbitTemplate, MongoTemplate mongoTemplate) {
        return new MQMessageService(rabbitTemplate, mongoTemplate);
    }
}

