/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.persistence.service.impl;

import com.digiwin.athena.bpm.common.domain.DataDTO;
import com.digiwin.athena.bpm.persistence.domain.BaseMgrEntity;
import com.digiwin.athena.bpm.persistence.repository.BaseRepository;
import com.digiwin.athena.bpm.persistence.service.IDataService;
import com.digiwin.athena.bpm.persistence.service.impl.AbsBaseService;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
public class DataService<Repository extends BaseRepository<T>, T extends BaseMgrEntity, D extends DataDTO, PK extends Serializable>
extends AbsBaseService<Repository, T>
implements IDataService<T, D, PK> {
    private Class<T> entityClass;
    private Class<D> entityDTOClass;

    public DataService() {
        Class<?> c = this.getClass();
        Type type = c.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            Type[] parameterizedType = ((ParameterizedType)type).getActualTypeArguments();
            this.entityClass = (Class)parameterizedType[1];
            this.entityDTOClass = (Class)parameterizedType[2];
        }
    }

    @Override
    @Transactional(readOnly=true, rollbackFor={Exception.class})
    public D getOneDTO(PK id) {
        return this.copyBeanToDTO((BaseMgrEntity)this.repository.selectById((Serializable)id));
    }

    @Override
    public void saveOrUpdate(D module) {
        BaseMgrEntity entity = null;
        try {
            entity = Objects.isNull(((DataDTO)module).getId()) ? (BaseMgrEntity)this.repository.selectById((Serializable)((DataDTO)module).getId()) : (BaseMgrEntity)this.entityClass.newInstance();
            this.copyDTOToBean(module, entity);
        }
        catch (Exception e) {
            this.log.warn("{}", (Throwable)e);
        }
        this.saveOrUpdate(entity);
        ((DataDTO)module).setId((Serializable)entity.pkVal());
    }

    @Override
    public void copyBeanToDTO(T entity, D module) {
        if (module != null && entity != null) {
            BeanUtils.copyProperties(entity, module);
            if (Objects.nonNull(((BaseMgrEntity)entity).pkVal())) {
                ((DataDTO)module).setId((Serializable)((BaseMgrEntity)entity).pkVal());
            }
        }
    }

    @Override
    public D copyBeanToDTO(T entity) {
        DataDTO module = null;
        if (entity != null && this.entityDTOClass != null) {
            try {
                module = (DataDTO)this.entityDTOClass.newInstance();
                this.copyBeanToDTO(entity, module);
                if (Objects.nonNull(((BaseMgrEntity)entity).pkVal())) {
                    module.setId(((BaseMgrEntity)entity).pkVal());
                }
            }
            catch (Exception e) {
                this.log.error("{}", (Throwable)e);
            }
        }
        return (D)module;
    }

    @Override
    public void copyDTOToBean(D module, T entity) {
        if (module != null && entity != null) {
            BeanUtils.copyProperties(module, entity);
            if (Objects.nonNull(((DataDTO)module).getId())) {
                ((BaseMgrEntity)entity).setPK((Serializable)((DataDTO)module).getId());
            }
        }
    }

    @Override
    public T copyDTOToBean(D module) {
        BaseMgrEntity entity = null;
        if (module != null && this.entityClass != null) {
            try {
                entity = (BaseMgrEntity)this.entityClass.newInstance();
                this.copyDTOToBean(module, entity);
                if (Objects.nonNull(((DataDTO)module).getId())) {
                    entity.setPK((Serializable)((DataDTO)module).getId());
                }
            }
            catch (Exception e) {
                this.log.error("{}", (Throwable)e);
            }
        }
        return (T)entity;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public Class<D> getEntityDTOClass() {
        return this.entityDTOClass;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public void setEntityDTOClass(Class<D> entityDTOClass) {
        this.entityDTOClass = entityDTOClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataService)) {
            return false;
        }
        DataService other = (DataService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<T> this$entityClass = this.getEntityClass();
        Class<T> other$entityClass = other.getEntityClass();
        if (this$entityClass == null ? other$entityClass != null : !this$entityClass.equals(other$entityClass)) {
            return false;
        }
        Class<D> this$entityDTOClass = this.getEntityDTOClass();
        Class<D> other$entityDTOClass = other.getEntityDTOClass();
        return !(this$entityDTOClass == null ? other$entityDTOClass != null : !this$entityDTOClass.equals(other$entityDTOClass));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<T> $entityClass = this.getEntityClass();
        result = result * 59 + ($entityClass == null ? 43 : $entityClass.hashCode());
        Class<D> $entityDTOClass = this.getEntityDTOClass();
        result = result * 59 + ($entityDTOClass == null ? 43 : $entityDTOClass.hashCode());
        return result;
    }

    public String toString() {
        return "DataService(entityClass=" + this.getEntityClass() + ", entityDTOClass=" + this.getEntityDTOClass() + ")";
    }
}

