/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.definition;

import com.digiwin.athena.definition.Definition;
import com.digiwin.athena.definition.DefinitionJson;
import com.google.common.base.CaseFormat;
import com.google.common.reflect.ClassPath;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefinitionExporter {
    private static final Gson GSON = new Gson();

    public static String exportJavaDefinition() throws Exception {
        JsonObject tJsonObject = new JsonObject();
        JsonArray tJsonArray = new JsonArray();
        tJsonObject.add("definition", (JsonElement)tJsonArray);
        ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClassesRecursive("definition").forEach(pClassInfo -> {
            Class tClass = pClassInfo.load();
            if (Definition.class.isAssignableFrom(tClass)) {
                try {
                    Matcher tVerMatcher;
                    Matcher tApiMatcher;
                    Path tPath = Paths.get(tClass.getResource(tClass.getSimpleName() + ".class").toURI());
                    byte[] tBytes = Files.readAllBytes(tPath);
                    String tBase64Class = Base64.getEncoder().encodeToString(tBytes);
                    Pattern tProdPattern = Pattern.compile("(?<=definition\\.)\\w+");
                    Pattern tApiPattern = Pattern.compile("((?=\\D)[a-zA-Z])+");
                    Pattern tVerPattern = Pattern.compile("\\d_\\d");
                    String tProd = null;
                    String tApi = null;
                    String tVersion = null;
                    Matcher tProdMatcher = tProdPattern.matcher(tClass.getPackage().getName());
                    if (tProdMatcher.find()) {
                        tProd = tProdMatcher.group().toUpperCase();
                    }
                    if ((tApiMatcher = tApiPattern.matcher(tClass.getSimpleName())).find()) {
                        tApi = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, tApiMatcher.group()).replaceAll("_", ".");
                    }
                    if ((tVerMatcher = tVerPattern.matcher(tClass.getSimpleName())).find()) {
                        tVersion = tVerMatcher.group().replaceAll("_", ".");
                    }
                    DefinitionJson tDefinition = new DefinitionJson();
                    tDefinition.setApiName(tApi);
                    tDefinition.setApiVersion(tVersion);
                    tDefinition.setProdName(tProd);
                    tDefinition.setContent(tBase64Class);
                    tDefinition.setType("JAVA");
                    tJsonArray.add(GSON.toJsonTree((Object)tDefinition));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        return tJsonObject.toString();
    }
}

