/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.definition;

import com.digiwin.athena.definition.ApiInfo;
import com.digiwin.athena.definition.ApiType;
import com.digiwin.athena.definition.CommonJson;
import com.digiwin.athena.definition.Definition;
import com.digiwin.athena.definition.DefinitionJson;
import com.digiwin.athena.definition.SqlInfo;
import com.digiwin.athena.definition.exception.DefinitionException;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Base64;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.commons.lang3.StringUtils;

public class DefinitionExporter {
    private static final Gson GSON = new Gson();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String exportJavaDefinition() throws Exception {
        HashSet<String> commonSet = new HashSet<String>();
        JsonObject tJsonObject = new JsonObject();
        JsonArray tDefinitionArray = new JsonArray();
        JsonArray tCommonArray = new JsonArray();
        final Path tRootPath = Paths.get(ClassLoader.getSystemResource("").toURI());
        Path tDefinitionPath = tRootPath.resolve("com/digiwin/definition");
        DirectoryStream<Path> tProdDirectoryStream = Files.newDirectoryStream(tDefinitionPath);
        for (Path tPath : tProdDirectoryStream) {
            String tProd = tPath.getFileName().toString().toUpperCase();
            String tJavaApiPathStr = String.format("com.digiwin.definition.%s.service", tPath.getFileName());
            ImmutableSet tJavaApiClassInfos = ClassPath.from((ClassLoader)DefinitionExporter.class.getClassLoader()).getTopLevelClassesRecursive(tJavaApiPathStr);
            for (ClassPath.ClassInfo tClassInfo : tJavaApiClassInfos) {
                Class tClass = tClassInfo.load();
                if (!Definition.class.isAssignableFrom(tClass)) continue;
                ApiInfo tAnnotation = tClass.getAnnotation(ApiInfo.class);
                String tApiName = null;
                String tVersion = null;
                String tDescription = null;
                if (tAnnotation != null) {
                    tApiName = tAnnotation.name();
                    tVersion = tAnnotation.version();
                    if (!tApiName.matches("^([a-z]+\\.)+[a-z]+$")) {
                        throw new DefinitionException(String.format("Class [%s] annotion [@ApiInfo] name is the wrong format.", tClass.getName()));
                    }
                    if (!tVersion.matches("^\\d+\\.\\d+$")) {
                        throw new DefinitionException(String.format("Class [%s] annotion [@ApiInfo] version is the wrong format.", tClass.getName()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)tAnnotation.description())) {
                        tDescription = tAnnotation.description();
                    }
                } else {
                    throw new DefinitionException(String.format("Class [%s] can't find annotion [@ApiInfo] on class.", tClass.getName()));
                }
                Path tPackagePath = Paths.get(tClass.getResource("").toURI());
                ByteArrayOutputStream tBos = new ByteArrayOutputStream();
                final JarOutputStream tZos = new JarOutputStream(tBos);
                Files.walkFileTree(tPackagePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                        Path tFileName = tRootPath.relativize(file);
                        JarEntry tZipEntry = new JarEntry(tFileName.toString().replaceAll("\\\\", "/"));
                        tZos.putNextEntry(tZipEntry);
                        tZos.write(Files.readAllBytes(file));
                        return FileVisitResult.CONTINUE;
                    }
                });
                tZos.close();
                tBos.close();
                String tJarByteBase64 = Base64.getEncoder().encodeToString(tBos.toByteArray());
                DefinitionJson tDefinition = new DefinitionJson();
                tDefinition.setApiName(tApiName);
                tDefinition.setApiVersion(tVersion);
                tDefinition.setApiDescription(tDescription);
                tDefinition.setProdName(tProd);
                tDefinition.setContent(tJarByteBase64);
                tDefinition.setType(ApiType.JAVA);
                tDefinitionArray.add(GSON.toJsonTree((Object)tDefinition));
            }
            Path tCommonPackagePath = tPath.resolve("common");
            if (Files.exists(tCommonPackagePath, new LinkOption[0])) {
                ByteArrayOutputStream tBos = new ByteArrayOutputStream();
                final JarOutputStream tZos = new JarOutputStream(tBos);
                try {
                    Files.walkFileTree(tCommonPackagePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) throws IOException {
                            Path tFileName = tRootPath.relativize(file);
                            JarEntry tZipEntry = new JarEntry(tFileName.toString().replaceAll("\\\\", "/"));
                            tZos.putNextEntry(tZipEntry);
                            tZos.write(Files.readAllBytes(file));
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                finally {
                    tZos.close();
                    tBos.close();
                }
                String tJarByteBase64 = Base64.getEncoder().encodeToString(tBos.toByteArray());
                CommonJson tCommonJson = new CommonJson();
                tCommonJson.setProdName(tProd);
                tCommonJson.setType(ApiType.JAVA);
                tCommonJson.setContent(tJarByteBase64);
                tCommonArray.add(GSON.toJsonTree((Object)tCommonJson));
                commonSet.add(tProd);
            }
            String tSqlApiPathStr = String.format("com.digiwin.definition.%s.sql", tPath.getFileName());
            ImmutableSet tSqlApiClassInfos = ClassPath.from((ClassLoader)DefinitionExporter.class.getClassLoader()).getTopLevelClassesRecursive(tSqlApiPathStr);
            for (ClassPath.ClassInfo tClassInfo : tSqlApiClassInfos) {
                URL tSqlUrl;
                Class tClass = tClassInfo.load();
                if (!tClass.isAnnotationPresent(ApiInfo.class)) continue;
                ApiInfo tApiInfo = tClass.getAnnotation(ApiInfo.class);
                SqlInfo tSqlInfo = tClass.getAnnotation(SqlInfo.class);
                String tApiName = null;
                String tVersion = null;
                String tDescription = null;
                String tSqlType = null;
                String tSql = null;
                if (tSqlInfo != null) {
                    tApiName = tApiInfo.name();
                    tVersion = tApiInfo.version();
                    if (!tApiName.matches("^([a-z]+\\.)+[a-z]+$")) {
                        throw new DefinitionException(String.format("Class [%s] annotion [@ApiInfo] name is the wrong format.", tClass.getName()));
                    }
                    if (!tVersion.matches("^\\d+\\.\\d+$")) {
                        throw new DefinitionException(String.format("Class [%s] annotion [@ApiInfo] version is the wrong format.", tClass.getName()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)tApiInfo.description())) {
                        tDescription = tApiInfo.description();
                    }
                    tSqlType = tSqlInfo.type().toString();
                    tSqlUrl = tClass.getResource(tSqlInfo.fileName());
                    if (tSqlUrl == null) {
                        throw new DefinitionException(String.format("Sql file not found: %s", tSqlInfo.fileName()));
                    }
                } else {
                    throw new DefinitionException(String.format("Class [%s] can't find annotion [@SqlInfo] on class.", tClass.getName()));
                }
                Path tSqlPath = Paths.get(tSqlUrl.toURI());
                tSql = Base64.getEncoder().encodeToString(Files.readAllBytes(tSqlPath));
                DefinitionJson tDefinition = new DefinitionJson();
                tDefinition.setApiName(tApiName);
                tDefinition.setApiVersion(tVersion);
                tDefinition.setApiDescription(tDescription);
                tDefinition.setProdName(tProd);
                tDefinition.setType(ApiType.SQL);
                tDefinition.setSqlType(tSqlType);
                tDefinition.setContent(tSql);
                tDefinitionArray.add(GSON.toJsonTree((Object)tDefinition));
            }
        }
        if (tDefinitionArray.size() > 0) {
            tJsonObject.add("definition", (JsonElement)tDefinitionArray);
        }
        if (tCommonArray.size() > 0) {
            tJsonObject.add("common", (JsonElement)tCommonArray);
        }
        return tJsonObject.toString();
    }
}

