/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.definition;

import com.alibaba.druid.pool.DruidDataSource;
import com.digiwin.app.service.DWEAIResult;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;

public abstract class Definition {
    private static final String JDBC_URL = "jdbc.url";
    private static final String JDBC_CLASS = "jdbc.class";
    private Map<String, String> properties = new HashMap<String, String>();
    private static Map<String, String> jdbcUrls = new ConcurrentHashMap<String, String>();
    private static Map<String, String> jdbcDriverClassMap = new ConcurrentHashMap<String, String>();
    private static Map<String, DruidDataSource> dataSources = new ConcurrentHashMap<String, DruidDataSource>();

    public abstract DWEAIResult execute(Map<String, Object> var1, Map<String, Object> var2);

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getPropertie(String pKey) {
        return this.properties.get(pKey);
    }

    public void setPropertie(String pKey, String pValue) {
        String oldVal = this.properties.get(pKey);
        this.closeDataSourceWhenUrlChange(oldVal, pValue);
        this.properties.put(pKey, pValue);
    }

    public String getJdbcUrl() {
        return this.properties.get(JDBC_URL);
    }

    public String getJdbcUrl(String pName) {
        if (pName == null) {
            return this.getJdbcUrl();
        }
        return jdbcUrls.get(pName);
    }

    public String getJdbcClass(String pName) {
        if (pName == null) {
            return this.getPropertie(JDBC_CLASS);
        }
        return jdbcDriverClassMap.get(pName);
    }

    public void setJdbcUrl(String pName, String pUrl) {
        String oldVal = jdbcUrls.get(pName);
        this.closeDataSourceWhenUrlChange(oldVal, pUrl);
        jdbcUrls.put(pName, pUrl);
    }

    public void setDriverClass(String pName, String driverClass) {
        jdbcDriverClassMap.put(pName, driverClass);
    }

    public DataSource getDataSource() {
        String url = this.getJdbcUrl();
        return this.getDataSourceByJdbcUrl(url, null);
    }

    public DataSource getDataSource(String pName) {
        if (null == pName) {
            return this.getDataSource();
        }
        String url = this.getJdbcUrl(pName);
        return this.getDataSourceByJdbcUrl(url, pName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSource getDataSourceByJdbcUrl(String url, String name) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return null;
        }
        if (dataSources.containsKey(url)) {
            return (DataSource)dataSources.get(url);
        }
        Class<Definition> clazz = Definition.class;
        synchronized (Definition.class) {
            if (dataSources.containsKey(url)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return (DataSource)dataSources.get(url);
            }
            DruidDataSource dataSource = this.createDataSource(url, name);
            dataSources.put(url, dataSource);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return dataSource;
        }
    }

    private DruidDataSource createDataSource(String url, String name) {
        String className;
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(url);
        className = StringUtils.isBlank((CharSequence)name) ? this.getPropertie(JDBC_CLASS) : (null != (className = jdbcDriverClassMap.get(name)) ? className : this.getPropertie(JDBC_CLASS));
        dataSource.setDriverClassName(className);
        if (url.toLowerCase().contains(":oracle:")) {
            dataSource.setValidationQuery("SELECT 1 from dual");
        } else {
            dataSource.setValidationQuery("SELECT 1");
        }
        dataSource.setInitialSize(2);
        dataSource.setMinIdle(2);
        dataSource.setMaxActive(20);
        dataSource.setMaxWait(60000L);
        dataSource.setTimeBetweenConnectErrorMillis(300000L);
        dataSource.setTestWhileIdle(true);
        try {
            dataSource.init();
        }
        catch (SQLException e) {
            dataSource.close();
            throw new RuntimeException(e);
        }
        return dataSource;
    }

    private void closeDataSourceWhenUrlChange(String oldVal, String newVal) {
        if (null != oldVal && !StringUtils.equals((CharSequence)oldVal, (CharSequence)newVal) && dataSources.containsKey(oldVal)) {
            dataSources.get(oldVal).close();
            dataSources.remove(oldVal);
        }
    }
}

