/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import com.digiwin.athena.utils.CurThreadInfoUtils;
import java.util.function.Supplier;

public class SwitchDatabaseUtils {
    public static <T> T switchStandardDatabase(Supplier<T> supplier) {
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();
        try {
            CurThreadInfoUtils.setIndividualCase(false);
            T t = supplier.get();
            return t;
        }
        finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static <T> T switchIndividualDatabase(Supplier<T> supplier) {
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();
        try {
            CurThreadInfoUtils.setIndividualCase(true);
            T t = supplier.get();
            return t;
        }
        finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static void switchStandardDatabase(Runnable runnable) {
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();
        try {
            CurThreadInfoUtils.setIndividualCase(false);
            runnable.run();
        }
        finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    public static void switchIndividualDatabase(Runnable runnable) {
        Boolean individualCase = CurThreadInfoUtils.getIndividualCase();
        try {
            CurThreadInfoUtils.setIndividualCase(true);
            runnable.run();
        }
        finally {
            CurThreadInfoUtils.setIndividualCase(individualCase);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T switchBranchDatabase(String branch, Supplier<T> supplier) {
        String originalBranchKey = CurThreadInfoUtils.getBranchKey();
        try {
            CurThreadInfoUtils.setBranchKey(branch);
            T t = supplier.get();
            return t;
        }
        finally {
            CurThreadInfoUtils.setBranchKey(originalBranchKey);
        }
    }

    public static void switchBranchDatabase(String branch, Runnable runnable) {
        String originalBranchKey = CurThreadInfoUtils.getBranchKey();
        try {
            CurThreadInfoUtils.setBranchKey(branch);
            runnable.run();
        }
        finally {
            CurThreadInfoUtils.setBranchKey(originalBranchKey);
        }
    }
}

