/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import com.digiwin.athena.base.BusinessException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.util.StringUtils;

public class MD5 {
    public static String getFileMD5(String value) {
        String string;
        block10: {
            if (StringUtils.isEmpty((Object)value)) {
                return "";
            }
            InputStream in = MD5.convertStringToInputStream(value);
            try {
                int len;
                MessageDigest digest = MessageDigest.getInstance("MD5");
                byte[] buffer = new byte[1024];
                while ((len = in.read(buffer)) != -1) {
                    digest.update(buffer, 0, len);
                }
                BigInteger bigInt = new BigInteger(1, digest.digest());
                string = bigInt.toString(16);
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new BusinessException("Failed to obtain MD5 value of data, data:" + value);
                }
            }
            in.close();
        }
        return string;
    }

    private static InputStream convertStringToInputStream(String value) {
        ByteArrayInputStream result = new ByteArrayInputStream(value.getBytes(StandardCharsets.UTF_8));
        return result;
    }

    public static String getMD5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(input.getBytes());
            byte[] digest = md.digest();
            return MD5.bytesToHex(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("MD5 Algorithm not found", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(0xFF & b);
            if (hex.length() == 1) {
                hexString.append('0');
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

