/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.dao;

import com.digiwin.athena.domain.DeployLog;
import com.digiwin.athena.mongodb.repository.MongoPrimaryRepositoryDecorator;
import java.math.BigDecimal;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Repository;

@Repository
public class DeployLogMongoDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployLogMongoDao.class);
    @Autowired
    private MongoPrimaryRepositoryDecorator mongoPrimaryRepositoryDecorator;

    public void insert(DeployLog deployLog) {
        this.mongoPrimaryRepositoryDecorator.insert((Object)deployLog);
    }

    public void save(DeployLog deployLog) {
        this.mongoPrimaryRepositoryDecorator.save((Object)deployLog);
    }

    public void updateProcess(BigDecimal process, String deployNo) {
        Criteria criteria = Criteria.where((String)"deployNo").is((Object)deployNo);
        Update update = new Update().set("process", (Object)process);
        this.mongoPrimaryRepositoryDecorator.updateFirst(new Query((CriteriaDefinition)criteria), update, DeployLog.class);
    }

    public void updateResult(String result, String deployNo) {
        Criteria criteria = Criteria.where((String)"deployNo").is((Object)deployNo);
        Update update = new Update().set("result", (Object)result);
        this.mongoPrimaryRepositoryDecorator.updateFirst(new Query((CriteriaDefinition)criteria), update, DeployLog.class);
    }

    public void updateProcessAndResult(BigDecimal process, String result, String deployNo) {
        Criteria criteria = Criteria.where((String)"deployNo").is((Object)deployNo);
        Update update = new Update().set("process", (Object)process).set("result", (Object)result);
        this.mongoPrimaryRepositoryDecorator.updateFirst(new Query((CriteriaDefinition)criteria), update, DeployLog.class);
    }

    public void updateFailByApplicationAndResult(String application, List<String> results) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("result").in(results);
        Update update = new Update().set("result", (Object)"fail").set("process", (Object)-1);
        this.mongoPrimaryRepositoryDecorator.updateMulti(new Query((CriteriaDefinition)criteria), update, DeployLog.class);
    }

    public List<DeployLog> selectByAppAndResult(String application, List<String> results) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("result").in(results);
        return this.mongoPrimaryRepositoryDecorator.find(new Query((CriteriaDefinition)criteria), DeployLog.class);
    }

    public DeployLog selectByDeployNoAndApp(String deployNo, String application) {
        Criteria criteria = Criteria.where((String)"deployNo").is((Object)deployNo).and("application").is((Object)application);
        return (DeployLog)this.mongoPrimaryRepositoryDecorator.findOne(new Query((CriteriaDefinition)criteria), DeployLog.class);
    }

    public DeployLog selectSuccessOneByApplication(String application) {
        Criteria criteria = Criteria.where((String)"application").is((Object)application).and("result").is((Object)"success");
        Query query = new Query((CriteriaDefinition)criteria);
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        query.limit(1);
        return (DeployLog)this.mongoPrimaryRepositoryDecorator.findOne(query, DeployLog.class);
    }

    public DeployLog selectLastOne(String application) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"application").is((Object)application));
        query.with(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"_id"}));
        query.limit(1);
        return (DeployLog)this.mongoPrimaryRepositoryDecorator.findOne(query, DeployLog.class);
    }
}

