/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.publish;

import com.digiwin.athena.dao.DeployDetailMongoDao;
import com.digiwin.athena.domain.DeployDetail;
import com.digiwin.athena.dto.BusinessDto;
import com.digiwin.athena.dto.DeployDataDto;
import com.digiwin.athena.publish.PublishExtendOperation;
import com.digiwin.athena.publish.dto.PublishParam;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class Publish<T extends BusinessDto>
extends PublishExtendOperation<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Publish.class);
    @Autowired
    private DeployDetailMongoDao deployDetailMongoDao;

    public void publishOne(PublishParam publishParam) {
        T publishData = this.findSinglePublishData(publishParam);
        this.preHandle(publishData);
        this.doCompile(Arrays.asList(publishData));
        this.deleteSingleRuntimeData(publishData);
        this.insertSingleRuntimeData(publishData);
        this.postHandle(publishData);
    }

    public void publishAll(DeployDataDto<T> deployDataDto) {
        DeployDetail.DetailContent detailContent = null;
        try {
            List<T> allPublishData = deployDataDto.getPublishData();
            this.startPreHandle(deployDataDto);
            for (BusinessDto data : allPublishData) {
                Date start = new Date();
                detailContent = this.getDeployDetailContent(data);
                detailContent.setTime(start);
                this.preHandle(data);
                this.updateDeployDetail(deployDataDto, detailContent);
                this.deleteSingleRuntimeData(data);
                this.insertSingleRuntimeData(data);
                this.postHandle(data);
                Date end = new Date();
                detailContent.setTime(end);
                detailContent.setResult("success");
                detailContent.setExecuteTimeMills(end.getTime() - start.getTime());
                this.updateDeployDetail(deployDataDto, detailContent);
            }
            this.endPostHandle(deployDataDto);
        }
        catch (Exception e) {
            log.error("publishAll exception:" + e.getMessage(), (Throwable)e);
            detailContent.setResult("fail").setErrorStack(Publish.getStackTraceAsStrings(e)).setCause(e.toString());
            this.updateDeployDetail(deployDataDto, detailContent);
            throw new RuntimeException(e);
        }
    }

    protected static String[] getStackTraceAsStrings(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        String[] stackStrings = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            stackStrings[i] = elements[i].toString();
        }
        return stackStrings;
    }

    public DeployDetail.DetailContent getDeployDetailContent(T data) {
        return new DeployDetail.DetailContent();
    }

    private void updateDeployDetail(DeployDataDto<T> deployDataDto, DeployDetail.DetailContent detailContent) {
        if (StringUtils.isEmpty((CharSequence)deployDataDto.getDeployNo()) || StringUtils.isEmpty((CharSequence)deployDataDto.getAdpApplication())) {
            return;
        }
        this.deployDetailMongoDao.updatePushContent(deployDataDto.getDeployNo(), deployDataDto.getAdpApplication(), detailContent);
    }

    abstract void deleteRuntimeData(DeployDataDto<T> var1);

    public abstract List<T> findAllPublishData(PublishParam var1);

    abstract void insertSingleRuntimeData(T var1);

    abstract void deleteSingleRuntimeData(T var1);

    abstract T findSinglePublishData(PublishParam var1);
}

