/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.appCustomConfig;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.dao.ApplicationCustomConfigV2MongoDao;
import com.digiwin.athena.dao.CustomControlRelationV2MongoDao;
import com.digiwin.athena.domain.ApplicationCustomConfig;
import com.digiwin.athena.domain.CustomControlRelation;
import com.digiwin.athena.domain.CustomControlRes;
import com.digiwin.athena.domain.SysApplicationCustomConfig;
import com.digiwin.athena.domain.SysApplicationCustomConfigShare;
import com.digiwin.athena.service.appCustomConfig.event.CustomControlEventManager;
import com.digiwin.athena.service.tenant.TenantService;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.user.UserHelper;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class CustomControlEventListener {
    @Resource
    protected TenantService tenantService;
    @Resource
    protected CustomControlEventManager customControlEventManager;
    @Resource
    protected ApplicationCustomConfigV2MongoDao applicationCustomConfigV2MongoDao;
    @Resource
    protected CustomControlRelationV2MongoDao customControlRelationV2MongoDao;
    protected static final String regexFormat = "\"isvCustomType\":\"(%s)\"";

    public abstract void doEvent(Object var1);

    @PostConstruct
    public void init() {
        this.customControlEventManager.registerListener(this.getType(), this);
    }

    protected abstract CustomControlEventManager.EvenType getType();

    protected Pattern createPattern(Map<String, String> typeMapCode) {
        String types = typeMapCode.keySet().stream().map(s -> Pattern.quote(s)).collect(Collectors.joining("|"));
        String regex = String.format(regexFormat, types);
        Pattern pattern = Pattern.compile(regex);
        return pattern;
    }

    protected Map<String, String> getTypeMapCodeRes(String application, String tenantId) {
        List<CustomControlRes> customControl;
        List<String> adpCodeLit;
        List<ApplicationCustomConfig> applicationCustomConfigsList = this.applicationCustomConfigV2MongoDao.selectAppControlType(application);
        List<SysApplicationCustomConfig> sysApplicationCustomConfigList = this.applicationCustomConfigV2MongoDao.selectSysControlType(tenantId);
        List<SysApplicationCustomConfigShare> sysApplicationCustomConfigShareList = this.applicationCustomConfigV2MongoDao.findSysShareByShareTenantId(tenantId);
        if (CollectionUtil.isNotEmpty(sysApplicationCustomConfigShareList) && CollectionUtil.isNotEmpty(adpCodeLit = sysApplicationCustomConfigShareList.stream().map(SysApplicationCustomConfigShare::getAdpCode).collect(Collectors.toList()))) {
            List<SysApplicationCustomConfig> sysByAdpCodeList = this.applicationCustomConfigV2MongoDao.findSysByAdpCodeList4Share(adpCodeLit);
            for (SysApplicationCustomConfig sysApplicationCustomConfig : sysByAdpCodeList) {
                if (sysApplicationCustomConfig.getCustomControl().isEmpty()) continue;
                sysApplicationCustomConfigList.add(sysApplicationCustomConfig);
            }
        }
        HashMap<String, String> typeMapCode = new HashMap<String, String>();
        for (ApplicationCustomConfig applicationCustomConfig : applicationCustomConfigsList) {
            customControl = applicationCustomConfig.getCustomControl();
            for (CustomControlRes customControlRes : customControl) {
                typeMapCode.put(customControlRes.getType(), applicationCustomConfig.getAdpCode());
            }
        }
        for (SysApplicationCustomConfig sysApplicationCustomConfig : sysApplicationCustomConfigList) {
            customControl = sysApplicationCustomConfig.getCustomControl();
            for (CustomControlRes customControlRes : customControl) {
                typeMapCode.put(customControlRes.getType(), sysApplicationCustomConfig.getAdpCode());
            }
        }
        return typeMapCode;
    }

    protected List<CustomControlRelation> matchGenerateRelation(Map<String, Object> pages, Map<String, String> typeMapCode, Pattern pattern, CustomControlRelation param) {
        ArrayList<CustomControlRelation> customControlRelations = new ArrayList<CustomControlRelation>();
        if (CollectionUtils.isEmpty(pages)) {
            return customControlRelations;
        }
        for (Map.Entry<String, Object> entry : pages.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String content = JSONObject.toJSONString((Object)value);
            Matcher matcher = pattern.matcher(content);
            HashSet<String> typeSet = new HashSet<String>();
            while (matcher.find()) {
                String matchTypeKey = matcher.group(1);
                typeSet.add(matchTypeKey);
            }
            typeSet.forEach(t -> {
                CustomControlRelation customControlRelation = new CustomControlRelation();
                customControlRelation.setAdpApplication(param.getAdpApplication());
                customControlRelation.setAdpTenantId(param.getAdpTenantId());
                customControlRelation.setSourceCode((String)typeMapCode.get(t));
                customControlRelation.setCustomControlType((String)t);
                customControlRelation.setTargetCode(param.getTargetCode());
                customControlRelation.setTargetType(this.getType().getCode());
                customControlRelation.setUiKey(StringUtils.isEmpty((Object)param.getUiKey()) ? key : param.getUiKey());
                customControlRelation.setName(param.getName());
                customControlRelation.setLang(param.getLang());
                customControlRelation.setExtFieldInfo(param.getExtFieldInfo());
                customControlRelation.setDataViewQueryCode(param.getDataViewQueryCode());
                customControlRelation.setAdpVersion(CurThreadInfoUtils.getAdpVersion());
                UserHelper.fillCreateInfo((Object)customControlRelation);
                UserHelper.fillEditInfo((Object)customControlRelation);
                customControlRelations.add(customControlRelation);
            });
        }
        return customControlRelations;
    }

    protected void handleResult(String targetCode, List<CustomControlRelation> customControlRelations) {
        if (StringUtils.isEmpty((Object)CurThreadInfoUtils.getAdpVersion())) {
            this.customControlRelationV2MongoDao.deleteByTargetCode(targetCode);
        } else {
            this.customControlRelationV2MongoDao.deleteByTargetCodeAndAdpVersion(targetCode, CurThreadInfoUtils.getAdpVersion());
        }
        if (!customControlRelations.isEmpty()) {
            this.customControlRelationV2MongoDao.insertAll(customControlRelations);
        }
    }
}

