/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.codeStandard;

import com.alibaba.fastjson.JSON;
import com.digiwin.athena.base.BusinessException;
import com.digiwin.athena.mongodb.domain.other.PresetData;
import com.digiwin.athena.mongodb.repository.MongoSystemRepositoryDecorator;
import com.digiwin.athena.service.codeStandard.CodeGenerateHandler;
import com.digiwin.athena.service.codeStandard.dto.GenerateCodeDto;
import com.digiwin.athena.service.codeStandard.dto.RuleConfig;
import com.digiwin.athena.utils.CurThreadInfoUtils;
import com.digiwin.athena.utils.SnowflakeToHexStrUtil;
import com.digiwin.athena.utils.pageDesignModel.BusinessResourceTreeUtil;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class CodeGeneratorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CodeGeneratorService.class);
    @Autowired
    private Map<String, CodeGenerateHandler> handlers;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MongoSystemRepositoryDecorator mongoSystemRepositoryDecorator;

    public String generateCode(GenerateCodeDto generateCodeDto) {
        log.info("generateCode start,generateCodeDto param is:{}", (Object)JSON.toJSONString((Object)generateCodeDto));
        RuleConfig ruleConfig = this.getRulesFromDB(generateCodeDto.getTypeCode());
        assert (ruleConfig != null);
        Object code = this.createCodeByRule(ruleConfig, generateCodeDto.getParamMap());
        if (CurThreadInfoUtils.getIndividualCase().booleanValue()) {
            code = "UC_" + (String)code;
        }
        return code;
    }

    private String createCodeByRule(RuleConfig ruleConfig, Map<String, String> paramMap) {
        StringBuilder finalCode = new StringBuilder();
        for (RuleConfig.CodeRule rule : ruleConfig.getRules()) {
            CodeGenerateHandler handler = this.handlers.get(rule.getGenerateHandler());
            if (handler == null) {
                throw new BusinessException("Handler not found for: " + rule.getGenerateHandler());
            }
            Map<String, String> params = Optional.ofNullable(rule.getParams()).orElseGet(Collections::emptyList).stream().filter(Objects::nonNull).collect(Collectors.toMap(RuleConfig.CodeRuleParam::getKey, RuleConfig.CodeRuleParam::getValue));
            finalCode.append(handler.generateCode(params, paramMap));
        }
        String generatedCode = finalCode.toString();
        log.info("Generated standard code is: {}", (Object)generatedCode);
        return generatedCode;
    }

    private RuleConfig getRulesFromDB(String typeCode) {
        Criteria criteria = Criteria.where((String)"key").is((Object)typeCode);
        PresetData presetData = (PresetData)this.mongoSystemRepositoryDecorator.findOne(Query.query((CriteriaDefinition)criteria), PresetData.class);
        if (presetData == null) {
            log.warn("No configuration found for typeCode: {}", (Object)typeCode);
            throw new BusinessException("No configuration found for typeCode");
        }
        Object obj = presetData.getObj();
        log.info("Fetching configuration for typeCode: {}, returned data: {}", (Object)typeCode, (Object)JSON.toJSONString((Object)obj));
        return (RuleConfig)this.objectMapper.convertValue(obj, RuleConfig.class);
    }

    public void insertData(GenerateCodeDto generateCodeDto) {
        RuleConfig ruleConfig = generateCodeDto.getRuleConfig();
        if (ruleConfig == null || ruleConfig.getCode() == null) {
            throw new BusinessException("RuleConfig or its code cannot be null.");
        }
        PresetData presetData = new PresetData();
        presetData.setKey(ruleConfig.getCode());
        presetData.setObj((Object)ruleConfig);
        try {
            this.mongoSystemRepositoryDecorator.save((Object)presetData);
        }
        catch (Exception e) {
            log.error("Failed to save PresetData: ", (Throwable)e);
            throw new BusinessException("Failed to save PresetData", (Throwable)e);
        }
    }

    public void deleteData(String key) {
        try {
            PresetData presetData = (PresetData)this.mongoSystemRepositoryDecorator.findOne(BusinessResourceTreeUtil.buildQuery("key", key), PresetData.class);
            if (presetData == null) {
                log.warn("No configuration found for key: {}", (Object)key);
            } else {
                log.info("Deleting PresetData: {}", (Object)JSON.toJSONString((Object)presetData));
                this.mongoSystemRepositoryDecorator.delete((Object)presetData);
            }
        }
        catch (Exception e) {
            log.error("Failed to delete PresetData: ", (Throwable)e);
            throw new BusinessException("Failed to delete PresetData", (Throwable)e);
        }
    }

    public String generateCodeOfFront(GenerateCodeDto generateCodeDto) {
        Map<String, String> paramMap = generateCodeDto.getParamMap();
        String str = SnowflakeToHexStrUtil.snowflakeToHex();
        paramMap.put("inputCode", str);
        return this.generateCode(generateCodeDto);
    }
}

