/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.service.codeStandard.impl;

import com.digiwin.athena.service.codeStandard.CodeGenerateHandler;
import java.security.SecureRandom;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="autoCodeGenerateHandler")
public class AutoCodeGenerateHandler
implements CodeGenerateHandler {
    private static final String CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final SecureRandom secureRandom = new SecureRandom();

    @Override
    public String generateCode(Map<String, String> params, Map<String, String> param) {
        int length;
        String codeLengthStr = params.getOrDefault("len", "8");
        String characters = params.getOrDefault("characters", CHARACTERS);
        try {
            length = Integer.parseInt(codeLengthStr);
        }
        catch (NumberFormatException e) {
            length = 8;
        }
        return AutoCodeGenerateHandler.generateRandomString(length, characters);
    }

    public static String generateRandomString(int length, String characters) {
        if (length <= 0 || characters.isEmpty()) {
            throw new IllegalArgumentException("Length must be positive and characters cannot be empty");
        }
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = secureRandom.nextInt(characters.length());
            sb.append(characters.charAt(index));
        }
        return sb.toString();
    }
}

