/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.utils;

import cn.hutool.extra.spring.SpringUtil;
import com.digiwin.athena.dto.TenantInfo;
import com.digiwin.athena.service.UserInfoInterface;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import jakarta.xml.bind.DatatypeConverter;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class JwtUtil
implements ApplicationContextAware {
    private static UserInfoInterface userInfoInterface;
    private static String PRIVATE_KEY;
    private static final SignatureAlgorithm SIGNATURE_ALGORITHM;
    private static byte[] API_BYTES_KEY;
    private static Key SIGNING_KEY;

    public static Jws<Claims> parseToken(String token) {
        Key fxJwtKey = (Key)SpringUtil.getBean((String)"fxJwtKey", Key.class);
        return Jwts.parser().setSigningKey(fxJwtKey).parseClaimsJws(token);
    }

    public static TenantInfo getTenantInfo(String userToken) {
        return userInfoInterface.parseTokenGetTenantInfo(userToken);
    }

    public static String getTenantTeamId(String token) {
        TenantInfo tenantInfo = JwtUtil.getTenantInfo(token);
        return tenantInfo.getTeamId();
    }

    public static String generateToken(Map<String, Object> claims, String subject, Date expiration) {
        JwtBuilder builder = Jwts.builder().signWith(SIGNATURE_ALGORITHM, SIGNING_KEY);
        if (claims != null) {
            builder.setClaims(claims);
        }
        if (subject != null) {
            builder.setSubject(subject);
        }
        if (expiration != null) {
            builder.setExpiration(expiration);
        }
        builder.setIssuedAt(new Date());
        return builder.compact();
    }

    public static String generateToken(String subject) {
        return JwtUtil.generateToken(null, subject, null);
    }

    public static void main(String[] args) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("c_user", "jiangmq");
        map.put("c_user_n1", "\u848b\u660e\u5f3a");
        map.put("c_ent", "99");
        map.put("c_org_n1", "\u5f00\u53d1\u5e73\u53f0\u6d4b\u8bd5\u79df\u6237");
        String subject = "{\"profile\":{\"pwd_ttl_expire\":\"N\",\"abjtype\":\"001\",\"c_obj\":\"admin\",\"isFirstLogin\":\"N\",\"primerKey\":\"jiangmq\",\"c_user\":\"jiangmq\",\"c_per_n1\":\"\u7cfb\u7edf\u7ba1\u7406\u5458\",\"daecurr\":\"CNY\",\"groupList\":[{\"name\":\"\u529e\u516c\",\"icon\":\"anticon-solution\",\"aaa003\":1,\"id\":\"01\"},{\"name\":\"\u5ba2\u6237\u7ba1\u7406\",\"icon\":\"anticon-team\",\"aaa003\":2,\"id\":\"02\"},{\"name\":\"\u5ba2\u6237\u5206\u6790\",\"aaa003\":3,\"id\":\"03\"}],\"c_dept_n1\":\"\u9500\u552e\u4e00\u90e8\",\"c_ent\":99,\"c_objtype\":\"1\",\"c_lanc_n1\":\"\u7b80\u4f53\u4e2d\u6587\",\"eff_time\":\"24\",\"c_lang\":\"zh_CN\",\"c_org\":\"100001\",\"c_curr\":\"CNY\",\"c_dept\":\"100001\",\"c_user_n1\":\"\u848b\u660e\u5f3a\",\"c_per\":\"admin\",\"pwd_ttl_expire_rule\":\"0\",\"c_org_n1\":\"\u9f0e\u6377\u6570\u667a\"}}\n";
        String s = JwtUtil.generateToken(map, subject, new Date(System.currentTimeMillis() + 604800000L));
        System.out.println(s);
        Jws<Claims> claimsJws = JwtUtil.parseToken(s);
        System.out.println(((Claims)claimsJws.getBody()).getSubject());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        userInfoInterface = (UserInfoInterface)applicationContext.getBean(UserInfoInterface.class);
    }

    static {
        PRIVATE_KEY = "1IRAzkp2rS9bbNEbQQCkMGeNG53hxq2NnsIrnsc1RKZxd4jLEGEnh6QExwH6at2o";
        SIGNATURE_ALGORITHM = SignatureAlgorithm.HS512;
        API_BYTES_KEY = DatatypeConverter.parseBase64Binary((String)PRIVATE_KEY);
        SIGNING_KEY = new SecretKeySpec(API_BYTES_KEY, SIGNATURE_ALGORITHM.getJcaName());
    }
}

