/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.activity;

import com.digiwin.athena.uibot.activity.DesignerAbstractPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.DataSourceSetDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.activity.domain.TmAction;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.activity.domain.TmDataFilter;
import com.digiwin.athena.uibot.activity.domain.TmDataState;
import com.digiwin.athena.uibot.activity.domain.TmOperation;
import com.digiwin.athena.uibot.activity.domain.TmPage;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.activity.service.TaskDataSourceAnalysisService;
import com.digiwin.athena.uibot.activity.service.TmPageOperationService;
import com.digiwin.athena.uibot.activity.service.TmPageSubmitService;
import com.digiwin.athena.uibot.support.adp.AthenaDesignerService;
import com.digiwin.athena.uibot.support.atmc.domain.BacklogData;
import com.digiwin.athena.uibot.support.atmc.domain.ProjectData;
import com.digiwin.athena.uibot.support.atmc.domain.TaskWithBacklogData;
import com.digiwin.athena.uibot.util.AttachmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignerTaskPageAnalyzer
extends DesignerAbstractPageDefineAnalyzer<TaskPageDefine> {
    @Resource
    AthenaDesignerService athenaDesignerService;
    @Resource
    TmPageOperationService tmPageOperationService;
    @Resource
    TmPageSubmitService tmPageSubmitService;
    @Autowired
    TaskDataSourceAnalysisService taskDataSourceAnalysisService;

    public List<TaskPageDefine> analysis(ExecuteContext executeContext) {
        executeContext.setIsDesigner(Boolean.valueOf(true));
        TmActivity tmActivity = this.athenaDesignerService.getActivityWithoutTaskId(executeContext.getPageCode(), executeContext.getTmActivityId(), executeContext.getLocale());
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefines(executeContext, tmActivity);
    }

    public List<TaskPageDefine> newPageAnalysis(ExecuteContext executeContext, Map<String, TmQueryAction> dataSources) {
        executeContext.setIsDesigner(Boolean.valueOf(true));
        TmActivity tmActivity = this.athenaDesignerService.getActivityWithoutTaskId(executeContext.getPageCode(), executeContext.getTmActivityId(), executeContext.getLocale());
        if (MapUtils.isNotEmpty(dataSources)) {
            tmActivity.setDataSources(dataSources);
        }
        executeContext.appendTmActivityInfo(tmActivity);
        return super.createPageDefines(executeContext, tmActivity);
    }

    @Override
    public void analysisBaseInfo(ExecuteContext executeContext, TaskPageDefine pageDefine, TmActivity tmActivity, TmPage tmPage) {
        if (executeContext.getTaskWithBacklogDataList() == null || executeContext.getTaskWithBacklogDataList().size() == 0) {
            return;
        }
        pageDefine.setPrePerformer(tmPage.getPrePerformer());
        pageDefine.setSubjectMatter(tmPage.getSubjectMatter());
        pageDefine.setSubjectMatterTargets(tmPage.getSubjectMatterTargets());
        pageDefine.setSubjectMatterProperties(tmPage.getSubjectMatterProperties());
        pageDefine.setRoleAttention(tmPage.getRoleAttention());
        pageDefine.setStartApproveActivityName(tmActivity.getStartApproveActivityName());
        pageDefine.setStartApproveActivity(tmActivity.getStartApproveActivity());
        pageDefine.setVersion(tmActivity.isFlowEngine() != false ? "1.0" : "2.0");
        pageDefine.setDomain(tmPage.getDomain());
        pageDefine.setDataKeyProperties(tmPage.getDataKeyProperties());
        pageDefine.setSubjectExpect(tmPage.getSubjectExpect());
        pageDefine.setSubjectShortfall(tmPage.getSubjectShortfall());
    }

    @Override
    protected TaskPageDefine createNewPageDefine() {
        return new TaskPageDefine();
    }

    @Override
    protected void addDefaultConfigInfo(ExecuteContext executeContext, TmActivity tmActivity) {
        AttachmentUtil.addDefaultAttachmentDataSourceProcess((ExecuteContext)executeContext, (TmActivity)tmActivity);
        AttachmentUtil.appendEffectAfterSubmitAction((ExecuteContext)executeContext, (TmActivity)tmActivity);
    }

    @Override
    protected void analysisSubmitActions(ExecuteContext executeContext, TaskPageDefine pageDefine, TmActivity tmActivity, TmDataState dataState, List<TmAction> submitActions) {
        this.tmPageSubmitService.processBaseData(executeContext, tmActivity, dataState, (PageDefine)pageDefine);
    }

    @Override
    protected void analysisOperators(ExecuteContext executeContext, TaskPageDefine pageDefine, TmActivity tmActivity, List<TmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, (PageDefine)pageDefine, tmActivity, operations);
    }

    @Override
    protected void analysisDataSource(ExecuteContext executeContext, TaskPageDefine pageDefine, TmActivity tmActivity, TmDataState tmDataState, Map<String, TmQueryAction> dataSources, TmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        if (CollectionUtils.isEmpty((Collection)executeContext.getTaskWithBacklogDataList())) {
            this.mockGetTaskWithBacklogDataList(executeContext, dataSources);
        }
        DataSourceSetDTO dataSourceSet = this.taskDataSourceAnalysisService.analysis(executeContext, tmDataState, dataSources, tmDataFilter);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
        if (null != tmDataFilter) {
            pageDefine.setQueryTitle(tmDataFilter.getTitle());
            pageDefine.setRowSizeType(tmDataFilter.getRowSizeType());
        }
    }

    private void mockGetTaskWithBacklogDataList(ExecuteContext executeContext, Map<String, TmQueryAction> dataSources) {
        ArrayList<TaskWithBacklogData> taskWithBacklogDataList = new ArrayList<TaskWithBacklogData>();
        TaskWithBacklogData taskWithBacklogData = new TaskWithBacklogData();
        HashMap<String, String> businessUnit = new HashMap<String, String>();
        businessUnit.put("eoc_company_id", "TCm02");
        businessUnit.put("eoc_site_id", "Pt02");
        taskWithBacklogData.setBusinessUnit(businessUnit);
        ArrayList<BacklogData> backlogList = new ArrayList<BacklogData>();
        BacklogData backlogData = new BacklogData();
        backlogData.setBacklogId(Long.valueOf(12345L));
        backlogList.add(backlogData);
        taskWithBacklogData.setBacklog(backlogList);
        HashMap bpmData = new HashMap();
        bpmData.put(dataSources.keySet().iterator().next(), new HashMap());
        taskWithBacklogData.setBpmData(bpmData);
        taskWithBacklogDataList.add(taskWithBacklogData);
        executeContext.setTaskWithBacklogDataList(taskWithBacklogDataList);
        ProjectData projectData = new ProjectData();
        projectData.setTenantId(executeContext.getTenantId());
        executeContext.setProjectData(projectData);
    }
}

