/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.uibot.constant.WordsConstants;
import com.digiwin.athena.uibot.dao.WordDao;
import com.digiwin.athena.uibot.dao.WordDeviationDegreeDao;
import com.digiwin.athena.uibot.domain.word.BaseEntity;
import com.digiwin.athena.uibot.domain.word.PastWordsRecords;
import com.digiwin.athena.uibot.domain.word.WordCategory;
import com.digiwin.athena.uibot.domain.word.WordDeviationDegree;
import com.digiwin.athena.uibot.mapper.PastWordsRecordsMapper;
import com.digiwin.athena.uibot.mapper.WordCategoryMapper;
import com.digiwin.athena.uibot.param.req.WordRequest;
import com.digiwin.athena.uibot.support.thememap.param.req.TaskWordsRequest;
import com.digiwin.athena.uibot.support.thememap.param.resp.TaskWordResponse;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EnhancedWordScheduler {
    private static final Logger log = LoggerFactory.getLogger(EnhancedWordScheduler.class);
    @Value(value="${uibot.word.enhanced.enable}")
    private Boolean enhancedEnable;
    @Value(value="${uibot.word.enhanced.cron}")
    private String enhancedCron;
    @Value(value="${uibot.word.deviationCalculate.cron}")
    private String deviationCalculateCron;
    @Resource
    private ThemeMapService themeMapService;
    @Resource
    private PastWordsRecordsMapper pastWordsRecordsMapper;
    @Resource
    private WordCategoryMapper wordCategoryMapper;
    @Resource
    private WordDeviationDegreeDao wordDeviationDegreeDao;
    @Resource
    private WordDao wordDao;
    private static final String EMPTY_ARR_STR = "[]";

    @Async
    @Scheduled(cron="${uibot.word.enhanced.cron}")
    public void enhancedWord() {
        log.info("=== WordEnhancedEnable: {}, cron: {}", (Object)this.enhancedEnable, (Object)this.enhancedCron);
        if (BooleanUtils.isNotTrue((Boolean)this.enhancedEnable)) {
            return;
        }
        log.info("=== WordEnhancedEnable begin");
        long start = System.currentTimeMillis();
        try {
            List<String> pageCodes = Arrays.asList("task-detail", "project-detail");
            ArrayList<PastWordsRecords> pastWordsRecordsList = new ArrayList<PastWordsRecords>();
            HashSet existWordListLocalCache = new HashSet();
            int count = 0;
            for (String pageCode : pageCodes) {
                WordRequest wordRequest = new WordRequest();
                wordRequest.setPageCode(pageCode);
                List taskWordResponseList = this.themeMapService.getTasksForWord(TaskWordsRequest.builder().build().copy(wordRequest));
                List getShowMetaDatalist = taskWordResponseList.stream().filter(words -> words.getDimension() != null).collect(Collectors.toList());
                for (TaskWordResponse taskWordResponse : getShowMetaDatalist) {
                    TaskWordResponse.ShowMetadata showMetadatas;
                    List dataStates;
                    List categories = taskWordResponse.getDimension().getCategories();
                    if (CollectionUtils.isEmpty((Collection)categories) || CollectionUtils.isEmpty((Collection)(dataStates = taskWordResponse.getDataStates())) || (showMetadatas = ((TaskWordResponse.DataState)dataStates.get(0)).getShowMetadatas()) == null) continue;
                    List dataSourceNames = taskWordResponse.getDataSourceNames();
                    String dataSourceName = CollectionUtils.isEmpty((Collection)dataSourceNames) ? null : (String)dataSourceNames.get(0);
                    PastWordsRecords pastWordsRecords = new PastWordsRecords();
                    pastWordsRecordsList.add(pastWordsRecords);
                    pastWordsRecords.setPageCode(pageCode);
                    pastWordsRecords.setPattern(taskWordResponse.getPattern());
                    pastWordsRecords.setCategory(taskWordResponse.getCategory());
                    pastWordsRecords.setActivityId(taskWordResponse.getActivityId());
                    pastWordsRecords.setDataSourceName(dataSourceName);
                    pastWordsRecords.setDimensionCategories(StringUtils.join((Iterable)taskWordResponse.getDimension().getCategories(), (String)","));
                    pastWordsRecords.setNewScoreWords(JsonUtils.objectToString((Object)showMetadatas.getNewScoreWords()));
                    pastWordsRecords.setOldScoreWords(JsonUtils.objectToString((Object)showMetadatas.getOldScoreWords()));
                    List words2 = showMetadatas.getNewScoreWords().stream().map(TaskWordResponse.NewWordScore::getFields).flatMap(Collection::stream).map(TaskWordResponse.WordScoreField::getFieldName).distinct().collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(words2)) continue;
                    count += this.wordDao.saveBatchOrSkipWord(words2, existWordListLocalCache);
                    categories.forEach(category -> {
                        List wordCategories = this.wordCategoryMapper.queryWordsByCategory(category);
                        List existWords = wordCategories.stream().map(WordCategory::getWordCode).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                        List newWords = words2.stream().filter(word -> !existWords.contains(word)).collect(Collectors.toList());
                        ArrayList<WordCategory> wordCategoryList = new ArrayList<WordCategory>();
                        for (String word2 : newWords) {
                            WordCategory wordCategory = new WordCategory();
                            wordCategory.setWordCategoryId(word2 + "_" + category);
                            wordCategory.setWordCode(word2);
                            wordCategory.setCategoryCode(category);
                            wordCategory.setStatus(Long.valueOf(1L));
                            wordCategory.setSource(WordsConstants.Source.DESIGNER);
                            wordCategoryList.add(wordCategory);
                        }
                        if (CollectionUtils.isNotEmpty(wordCategoryList)) {
                            this.wordCategoryMapper.insertBatch(wordCategoryList);
                        }
                        ArrayList wordCategoryIds = new ArrayList();
                        List<String> remainWords = words2.stream().filter(word -> existWords.contains(word)).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(remainWords)) {
                            remainWords.forEach(word -> wordCategoryIds.add(word + "_" + category));
                            if (CollectionUtils.isNotEmpty(wordCategoryIds)) {
                                this.wordCategoryMapper.updateBatchStatus(wordCategoryIds);
                            }
                        }
                    });
                }
            }
            if (CollectionUtils.isNotEmpty(pastWordsRecordsList)) {
                this.pastWordsRecordsMapper.insertBatch(pastWordsRecordsList);
            }
            log.info("=== WordEnhancedEnable new word count: {}", (Object)count);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        log.info("=== WordEnhancedEnable finish, cost: {}ms", (Object)(System.currentTimeMillis() - start));
    }

    @Async
    @Transactional
    @Scheduled(cron="${uibot.word.deviationCalculate.cron}")
    public void deviationCalculate() {
        log.info("=== WordEnhancedEnable: {}, deviationCalculateCron: {}", (Object)this.enhancedEnable, (Object)this.deviationCalculateCron);
        if (BooleanUtils.isNotTrue((Boolean)this.enhancedEnable)) {
            return;
        }
        log.info("=== WordDeviationCalculate begin");
        long start = System.currentTimeMillis();
        DateTime now = DateTime.now();
        DateTime beginOfDay = DateUtil.beginOfDay((Date)now);
        DateTime endOfDay = DateUtil.endOfDay((Date)now);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PastWordsRecords.class).isNotNull(PastWordsRecords::getOldScoreWords)).isNotNull(PastWordsRecords::getNewScoreWords)).ne(PastWordsRecords::getOldScoreWords, (Object)EMPTY_ARR_STR)).ne(PastWordsRecords::getNewScoreWords, (Object)EMPTY_ARR_STR)).ge(BaseEntity::getCreateTime, (Object)beginOfDay)).le(BaseEntity::getCreateTime, (Object)endOfDay);
        List pastWordsRecordsList = this.pastWordsRecordsMapper.selectList((Wrapper)queryWrapper);
        this.wordDeviationDegreeDao.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WordDeviationDegree.class).ge(WordDeviationDegree::getCreateTime, (Object)beginOfDay)).le(WordDeviationDegree::getCreateTime, (Object)endOfDay));
        HashMap<String, List<PastWordsRecords>> categoryCodeMap = new HashMap<String, List<PastWordsRecords>>();
        for (PastWordsRecords pastWordsRecords : pastWordsRecordsList) {
            String dimensionCategories = pastWordsRecords.getDimensionCategories();
            List categoryCodeList = StrUtil.split((CharSequence)dimensionCategories, (CharSequence)",");
            if (CollectionUtils.isEmpty((Collection)categoryCodeList)) continue;
            for (String categoryCode : categoryCodeList) {
                categoryCodeMap.putIfAbsent(categoryCode, Lists.newArrayList());
                ((List)categoryCodeMap.get(categoryCode)).add(pastWordsRecords);
            }
        }
        this.saveBatch(categoryCodeMap, "DIMENSION_CATEGORY");
        Map<String, List<PastWordsRecords>> activityIdMap = pastWordsRecordsList.stream().filter(ele -> Objects.nonNull(ele.getActivityId())).collect(Collectors.groupingBy(PastWordsRecords::getActivityId));
        this.saveBatch(activityIdMap, "TASK");
        Map<String, List<PastWordsRecords>> dataSourceNameMap = pastWordsRecordsList.stream().filter(ele -> Objects.nonNull(ele.getDataSourceName())).collect(Collectors.groupingBy(PastWordsRecords::getDataSourceName));
        this.saveBatch(dataSourceNameMap, "API");
        log.info("=== WordDeviationCalculate finish, cost: {}ms", (Object)(System.currentTimeMillis() - start));
    }

    private void saveBatch(Map<String, List<PastWordsRecords>> map, String type) {
        ArrayList wordDeviationDegreeList = Lists.newArrayList();
        map.forEach((k, v) -> {
            double value = this.calculateDegree((List<PastWordsRecords>)v, (String)k, type);
            WordDeviationDegree wordDeviationDegree = new WordDeviationDegree();
            wordDeviationDegree.setType(type);
            wordDeviationDegree.setDeviationDegreeKey(k);
            wordDeviationDegree.setDeviationDegreeValue(Double.valueOf(value));
            wordDeviationDegreeList.add(wordDeviationDegree);
        });
        this.wordDeviationDegreeDao.saveBatch((Collection)wordDeviationDegreeList);
    }

    private PastWordsRecords getPastWordsRecordsEarliest(String key, String type) {
        PastWordsRecords earliestRecord;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PastWordsRecords.class).isNotNull(PastWordsRecords::getOldScoreWords)).isNotNull(PastWordsRecords::getNewScoreWords)).ne(PastWordsRecords::getOldScoreWords, (Object)EMPTY_ARR_STR)).ne(PastWordsRecords::getNewScoreWords, (Object)EMPTY_ARR_STR)).orderByAsc(BaseEntity::getCreateTime)).last("limit 1");
        switch (type) {
            case "DIMENSION_CATEGORY": {
                key = ',' + key + ',';
                earliestRecord = (PastWordsRecords)this.pastWordsRecordsMapper.selectOne((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().like((Object)"CONCAT(',',dimension_categories,',')", (Object)key)).isNotNull((Object)"old_score_words")).isNotNull((Object)"new_score_words")).ne((Object)"old_score_words", (Object)EMPTY_ARR_STR)).ne((Object)"new_score_words", (Object)EMPTY_ARR_STR)).orderByAsc((Object)"create_time")).last("limit 1"));
                break;
            }
            case "TASK": {
                queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PastWordsRecords::getActivityId, (Object)key);
                earliestRecord = (PastWordsRecords)this.pastWordsRecordsMapper.selectOne((Wrapper)queryWrapper);
                break;
            }
            default: {
                queryWrapper = (LambdaQueryWrapper)queryWrapper.eq(PastWordsRecords::getDataSourceName, (Object)key);
                earliestRecord = (PastWordsRecords)this.pastWordsRecordsMapper.selectOne((Wrapper)queryWrapper);
            }
        }
        return earliestRecord;
    }

    private double calculateDegree(List<PastWordsRecords> pastWordsRecordsList, String key, String type) {
        double degreeAll = 0.0;
        int count = pastWordsRecordsList.size();
        HashMap<String, String> localCache = new HashMap<String, String>();
        for (PastWordsRecords pastWordsRecords : pastWordsRecordsList) {
            Object newWordScore2;
            String newScoreWords = pastWordsRecords.getNewScoreWords();
            String oldScoreWords = pastWordsRecords.getOldScoreWords();
            if (StringUtils.isEmpty((CharSequence)(oldScoreWords = this.getEarliestOldScoreWords(key, type, localCache, oldScoreWords)))) continue;
            List newWordScoreList = JSONUtil.toList((String)newScoreWords, TaskWordResponse.NewWordScore.class);
            List oldWordScoreList = JSONUtil.toList((String)oldScoreWords, TaskWordResponse.OldWordScore.class);
            if (CollectionUtils.isEmpty((Collection)newWordScoreList) || CollectionUtils.isEmpty((Collection)oldWordScoreList)) continue;
            ArrayList newWordCodeList = Lists.newArrayList();
            for (Object newWordScore2 : newWordScoreList) {
                List fields = newWordScore2.getFields();
                newWordCodeList.addAll(fields.stream().map(TaskWordResponse.WordScoreField::getFieldName).collect(Collectors.toList()));
            }
            ArrayList oldWordCodeList = Lists.newArrayList();
            newWordScore2 = oldWordScoreList.iterator();
            while (newWordScore2.hasNext()) {
                TaskWordResponse.OldWordScore oldWordScore = (TaskWordResponse.OldWordScore)newWordScore2.next();
                TaskWordResponse.OldWordFeature feature = oldWordScore.getFeature();
                List others = feature.getOthers();
                oldWordCodeList.addAll(others.stream().map(TaskWordResponse.OtherFeature::getWord).collect(Collectors.toList()));
            }
            Collection union = CollUtil.union((Collection)newWordCodeList, (Collection)oldWordCodeList);
            int denominator = union.size();
            BigDecimal powAll = new BigDecimal(0);
            for (String wordCode : union) {
                int newWordIndex = newWordCodeList.indexOf(wordCode);
                int oldWordIndex = oldWordCodeList.indexOf(wordCode);
                int newWordOrder = newWordIndex + 1;
                int oldWordOrder = oldWordIndex + 1;
                powAll = powAll.add(NumberUtil.pow((Number)(oldWordOrder - newWordOrder), (int)2));
            }
            degreeAll += NumberUtil.round((BigDecimal)NumberUtil.div((Number)powAll, (Number)denominator), (int)4).doubleValue();
        }
        return NumberUtil.round((double)NumberUtil.div((double)degreeAll, (float)count), (int)4).doubleValue();
    }

    private String getEarliestOldScoreWords(String key, String type, Map<String, String> localCache, String oldScoreWords) {
        String cacheKey = key + '_' + type;
        if (localCache.get(cacheKey) == null) {
            PastWordsRecords pastWordsRecordsEarliest = this.getPastWordsRecordsEarliest(key, type);
            if (pastWordsRecordsEarliest != null) {
                localCache.put(cacheKey, pastWordsRecordsEarliest.getOldScoreWords());
            } else {
                localCache.put(cacheKey, "");
            }
        } else {
            oldScoreWords = localCache.get(cacheKey);
        }
        return oldScoreWords;
    }
}

