/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.dao;

import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.uibot.domain.UserDesignerCenterDTO;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Repository;

@Repository
public class UserDefinedMongoMapper {
    @Resource
    private MongoTemplate userdefinedMongoTemplate;
    private final String COLLECTION_NAME = "user_designer_center";

    public void save(UserDesignerCenterDTO userDesigner) {
        UserDesignerCenterDTO getOneCheck = this.getDynamicForm(userDesigner);
        userDesigner.setIsRelease(false);
        if (getOneCheck != null && getOneCheck.getDynamicForm() != null) {
            Query query = new Query();
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)getOneCheck.getUniqueId()));
            Update update = new Update();
            update.set("dynamicForm", userDesigner.getDynamicForm());
            update.set("updateDate", (Object)LocalDateTime.now());
            update.set("updateUserId", (Object)userDesigner.getUserId());
            this.userdefinedMongoTemplate.upsert(query, (UpdateDefinition)update, "user_designer_center");
        } else {
            userDesigner.setCreateDate(LocalDateTime.now());
            userDesigner.setCreateUserId(userDesigner.getUserId());
            userDesigner.setUniqueId(SnowflakeIdWorker.getInstance().newId());
            BulkOperations operations = this.userdefinedMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, "user_designer_center");
            operations.insert((Object)userDesigner);
            operations.execute();
        }
    }

    public UserDesignerCenterDTO getDynamicForm(UserDesignerCenterDTO userDesigner) {
        Query query = this.getQuery(userDesigner);
        UserDesignerCenterDTO one = (UserDesignerCenterDTO)this.userdefinedMongoTemplate.findOne(query, UserDesignerCenterDTO.class, "user_designer_center");
        return one;
    }

    private Query getQuery(UserDesignerCenterDTO userDesigner) {
        Query query = new Query();
        if (StringUtils.isNotEmpty((CharSequence)userDesigner.getVersion()) && "tenant_version".equals(userDesigner.getVersion())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"tenantId").is((Object)userDesigner.getTenantId()));
        }
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"version").is((Object)userDesigner.getVersion()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"pageCode").is((Object)userDesigner.getPageCode()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmProjectId").is((Object)userDesigner.getTmProjectId()));
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"tmActivityId").is((Object)userDesigner.getTmActivityId()));
        return query;
    }

    public void releaseTenantVersion(UserDesignerCenterDTO userDesigner) {
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"uniqueId").is((Object)userDesigner.getUniqueId()));
        Update update = new Update();
        update.set("dynamicForm", userDesigner.getDynamicForm());
        update.set("releaseDynamicForm", userDesigner.getReleaseDynamicForm());
        update.set("releaseDate", (Object)LocalDateTime.now());
        update.set("releaseUserId", (Object)userDesigner.getUserId());
        update.set("isRelease", (Object)userDesigner.getIsRelease());
        this.userdefinedMongoTemplate.upsert(query, (UpdateDefinition)update, "user_designer_center");
    }

    public void releaseStandardVersionToTenant(UserDesignerCenterDTO userDesigner) {
        userDesigner.setVersion("tenant_version");
        userDesigner.setIsRelease(true);
        UserDesignerCenterDTO getOneCheck = this.getDynamicForm(userDesigner);
        if (getOneCheck != null && getOneCheck.getDynamicForm() != null) {
            userDesigner.setUniqueId(getOneCheck.getUniqueId());
            this.releaseTenantVersion(userDesigner);
        } else {
            userDesigner.setUniqueId(SnowflakeIdWorker.getInstance().newId());
            userDesigner.setCreateDate(LocalDateTime.now());
            userDesigner.setCreateUserId(userDesigner.getUserId());
            userDesigner.setReleaseUserId(userDesigner.getUserId());
            userDesigner.setReleaseDate(LocalDateTime.now());
            BulkOperations operations = this.userdefinedMongoTemplate.bulkOps(BulkOperations.BulkMode.UNORDERED, "user_designer_center");
            operations.insert((Object)userDesigner);
            operations.execute();
        }
    }
}

