/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.builder;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.Action;
import com.digiwin.athena.uibot.activity.domain.DataSourceDTO;
import com.digiwin.athena.uibot.activity.domain.DataSourceSetDTO;
import com.digiwin.athena.uibot.activity.domain.OperationDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.component.domain.AbstractComponent;
import com.digiwin.athena.uibot.component.domain.AllFields;
import com.digiwin.athena.uibot.component.domain.BasicDataTableComponent;
import com.digiwin.athena.uibot.component.domain.FormComponent;
import com.digiwin.athena.uibot.component.domain.GridComponent;
import com.digiwin.athena.uibot.designering.service.impl.DesignerPageBuilderBase;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.domain.ShowMetadata;
import com.digiwin.athena.uibot.metadata.domain.ApiMetadata;
import com.digiwin.athena.uibot.metadata.domain.MetadataField;
import com.digiwin.athena.uibot.tag.domain.BaseDataManagerStatusTagDefinition;
import com.digiwin.athena.uibot.tag.domain.TagDefinition;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="designerBasicDataSingleDocumentPageBuilder")
public class DesignerBasicDataSingleDocumentPageBuilder
extends DesignerPageBuilderBase<PageDefine> {
    private static final String MANAGE_STATUS = "manage_status";
    public static final String BUTTON_GROUP_INSTANCE_NAME = "buttonGroupInterpreter";
    public static final String MANAGE_STATUS_INSTANCE_NAME = "baseDataManagerStatusInterpreter";
    @Autowired
    private MessageUtils messageUtils;

    @Override
    public String supportKey() {
        return "basicDataSingleDocumentPageBuilder";
    }

    @Override
    public DynamicForm createPage(ExecuteContext executeContext, QueryResultSet queryResultSet, PageDefine pageDefine) {
        DynamicForm dynamicForm = super.createPage(executeContext, queryResultSet, pageDefine);
        if (CollectionUtils.isNotEmpty((Collection)dynamicForm.getLayout())) {
            dynamicForm.getLayout().stream().filter(subLayout -> subLayout instanceof BasicDataTableComponent).forEach(basicDataTableComponent -> ((BasicDataTableComponent)basicDataTableComponent).setPageDataKeys(dynamicForm.getPageDataKeys()));
        }
        return dynamicForm;
    }

    @Override
    public QueryResultSet BuildDataSource(ExecuteContext executeContext, PageDefine pageDefine) {
        QueryResultSet queryResultSet = QueryResultSet.empty();
        if (pageDefine.getDataSourceSet() != null) {
            queryResultSet.getMainQueryResult().setDataSourceName(pageDefine.getDataSourceSet().getMainDatasource());
        }
        return queryResultSet;
    }

    private boolean needAppendButtonGroupField(PageDefine pageDefine) {
        if (CollectionUtils.isEmpty((Collection)pageDefine.getOperations())) {
            return false;
        }
        Optional<OperationDTO> optional = pageDefine.getOperations().stream().filter(operationDTO -> null != operationDTO.getAttach() && StringUtils.equalsIgnoreCase((CharSequence)"row", (CharSequence)operationDTO.getAttach().getMode()) && StringUtils.equals((CharSequence)operationDTO.getAttach().getApplyToField(), (CharSequence)"BUTTON_GROUP")).findAny();
        return optional.isPresent();
    }

    @Override
    protected ShowMetadata createShowMetadata(ExecuteContext executeContext, PageDefine pageDefine, String actionId, ApiMetadata apiMetadata, QueryResultSet queryResultSet) {
        if (apiMetadata == null || CollectionUtils.isEmpty((Collection)apiMetadata.getResponseFields()) || apiMetadata.getResponseFields().size() == 0) {
            return null;
        }
        MetadataField rootField = (MetadataField)apiMetadata.getResponseFields().get(0);
        if (rootField.getFieldMap().containsKey(MANAGE_STATUS) && CollectionUtils.isNotEmpty((Collection)((MetadataField)rootField.getFieldMap().get(MANAGE_STATUS)).getTagDefinitions())) {
            this.addManageStatusField(rootField, pageDefine);
        } else {
            Object needStatusColumn;
            Map extendedFields = pageDefine.getExtendedFields();
            if (MapUtils.isNotEmpty((Map)extendedFields) && extendedFields.containsKey("needStatusColumn") && Boolean.valueOf((needStatusColumn = extendedFields.get("needStatusColumn")).toString()).booleanValue()) {
                this.addManageStatusField(rootField, pageDefine);
            }
        }
        if (this.needAppendButtonGroupField(pageDefine)) {
            this.addButtonGroupField(rootField);
        }
        return super.createShowMetadata(executeContext, pageDefine, actionId, apiMetadata, queryResultSet);
    }

    @Override
    protected void BuildLayout(ExecuteContext executeContext, QueryResultSet queryResultSet, PageDefine pageDefine, DynamicForm dynamicForm) {
        this.handleExportDataOperation(pageDefine);
        super.BuildLayout(executeContext, queryResultSet, pageDefine, dynamicForm);
        this.analysisLayout(pageDefine, dynamicForm);
    }

    private void handleExportDataOperation(PageDefine pageDefine) {
        if (CollectionUtils.isEmpty((Collection)pageDefine.getOperations())) {
            return;
        }
        List exportDataOperations = pageDefine.getOperations().stream().filter(operation -> StringUtils.equalsIgnoreCase((CharSequence)"data_export", (CharSequence)operation.getType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(exportDataOperations)) {
            return;
        }
        Optional<Map> actionParasOpt = Optional.ofNullable(pageDefine.getDataSourceSet()).map(DataSourceSetDTO::getDataSourceList).map(dataSourceList -> (DataSourceDTO)dataSourceList.get(0)).map(DataSourceDTO::getAction).map(Action::getParas);
        if (actionParasOpt.isPresent()) {
            for (OperationDTO exportDataOperation : exportDataOperations) {
                if (null == exportDataOperation.getExtendedFields()) {
                    exportDataOperation.setExtendedFields(new HashMap());
                }
                exportDataOperation.getExtendedFields().put("actionParas", actionParasOpt.get());
            }
        }
    }

    private void analysisLayout(PageDefine pageDefine, DynamicForm dynamicForm) {
        ArrayList<Object> layout = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)dynamicForm.getLayout())) {
            for (AbstractComponent layoutTemp : dynamicForm.getLayout()) {
                if (layoutTemp instanceof GridComponent) {
                    BasicDataTableComponent tableComponent = new BasicDataTableComponent();
                    BeanUtils.copyProperties((Object)layoutTemp, (Object)tableComponent);
                    tableComponent.setIsBaseData(Boolean.valueOf(true));
                    tableComponent.setAllFields(this.appendAllFieldsButtonGroup(tableComponent.getAllFields()));
                    layout.add(tableComponent);
                    continue;
                }
                if (layoutTemp instanceof FormComponent) {
                    FormComponent formComponent = (FormComponent)layoutTemp;
                    if (pageDefine.getDataSourceSet().getMainDatasource().equals(layoutTemp.getSchema())) {
                        formComponent.setActions(pageDefine.getSubmitActions());
                    }
                    layout.add(formComponent);
                    continue;
                }
                layout.add(layoutTemp);
            }
        }
        dynamicForm.setLayout(layout);
    }

    private void addButtonGroupField(MetadataField responseField) {
        MetadataField field = new MetadataField();
        field.setUiBot("Y");
        field.setName("BUTTON_GROUP");
        field.setDataType("string");
        field.setPath(responseField.getName());
        field.setDescription(this.messageUtils.getMessage("uibot.activity.metadataField.operation"));
        ArrayList tagDefs = Lists.newArrayList();
        TagDefinition tagDef = new TagDefinition();
        tagDef.setCode("BUTTON_GROUP");
        tagDef.setCategory("BUSINESS");
        tagDef.setInterpreterServiceName(BUTTON_GROUP_INSTANCE_NAME);
        tagDef.setCustomize(Boolean.valueOf(false));
        tagDefs.add(tagDef);
        field.setTagDefinitions((List)tagDefs);
        List metadataFields = responseField.getSubFields();
        metadataFields.add(field);
        responseField.getFieldMap().put("BUTTON_GROUP", field);
    }

    private void addManageStatusField(MetadataField responseField, PageDefine pageDefine) {
        Map extendedFields;
        MetadataField field = new MetadataField();
        field.setName(MANAGE_STATUS);
        field.setDataType("string");
        field.setPath(responseField.getName());
        field.setDescription(this.messageUtils.getMessage("uibot.template.basicData.column.headerName"));
        ArrayList tagDefs = Lists.newArrayList();
        BaseDataManagerStatusTagDefinition tagDef = new BaseDataManagerStatusTagDefinition();
        tagDef.setCode("BASE_DATA_MANAGER_STATUS");
        tagDef.setCategory("BUSINESS");
        tagDef.setInterpreterServiceName(MANAGE_STATUS_INSTANCE_NAME);
        if (pageDefine != null && MapUtils.isNotEmpty((Map)(extendedFields = pageDefine.getExtendedFields())) && extendedFields.containsKey("stateConfig") && extendedFields.containsKey("stateTransferConfig")) {
            tagDef.setStateConfig((List)extendedFields.get("stateConfig"));
            tagDef.setStateTransferConfig((List)extendedFields.get("stateTransferConfig"));
        }
        tagDef.setCustomize(Boolean.valueOf(false));
        tagDefs.add(tagDef);
        field.setTagDefinitions((List)tagDefs);
        List metadataFields = responseField.getSubFields().stream().filter(fd -> !MANAGE_STATUS.equals(fd.getName())).collect(Collectors.toList());
        metadataFields.add(field);
        responseField.setSubFields(metadataFields);
        responseField.getFieldMap().put(MANAGE_STATUS, field);
    }

    private List<AllFields> appendAllFieldsButtonGroup(List<AllFields> allFields) {
        if (CollectionUtils.isEmpty(allFields)) {
            return new ArrayList<AllFields>();
        }
        List<AllFields> allFieldsNew = allFields.stream().filter(field -> !"BUTTON_GROUP".equals(field.getName())).collect(Collectors.toList());
        AllFields allFieldsButtonGroup = new AllFields();
        allFieldsButtonGroup.setHeaderName(this.messageUtils.getMessage("uibot.activity.metadataField.operation"));
        allFieldsButtonGroup.setName("btn_operations");
        allFieldsButtonGroup.setDataType("string");
        allFieldsButtonGroup.setIsDataKey(Boolean.valueOf(false));
        allFieldsButtonGroup.setLevel(allFields.get(0).getLevel());
        allFieldsButtonGroup.setPath(allFields.get(0).getPath());
        allFieldsButtonGroup.setIsShow(Boolean.valueOf(true));
        allFieldsButtonGroup.setSort(Boolean.valueOf(false));
        allFieldsNew.add(allFieldsButtonGroup);
        return allFieldsNew;
    }
}

