/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.service.convert;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.uibot.domain.word.RotCategory;
import com.digiwin.athena.uibot.domain.word.WordTaskTag;
import com.digiwin.athena.uibot.param.req.WordRequest;
import com.digiwin.athena.uibot.param.req.WordRequestV2;
import com.digiwin.athena.uibot.param.resp.NameCodeResponse;
import com.digiwin.athena.uibot.param.resp.WordCategoryResponse;
import com.digiwin.athena.uibot.support.thememap.domain.ThemeMapTag;
import com.digiwin.athena.uibot.util.TagUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;

public class WordConvert {
    private WordConvert() {
    }

    public static List<NameCodeResponse> convertCategorySimplify(List<RotCategory> rotCategoryList) {
        return BeanUtil.copyToList(WordConvert.convertCategory(rotCategoryList), NameCodeResponse.class);
    }

    public static List<WordCategoryResponse> convertCategory(List<RotCategory> rotCategoryList) {
        ArrayList result = Lists.newArrayList();
        for (RotCategory rotCategory : rotCategoryList) {
            String name = rotCategory.getName();
            Map nameLangMap = Maps.newHashMap();
            if (JSONUtil.isTypeJSON((String)name)) {
                nameLangMap = (Map)JSONUtil.toBean((String)name, (TypeReference)new TypeReference<Map<String, String>>(){}, (boolean)Boolean.FALSE);
                String locale = LocaleContextHolder.getLocale().toString();
                name = nameLangMap.getOrDefault(locale, nameLangMap.values().stream().findFirst().orElse(""));
            }
            result.add(((WordCategoryResponse.WordCategoryResponseBuilder)((WordCategoryResponse.WordCategoryResponseBuilder)((WordCategoryResponse.WordCategoryResponseBuilder)WordCategoryResponse.builder().parentCode(rotCategory.getParentCode()).code(rotCategory.getCode())).name(name)).nameLang(nameLangMap)).level(rotCategory.getLevel()).build());
        }
        return result;
    }

    public static List<ThemeMapTag> convertTaskTag(List<WordTaskTag> taskTagList) {
        ArrayList tagList = Lists.newArrayList();
        for (WordTaskTag wordTaskTag : taskTagList) {
            ThemeMapTag tag = new ThemeMapTag();
            tag.setId(wordTaskTag.getTagId());
            tag.setCode(TagUtil.getTagCodePure((String)wordTaskTag.getTagCode()));
            tag.setName(wordTaskTag.getTagName());
            tag.setCategory(wordTaskTag.getTagCategory());
            tagList.add(tag);
        }
        return tagList;
    }

    public static WordRequest convertFromV2(WordRequestV2 wordRequestV2) {
        WordRequest wordRequest = (WordRequest)BeanUtil.copyProperties((Object)wordRequestV2, WordRequest.class, (String[])new String[0]);
        wordRequest.setTask((List)Lists.newArrayList((Object[])new String[]{wordRequestV2.getTaskCode()}));
        wordRequest.setFields(wordRequestV2.getFields());
        return wordRequest;
    }
}

