/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.PageUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.uibot.dao.WordDao;
import com.digiwin.athena.uibot.dao.WordOrderTagDao;
import com.digiwin.athena.uibot.designering.service.DesignerViewTagService;
import com.digiwin.athena.uibot.designering.service.DesignerViewWordsService;
import com.digiwin.athena.uibot.designering.service.convert.WordConvert;
import com.digiwin.athena.uibot.domain.word.RotCategory;
import com.digiwin.athena.uibot.domain.word.WordOrderTag;
import com.digiwin.athena.uibot.mapper.WordOrderTagMapper;
import com.digiwin.athena.uibot.param.req.DimensionRequest;
import com.digiwin.athena.uibot.param.req.WordAndDimensionSaveRequest;
import com.digiwin.athena.uibot.param.req.WordCategoryDimensionRequest;
import com.digiwin.athena.uibot.param.req.WordDimensionRequest;
import com.digiwin.athena.uibot.param.req.WordRequest;
import com.digiwin.athena.uibot.param.req.WordRequestV2;
import com.digiwin.athena.uibot.param.resp.UserDefinedFieldsResponse;
import com.digiwin.athena.uibot.param.resp.WordCategoryResponse;
import com.digiwin.athena.uibot.param.resp.WordDimensionResponse;
import com.digiwin.athena.uibot.param.resp.WordOtherResponse;
import com.digiwin.athena.uibot.param.resp.WordResponse;
import com.digiwin.athena.uibot.support.audc.AudcService;
import com.digiwin.athena.uibot.support.thememap.param.req.TaskWordsRequest;
import com.digiwin.athena.uibot.support.thememap.param.resp.TaskWordResponse;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import com.digiwin.athena.uibot.util.CommonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class DesignerViewWordsServiceImpl
implements DesignerViewWordsService {
    private static final Logger log = LoggerFactory.getLogger(DesignerViewWordsServiceImpl.class);
    @Resource
    private ThemeMapService themeMapService;
    @Resource
    private AudcService audcService;
    @Resource
    private WordDao wordDao;
    @Resource
    private WordOrderTagDao wordOrderTagDao;
    @Resource
    private WordOrderTagMapper wordOrderTagMapper;
    @Resource
    private DesignerViewTagService designerViewTagService;

    @Override
    public WordResponse recommendWords(WordRequest wordRequest) {
        try {
            List<String> displayableWords = this.getDisplayableWords(wordRequest);
            List<WordOtherResponse> sortedWords = this.getSortedWords(displayableWords, wordRequest);
            return this.wrapperWordResponse(sortedWords, wordRequest);
        }
        catch (Exception e) {
            log.error("Recommend words fail", (Throwable)e);
            return this.wrapperWordResponse(wordRequest);
        }
    }

    @Override
    public WordResponse recommendWordsV2(WordRequestV2 wordRequestV2) {
        WordRequest wordRequest = WordConvert.convertFromV2(wordRequestV2);
        try {
            List<String> displayableWords = this.getDisplayableWords(wordRequest);
            List<WordOtherResponse> sortedWords = this.getSortedWords(displayableWords, wordRequest);
            this.designerViewTagService.markRecommendTag(wordRequestV2, sortedWords);
            return this.wrapperWordResponse(sortedWords, wordRequest);
        }
        catch (Exception e) {
            log.error("Recommend words fail", (Throwable)e);
            return this.wrapperWordResponse(wordRequest);
        }
    }

    @Override
    public List<WordCategoryResponse> queryCategoryList() {
        List rotCategoryList = this.wordDao.queryRotCategoryList();
        this.removeIgnoreCategory(rotCategoryList);
        return WordConvert.convertCategory(rotCategoryList);
    }

    private void removeIgnoreCategory(List<RotCategory> rotCategoryList) {
        String nameFormat = "\"zh_CN\": \"%s\"";
        List<Object> ignoreParentCategoryName = Lists.newArrayList((Object[])new String[]{"\u57fa\u7840\u8d44\u6599", "\u901a\u7528", "\u9879\u76ee", "\u62a5\u8868"});
        ArrayList ignoreParentCategoryCode = Lists.newArrayList();
        List<Object> finalIgnoreParentCategoryName = ignoreParentCategoryName = ignoreParentCategoryName.stream().map(category -> String.format(nameFormat, category)).collect(Collectors.toList());
        rotCategoryList.removeIf(category -> {
            String code = category.getCode();
            String parentCode = category.getParentCode();
            String name = category.getName();
            name = name.substring(name.indexOf("zh_CN") - 1, name.indexOf("en_US") - 2);
            if (StringUtils.isEmpty((CharSequence)parentCode) && finalIgnoreParentCategoryName.contains(name)) {
                ignoreParentCategoryCode.add(code);
                return Boolean.TRUE;
            }
            return ignoreParentCategoryCode.contains(parentCode);
        });
    }

    @Override
    @Transactional
    public Boolean saveWordAndDimensionRelation(WordAndDimensionSaveRequest saveRequest) {
        List wordCategories = saveRequest.getWordCategories();
        for (WordCategoryDimensionRequest wordCategory : wordCategories) {
            this.wordDao.saveOrUpdateWordAndDimensionRelation(wordCategory);
        }
        return Boolean.TRUE;
    }

    @Override
    public Integer importWordOrderTag(MultipartFile excel) {
        long start = System.currentTimeMillis();
        InputStream inputStream = excel.getInputStream();
        Map<String, List<WordOrderTag>> apiFieldsForOrderTag = this.getApiFieldsForOrderTag(inputStream);
        log.info("Parse file cost {} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.wordOrderTagMapper.truncateTable();
        int count = 0;
        for (Map.Entry<String, List<WordOrderTag>> entry : apiFieldsForOrderTag.entrySet()) {
            String key = entry.getKey();
            List<WordOrderTag> wordOrderTagList = entry.getValue();
            for (WordOrderTag wordOrderTag : wordOrderTagList) {
                wordOrderTag.setId(null);
            }
            count += wordOrderTagList.size();
            this.wordOrderTagDao.saveBatch(wordOrderTagList);
            log.info("=== Save success: {}", (Object)key);
        }
        log.info("Batch save cost {} ms", (Object)(System.currentTimeMillis() - start));
        return count;
    }

    @Override
    public Integer importWordOrderTagCategory(MultipartFile excel) {
        ExcelReader readerTaskCategory = ExcelUtil.getReader((InputStream)excel.getInputStream());
        List sheets = readerTaskCategory.getSheets();
        Sheet secondSheet = (Sheet)sheets.get(1);
        int lastRowNum = secondSheet.getLastRowNum() + 1;
        int count = 0;
        for (int i = 1; i < lastRowNum; ++i) {
            Row row = secondSheet.getRow(i);
            if (row == null) continue;
            String activityId = row.getCell(1).getStringCellValue();
            String categoryCode = row.getCell(5).getStringCellValue();
            if (StringUtils.isEmpty((CharSequence)activityId) || StringUtils.isEmpty((CharSequence)categoryCode)) continue;
            WordOrderTag wordOrderTag = new WordOrderTag();
            wordOrderTag.setCategoryCode(categoryCode);
            count += this.wordOrderTagMapper.update((Object)wordOrderTag, (Wrapper)Wrappers.lambdaQuery(WordOrderTag.class).eq(WordOrderTag::getActivityId, (Object)activityId));
        }
        return count;
    }

    @Override
    public List<WordDimensionResponse> queryWordDimension(WordDimensionRequest wordDimensionRequest) {
        ArrayList responseList = Lists.newArrayList();
        List words = wordDimensionRequest.getWords();
        for (String wordCode : words) {
            List rotCategoryList = this.wordDao.queryRotCategoryList(wordCode);
            responseList.add(WordDimensionResponse.builder().wordCode(wordCode).wordCategories(WordConvert.convertCategorySimplify(rotCategoryList)).build());
        }
        return responseList;
    }

    @Override
    public String saveDimension(DimensionRequest dimensionRequest) {
        String type = dimensionRequest.getType();
        String code = "";
        switch (type) {
            case "DUTY": {
                break;
            }
            case "TIME": {
                break;
            }
            case "PLACE": {
                break;
            }
            default: {
                code = this.wordDao.saveOrUpdateCategory(dimensionRequest);
            }
        }
        return code;
    }

    @Override
    public Boolean wordTranslate(String type) {
        switch (type) {
            case "DUTY": {
                break;
            }
            case "TIME": {
                break;
            }
            case "PLACE": {
                break;
            }
        }
        return Boolean.TRUE;
    }

    private WordResponse wrapperWordResponse(WordRequest wordRequest) {
        return this.wrapperWordResponse(null, wordRequest);
    }

    private WordResponse wrapperWordResponse(List<WordOtherResponse> sortedWords, WordRequest wordRequest) {
        if (CollectionUtils.isEmpty(sortedWords)) {
            sortedWords = this.wrapper(wordRequest.getFields());
        }
        return WordResponse.builder().others(sortedWords).build();
    }

    private List<String> getDisplayableWords(WordRequest wordRequest) {
        List wordCodeList = wordRequest.getFields();
        List categories = wordRequest.getCategories();
        List duty = wordRequest.getDuty();
        List time = wordRequest.getTime();
        List place = wordRequest.getPlace();
        if (CollectionUtils.isEmpty((Collection)wordCodeList) || CollectionUtils.isEmpty((Collection)categories) && CollectionUtils.isEmpty((Collection)duty) && CollectionUtils.isEmpty((Collection)time) && CollectionUtils.isEmpty((Collection)place)) {
            return wordCodeList;
        }
        ArrayList displayableWords = Lists.newArrayList();
        for (String wordCode : wordCodeList) {
            if (CollectionUtils.isNotEmpty((Collection)categories) && !this.wordDao.existWordCategory(wordCode, categories) || CollectionUtils.isNotEmpty((Collection)duty) && !this.wordDao.existWordDuty(wordCode, duty) || CollectionUtils.isNotEmpty((Collection)time) && !this.wordDao.existWordTime(wordCode, time) || CollectionUtils.isNotEmpty((Collection)place) && !this.wordDao.existWordPlace(wordCode, place)) continue;
            displayableWords.add(wordCode);
        }
        log.debug("====== DisplayableWords: {}", (Object)displayableWords);
        return displayableWords;
    }

    private List<WordOtherResponse> getSortedWords(List<String> displayableWords, WordRequest wordRequest) {
        if (CollectionUtils.isEmpty(displayableWords)) {
            return Lists.newArrayList();
        }
        long start = System.currentTimeMillis();
        Map<String, List<List<String>>> taskIdWordsMap = this.referenceDesigner(wordRequest);
        log.info("=== referenceDesigner cost: {} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.referenceHistoryOrderTag(wordRequest, taskIdWordsMap);
        log.info("=== referenceHistoryOrderTag by dimension, cost: {} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.referenceUserDefine(taskIdWordsMap);
        log.info("=== referenceUserDefine cost: {} ms", (Object)(System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.referenceHistoryOrderTag(taskIdWordsMap);
        log.info("=== referenceHistoryOrderTag by activityId, cost: {} ms", (Object)(System.currentTimeMillis() - start));
        ArrayList wordConfigListList = Lists.newArrayList();
        taskIdWordsMap.values().forEach(wordConfigListList::addAll);
        return this.getSortedWords(displayableWords, wordConfigListList);
    }

    private Map<String, List<List<String>>> referenceDesigner(WordRequest wordRequest) {
        List taskWordResponseList = this.themeMapService.getTasksForWord(TaskWordsRequest.builder().build().copy(wordRequest));
        HashMap<String, List<List<String>>> taskIdWordsMap = new HashMap<String, List<List<String>>>();
        for (TaskWordResponse taskWordResponse : taskWordResponseList) {
            String activityId = taskWordResponse.getActivityId();
            List<String> words = this.getNewWordList(taskWordResponse);
            taskIdWordsMap.computeIfAbsent(activityId, k -> Lists.newArrayList()).add(words);
        }
        return taskIdWordsMap;
    }

    private void referenceUserDefine(Map<String, List<List<String>>> taskIdWordsMap) {
        if (MapUtil.isEmpty(taskIdWordsMap)) {
            return;
        }
        Set<String> taskIdSet = taskIdWordsMap.keySet();
        ArrayList taskIdList = Lists.newArrayList(taskIdSet);
        Function<List<String>, Map<String, List<List<String>>>> function = taskIdListPage -> {
            HashMap<String, ArrayList> taskIdWordsMapInner = new HashMap<String, ArrayList>();
            List fieldsByTaskId = this.audcService.getFieldsByTaskId(taskIdListPage);
            Map taskIdFieldListMap = fieldsByTaskId.stream().collect(Collectors.toMap(UserDefinedFieldsResponse::getActivityId, Function.identity()));
            for (Map.Entry entry : taskIdFieldListMap.entrySet()) {
                String taskId = entry.getKey();
                UserDefinedFieldsResponse fieldsResponse = (UserDefinedFieldsResponse)entry.getValue();
                List userDefinedFieldList = fieldsResponse == null ? Lists.newArrayList() : fieldsResponse.getUserDefinedFieldList();
                if (!CollectionUtils.isNotEmpty((Collection)userDefinedFieldList)) continue;
                taskIdWordsMapInner.put(taskId, (ArrayList)userDefinedFieldList);
            }
            return taskIdWordsMapInner;
        };
        taskIdWordsMap.putAll(this.pageHandle(taskIdList, function));
    }

    private void referenceHistoryOrderTag(Map<String, List<List<String>>> taskIdWordsMap) {
        if (MapUtil.isEmpty(taskIdWordsMap)) {
            return;
        }
        HashSet<String> taskIdSetNoneWords = new HashSet<String>();
        for (Map.Entry<String, List<List<String>>> taskIdWordsMapEntry : taskIdWordsMap.entrySet()) {
            String activityId = taskIdWordsMapEntry.getKey();
            List<List<String>> wordListList = taskIdWordsMapEntry.getValue();
            if (!this.isAllEmpty(wordListList)) continue;
            taskIdSetNoneWords.add(activityId);
        }
        if (CollectionUtils.isEmpty(taskIdSetNoneWords)) {
            return;
        }
        ArrayList taskIdSetNoneWordList = Lists.newArrayList(taskIdSetNoneWords);
        Function<List<String>, Map<String, List<List<String>>>> function = taskIdListPage -> {
            List wordOrderTagList = this.wordOrderTagDao.list((Wrapper)Wrappers.lambdaQuery(WordOrderTag.class).in(WordOrderTag::getActivityId, (Collection)taskIdListPage));
            return this.getActivityIdMap(wordOrderTagList);
        };
        taskIdWordsMap.putAll(this.pageHandle(taskIdSetNoneWordList, function));
    }

    private void referenceHistoryOrderTag(WordRequest wordRequest, Map<String, List<List<String>>> taskIdWordsMap) {
        List categories = wordRequest.getCategories();
        if (CollectionUtils.isEmpty((Collection)categories)) {
            return;
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery(WordOrderTag.class).in(WordOrderTag::getCategoryCode, (Collection)categories);
        List wordOrderTagList = this.wordOrderTagMapper.selectList((Wrapper)queryWrapper);
        Map<String, List<List<String>>> activityIdMapFromOrderTag = this.getActivityIdMap(wordOrderTagList);
        for (Map.Entry<String, List<List<String>>> entry : activityIdMapFromOrderTag.entrySet()) {
            String activityIdFromOrderTag = entry.getKey();
            List<List<String>> wordListFromOrderTag = entry.getValue();
            taskIdWordsMap.putIfAbsent(activityIdFromOrderTag, wordListFromOrderTag);
        }
    }

    private Map<String, List<List<String>>> getActivityIdMap(List<WordOrderTag> wordOrderTagList) {
        HashMap<String, List<List<String>>> taskIdWordsMapInner = new HashMap<String, List<List<String>>>();
        Map<String, List<WordOrderTag>> activitIdyMap = wordOrderTagList.stream().collect(Collectors.groupingBy(WordOrderTag::getActivityId));
        for (Map.Entry<String, List<WordOrderTag>> activitIdyMapEntry : activitIdyMap.entrySet()) {
            String activityId = activitIdyMapEntry.getKey();
            List<WordOrderTag> wordOrderTagListInner = activitIdyMapEntry.getValue();
            Map<String, List<WordOrderTag>> dataSourceNameMap = wordOrderTagListInner.stream().collect(Collectors.groupingBy(WordOrderTag::getDataSourceName));
            ArrayList wordListList = Lists.newArrayList();
            for (List<WordOrderTag> value : dataSourceNameMap.values()) {
                wordListList.add(value.stream().map(WordOrderTag::getWordCode).collect(Collectors.toList()));
            }
            taskIdWordsMapInner.put(activityId, wordListList);
        }
        return taskIdWordsMapInner;
    }

    private List<String> getNewWordList(TaskWordResponse taskWordResponse) {
        List dataStates = taskWordResponse.getDataStates();
        if (CollectionUtils.isEmpty((Collection)dataStates)) {
            return Lists.newArrayList();
        }
        TaskWordResponse.ShowMetadata showMetadatas = ((TaskWordResponse.DataState)dataStates.get(0)).getShowMetadatas();
        if (showMetadatas == null) {
            return Lists.newArrayList();
        }
        return showMetadatas.getNewScoreWords().stream().map(TaskWordResponse.NewWordScore::getFields).flatMap(Collection::stream).map(TaskWordResponse.WordScoreField::getFieldName).distinct().collect(Collectors.toList());
    }

    private List<WordOtherResponse> getSortedWords(List<String> wordRequestList, List<List<String>> wordConfigListList) {
        if (CollectionUtils.isEmpty(wordConfigListList)) {
            return this.wrapper(wordRequestList);
        }
        LinkedHashMap<String, Double> wordScoreMap = new LinkedHashMap<String, Double>();
        for (String word : wordRequestList) {
            int totalCount = 0;
            for (List<String> wordConfigList : wordConfigListList) {
                if (!wordConfigList.contains(word)) continue;
                totalCount += wordConfigList.size();
            }
            for (List<String> wordConfigList : wordConfigListList) {
                int count = wordConfigList.size();
                int[] indexOfAll = ListUtil.indexOfAll(wordConfigList, apiWord -> CharSequenceUtil.equals((CharSequence)apiWord, (CharSequence)word));
                int repeatCount = indexOfAll.length;
                repeatCount = repeatCount == 0 ? 1 : repeatCount;
                double scoreTotal = 0.0;
                for (int index : indexOfAll) {
                    scoreTotal += CommonUtil.calculateScore((int)count, (int)(++index), (int)totalCount);
                }
                double averageScore = NumberUtil.div((double)scoreTotal, (float)repeatCount);
                averageScore = NumberUtil.round((double)averageScore, (int)4).doubleValue();
                double scoreOri = wordScoreMap.getOrDefault(word, 0.0);
                wordScoreMap.put(word, NumberUtil.add((double)scoreOri, (double)averageScore));
            }
        }
        Set<String> wordsSorted = MapUtil.sortByValue(wordScoreMap, (boolean)true).keySet();
        return this.wrapper(wordScoreMap, wordsSorted);
    }

    private List<WordOtherResponse> wrapper(List<String> wordList) {
        return this.wrapper(Maps.newHashMap(), wordList);
    }

    private List<WordOtherResponse> wrapper(Map<String, Double> wordScoreMap, Collection<String> wordsSorted) {
        ArrayList wordOtherResponseList = Lists.newArrayList();
        for (String word : wordsSorted) {
            wordOtherResponseList.add(WordOtherResponse.builder().word(word).score(wordScoreMap.getOrDefault(word, 0.0)).build());
        }
        return wordOtherResponseList;
    }

    private Map<String, List<List<String>>> pageHandle(List<String> idList, Function<List<String>, Map<String, List<List<String>>>> function) {
        HashMap<String, List<List<String>>> taskIdWordsMap = new HashMap<String, List<List<String>>>();
        int totalCount = idList.size();
        int pageSize = 100;
        int totalPage = PageUtil.totalPage((int)totalCount, (int)pageSize);
        for (int pageNo = 0; pageNo < totalPage; ++pageNo) {
            List idListPage = CollUtil.page((int)pageNo, (int)pageSize, idList);
            taskIdWordsMap.putAll(function.apply(idListPage));
        }
        return taskIdWordsMap;
    }

    private boolean isAllEmpty(List<List<String>> wordListList) {
        for (List<String> wordList : wordListList) {
            if (!CollectionUtils.isNotEmpty(wordList)) continue;
            return false;
        }
        return true;
    }

    private Map<String, List<WordOrderTag>> getApiFieldsForOrderTag(InputStream inputStream) {
        ExcelReader reader = ExcelUtil.getReader((InputStream)inputStream);
        int rowCount = reader.getRowCount();
        int notTaskIdCount = 0;
        ArrayList wordOrderTagList = Lists.newArrayList();
        String publicTagTaskId = "publicTag";
        for (int i = 1; i < rowCount; ++i) {
            String wordType;
            String orderTag;
            List row = reader.readRow(i);
            String tagCode = (String)row.get(1);
            List split = StrUtil.split((CharSequence)tagCode, (CharSequence)"__");
            String taskId = publicTagTaskId;
            if (split.size() == 1) {
                ++notTaskIdCount;
                orderTag = (String)split.get(0);
            } else if (split.size() == 2) {
                ++notTaskIdCount;
                orderTag = (String)split.get(1);
            } else if (split.size() == 3) {
                taskId = (String)split.get(1);
                orderTag = (String)split.get(2);
            } else {
                log.info("Tag code cell value: {}", (Object)tagCode);
                continue;
            }
            List orderTagSplitList = StrUtil.split((CharSequence)orderTag, (CharSequence)"_");
            String orderValue = (String)orderTagSplitList.get(orderTagSplitList.size() - 1);
            String apiId = (String)row.get(2);
            String dataSourceName = StringUtils.substringAfterLast((String)apiId, (String)"_");
            String fieldJson = (String)row.get(3);
            String field = JSONUtil.parseObj((String)fieldJson).getStr((Object)"response");
            if (field.contains("__")) continue;
            if (field.contains(".request.")) {
                field = field.substring(field.lastIndexOf(".request.") + 9);
            } else if (field.contains(".response.")) {
                field = field.substring(field.lastIndexOf(".response.") + 10);
            }
            int segCount = CharSequenceUtil.split((CharSequence)field, (CharSequence)".").size();
            field = field.substring(field.lastIndexOf(".") + 1);
            if (segCount == 1) {
                wordType = "P";
            } else if (segCount == 2) {
                wordType = "MF";
            } else if (segCount == 3) {
                wordType = "DF";
            } else if (segCount == 4) {
                wordType = "SDF";
            } else {
                log.info("field error: {}", (Object)JSONUtil.parseObj((String)fieldJson).getStr((Object)"response"));
                continue;
            }
            WordOrderTag wordOrderTag = new WordOrderTag();
            wordOrderTag.setActivityId(taskId);
            wordOrderTag.setDataSourceName(dataSourceName);
            wordOrderTag.setWordCode(field);
            wordOrderTag.setWordType(wordType);
            wordOrderTag.setOrderValue(Long.valueOf(orderValue));
            wordOrderTagList.add(wordOrderTag);
        }
        reader.close();
        log.info("Public tab count: {}", (Object)notTaskIdCount);
        Map<String, List<WordOrderTag>> dataSourceNameMap = wordOrderTagList.stream().filter(k -> publicTagTaskId.equals(k.getActivityId())).collect(Collectors.groupingBy(k -> k.getDataSourceName() + k.getWordType()));
        Map<String, List<WordOrderTag>> taskIdMap = wordOrderTagList.stream().filter(k -> !publicTagTaskId.equals(k.getActivityId())).collect(Collectors.groupingBy(k -> k.getActivityId() + "@" + k.getDataSourceName() + "@" + k.getWordType()));
        HashMap<String, List<WordOrderTag>> result = new HashMap<String, List<WordOrderTag>>();
        taskIdMap.forEach((k, v) -> {
            String[] split = k.split("@");
            String taskId = split[0];
            String dataSourceName = split[1] + split[2];
            List wordOrderTagsPublic = ((List)dataSourceNameMap.getOrDefault(dataSourceName, Lists.newArrayList())).stream().distinct().collect(Collectors.toList());
            Set wordCodeSet = v.stream().map(WordOrderTag::getWordCode).collect(Collectors.toSet());
            wordOrderTagsPublic.removeIf(ele -> wordCodeSet.contains(ele.getWordCode()));
            List wordOrderTagsPublicCopy = BeanUtil.copyToList(wordOrderTagsPublic, WordOrderTag.class);
            for (WordOrderTag wordOrderTag : wordOrderTagsPublicCopy) {
                wordOrderTag.setActivityId(taskId);
            }
            v.addAll(wordOrderTagsPublicCopy);
            List allWord = v.stream().distinct().sorted(Comparator.comparing(WordOrderTag::getOrderValue)).collect(Collectors.toList());
            result.put((String)k, allWord);
        });
        return result;
    }
}

