/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.template;

import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.component.domain.AbstractComponent;
import com.digiwin.athena.uibot.component.domain.CommonComponent;
import com.digiwin.athena.uibot.component.domain.QueryButtonComponent;
import com.digiwin.athena.uibot.designering.service.DesignerPageBuilder;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.DynamicLayout;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.domain.ShowMetadata;
import com.digiwin.athena.uibot.domain.TaskData;
import com.digiwin.athena.uibot.domain.TemplateContentData;
import com.digiwin.athena.uibot.template.TemplateService;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DesignerPageTemplate
implements TemplateService<TaskPageDefine> {
    private static final String SUPPORT_KEY = "designer-page-template";
    private static final String COMPONENT_TYPE = "ACTIVITY_TITLE";
    @Autowired
    DesignerPageBuilder designerPageBuilder;

    public String supportKey() {
        return SUPPORT_KEY;
    }

    public DynamicForm createTaskPage(ExecuteContext executeContext, TaskPageDefine mainAction, List<TaskPageDefine> pageDefines) {
        DynamicForm dynamicForm = new DynamicForm();
        dynamicForm.setExecuteContext(executeContext);
        dynamicForm.setPageData(new HashMap());
        QueryResultSet queryResultSet = null;
        this.BuildLayout(executeContext, queryResultSet, mainAction, pageDefines, dynamicForm);
        this.BuildRule(executeContext, mainAction, dynamicForm);
        this.BuildStyle(executeContext, dynamicForm);
        if (queryResultSet != null && queryResultSet.getMainQueryResult() != null && StringUtils.hasText((String)queryResultSet.getMainQueryResult().getDataSourceName())) {
            Map result = queryResultSet.getPageData();
            for (String key : result.keySet()) {
                if (dynamicForm.getPageData().containsKey(key)) continue;
                dynamicForm.getPageData().put(key, result.get(key));
            }
            dynamicForm.setPageDataIndex(queryResultSet.getPageDataIndex());
            dynamicForm.setPageDataKeys(queryResultSet.getPageDataKeys());
            dynamicForm.setPageCountSize(Integer.valueOf(queryResultSet.getMainQueryResult().size()));
        } else {
            dynamicForm.setPageCountSize(Integer.valueOf(0));
        }
        this.BuildActions(executeContext, mainAction, dynamicForm);
        if (mainAction.getDataSources() instanceof Map) {
            dynamicForm.setDataSources(mainAction.getDataSources());
        }
        return dynamicForm;
    }

    public List<DynamicLayout> createTreePage(ExecuteContext executeContext, TaskPageDefine pageDefine) {
        return null;
    }

    protected void BuildLayout(ExecuteContext executeContext, QueryResultSet queryResultSet, TaskPageDefine pageDefine, List<TaskPageDefine> pageDefines, DynamicForm dynamicForm) {
        DynamicForm dynamicFormByTag;
        ArrayList<AbstractComponent> layout = new ArrayList<AbstractComponent>();
        this.createHeader(executeContext, pageDefine, layout);
        if (!"REPLY".equals(pageDefine.getExecuteContext().getCategory())) {
            QueryButtonComponent queryButtonComponent = this.createQueryButton(pageDefines);
            queryButtonComponent.setSupportShowInMaxedWindow(Boolean.valueOf(true));
            layout.add((AbstractComponent)queryButtonComponent);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicFormByTag = this.designerPageBuilder.createPage(executeContext, queryResultSet, pageDefine)).getLayout())) {
            layout.addAll(dynamicFormByTag.getLayout());
        }
        dynamicForm.setActions(dynamicFormByTag.getActions());
        dynamicForm.setLayout(layout);
        dynamicForm.getRules().addAll(dynamicFormByTag.getRules());
        dynamicForm.getStyle().putAll(dynamicFormByTag.getStyle());
        HashMap<String, Object> pageData = dynamicFormByTag.getPageData();
        if (MapUtils.isEmpty((Map)pageData)) {
            pageData = new HashMap<String, Object>();
        }
        this.getPageData(pageDefine, pageData);
        dynamicForm.setPageData(pageData);
    }

    protected QueryResultSet BuildDataSource(ExecuteContext executeContext, TaskPageDefine pageDefine, DynamicForm dynamicForm) {
        return null;
    }

    private void getPageData(TaskPageDefine pageDefine, Map<String, Object> pageData) {
        TemplateContentData templateContentData = new TemplateContentData();
        TaskData taskData = new TaskData();
        taskData.setName(pageDefine.getTitle());
        taskData.setProcessCreateTime(LocalDateTime.now());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        taskData.setTaskStartTime(LocalDateTime.now());
        taskData.setEndTime(sdf.format(new Date()));
        taskData.setTaskEndTime(LocalDateTime.now());
        taskData.setTitle(pageDefine.getTitle());
        taskData.setDescription(pageDefine.getDescription());
        ArrayList<String> eocName = new ArrayList<String>();
        eocName.add("leader\u516c\u53f8-\u7e3d\u516c\u53f8");
        taskData.setEocName(eocName);
        pageData.put("uiBot__activity", taskData);
        if ("REPLY".equals(pageDefine.getExecuteContext().getCategory())) {
            if (pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
                String dataSourceName = pageDefine.getDataSourceSet().getFirstDataQuery().getName();
                pageData.put(dataSourceName + "_HEAD", new HashMap());
                String contentTitle = pageDefine.getSubTitle();
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contentTitle)) {
                    templateContentData.setTitle(contentTitle);
                    templateContentData.setSubTitle(contentTitle);
                }
            }
        } else {
            String contentTitle = taskData.getName();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)contentTitle)) {
                templateContentData.setTitle(contentTitle);
                templateContentData.setSubTitle(contentTitle);
            }
        }
    }

    protected void BuildRule(ExecuteContext executeContext, TaskPageDefine pageDefine, DynamicForm dynamicForm) {
    }

    protected void BuildStyle(ExecuteContext executeContext, DynamicForm dynamicForm) {
    }

    protected void BuildActions(ExecuteContext executeContext, TaskPageDefine pageDefine, DynamicForm dynamicForm) {
    }

    protected void createHeader(ExecuteContext executeContext, TaskPageDefine pageDefine, List<AbstractComponent> layout) {
        layout.add((AbstractComponent)this.createHeadArea(executeContext));
        if ("REPLY".equals(executeContext.getCategory())) {
            layout.add((AbstractComponent)this.createDescriptionArea());
        }
    }

    protected CommonComponent createHeadArea(ExecuteContext executeContext) {
        CommonComponent commonComponent = new CommonComponent();
        commonComponent.setId(UUID.randomUUID().toString());
        if ("REPLY".equals(executeContext.getCategory())) {
            commonComponent.setType("DELIVERY_REPLY_TITLE");
        } else {
            commonComponent.setType(COMPONENT_TYPE);
        }
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    protected CommonComponent createDescriptionArea() {
        CommonComponent commonComponent = new CommonComponent();
        commonComponent.setType("DELIVERY_REPLY_DESCRIPTION");
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    protected QueryButtonComponent createQueryButton(List<TaskPageDefine> pageDefines) {
        QueryButtonComponent queryButtonComponent = new QueryButtonComponent();
        queryButtonComponent.setId(UUID.randomUUID().toString());
        queryButtonComponent.setType("CONTENT_QUERY_BUTTON");
        for (int i = 0; i < pageDefines.size(); ++i) {
            TaskPageDefine pageDefine = pageDefines.get(i);
            pageDefine.setRowSize(Integer.valueOf(0));
        }
        queryButtonComponent.setQueryButtons(pageDefines);
        return queryButtonComponent;
    }

    public ShowMetadata createShowMetadata(ExecuteContext executeContext, PageDefine pageDefine) {
        return this.designerPageBuilder.createShowMetadata(executeContext, pageDefine);
    }
}

