/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.activity;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TmAction;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.activity.domain.TmCustomizeTags;
import com.digiwin.athena.uibot.activity.domain.TmDataFilter;
import com.digiwin.athena.uibot.activity.domain.TmDataState;
import com.digiwin.athena.uibot.activity.domain.TmOperation;
import com.digiwin.athena.uibot.activity.domain.TmPage;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.activity.domain.TmSummaryField;
import com.digiwin.athena.uibot.constant.ErrorCodeEnum;
import com.digiwin.athena.uibot.domain.DataTag;
import com.digiwin.athena.uibot.util.AttachmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.util.StringUtils;

public abstract class DesignerAbstractPageDefineAnalyzer<T extends PageDefine> {
    protected T createPageDefine(ExecuteContext executeContext, TmActivity tmActivity) {
        TmPage tmPage = tmActivity.getPages();
        if (CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
            return null;
        }
        this.addDefaultConfigInfo(executeContext, tmActivity);
        TmDataState dataState = (TmDataState)tmPage.getDataStates().get(0);
        return this.createPageDefine(executeContext, tmActivity, tmPage, dataState);
    }

    public List<T> createPageDefines(ExecuteContext executeContext, TmActivity tmActivity) {
        ArrayList<T> pageDefines = new ArrayList<T>();
        if (tmActivity.getPages() == null) {
            return pageDefines;
        }
        TmPage tmPage = tmActivity.getPages();
        if (CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
            return pageDefines;
        }
        this.addDefaultConfigInfo(executeContext, tmActivity);
        for (TmDataState dataState : tmPage.getDataStates()) {
            T pageDefine = this.createPageDefine(executeContext, tmActivity, tmPage, dataState);
            if (!StringUtils.isEmpty((Object)tmPage.getTitle())) {
                pageDefine.setTitle(tmPage.getTitle());
                pageDefine.setSubTitle(tmActivity.getActivityName().toString());
            } else {
                pageDefine.setTitle(tmActivity.getActivityName().toString());
                pageDefine.setSubTitle(tmActivity.getActivityName().toString());
            }
            if (!StringUtils.isEmpty((Object)tmPage.getDescription())) {
                pageDefine.setDescription(tmPage.getDescription());
            }
            pageDefines.add(pageDefine);
        }
        if (tmPage.getDataStates().size() == 1 && pageDefines.size() == 1) {
            ((PageDefine)pageDefines.get(0)).setDefaultShow(true);
        }
        return pageDefines;
    }

    private T createPageDefine(ExecuteContext executeContext, TmActivity tmActivity, TmPage tmPage, TmDataState dataState) {
        T pageDefine = this.createNewPageDefine();
        ExecuteContext newExecuteContext = this.createNewContext(executeContext);
        pageDefine.setExecuteContext(newExecuteContext);
        newExecuteContext.setDataStateCode(dataState.getCode());
        pageDefine.setDataStateCode(dataState.getCode());
        pageDefine.setShowSubmitActions(tmPage.getShowSubmitActions());
        this.analysisBaseInfo(newExecuteContext, pageDefine, tmActivity, tmPage);
        pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        TmDataFilter tmDataFilter = null;
        if (CollectionUtils.isNotEmpty((Collection)tmActivity.getDataFilters())) {
            Optional<TmDataFilter> tmDataFilterOptional = tmActivity.getDataFilters().stream().filter(filter -> Objects.equals(filter.getCode(), dataState.getDataFilterCode())).findFirst();
            TmDataFilter tmDataFilter2 = tmDataFilter = tmDataFilterOptional.isPresent() ? tmDataFilterOptional.get() : null;
            if (tmDataFilter != null) {
                pageDefine.setDefaultShow(tmDataFilter.getDefaultFilter().booleanValue());
            }
        }
        if (MapUtils.isNotEmpty((Map)tmActivity.getDataSources())) {
            Map<String, TmQueryAction> dataSources = this.getDataSources(tmDataFilter, tmActivity);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
            pageDefine.setDataSources(dataSources);
            this.analysisDataSource(newExecuteContext, pageDefine, tmActivity, dataState, dataSources, tmDataFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)dataState.getOperations())) {
            this.analysisOperators(newExecuteContext, pageDefine, tmActivity, dataState.getOperations());
        }
        if (CollectionUtils.isNotEmpty((Collection)dataState.getSubmitActions())) {
            this.analysisSubmitActions(newExecuteContext, pageDefine, tmActivity, dataState, dataState.getSubmitActions());
        }
        if (CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions())) {
            pageDefine.setSubmitType(null);
        }
        pageDefine.setExtendedFields(tmPage.getExtendedFields());
        return pageDefine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, TmQueryAction> getDataSources(TmDataFilter tmDataFilter, TmActivity tmActivity) {
        String dataSourceName;
        Map dataSources = new HashMap();
        if (tmActivity.getPages() != null && StringUtils.hasText((String)tmActivity.getPages().getDataSourceName())) {
            dataSourceName = tmActivity.getPages().getDataSourceName();
            if (!tmActivity.getDataSources().containsKey(dataSourceName)) {
                String message = String.format("\u6570\u636e\u8fc7\u6ee4:%s\u5b9a\u4e49\u7684\u6570\u636e\u6e90:%s\u4e0d\u5b58\u5728", tmDataFilter != null ? tmDataFilter.getCode() : "", dataSourceName);
                throw BusinessException.create((String)ErrorCodeEnum.FILTER_DATA_SOURCE_NOT_EXIST.getErrCode(), (String)message);
            }
        } else {
            String dataSourceName2;
            block6: {
                if (tmDataFilter == null) return tmActivity.getDataSources();
                if (tmDataFilter.getDataSourceNames() == null) {
                    return tmActivity.getDataSources();
                }
                Iterator iterator = tmDataFilter.getDataSourceNames().iterator();
                while (iterator.hasNext()) {
                    dataSourceName2 = (String)iterator.next();
                    if (tmActivity.getDataSources().containsKey(dataSourceName2)) {
                        dataSources.put(dataSourceName2, tmActivity.getDataSources().get(dataSourceName2));
                        continue;
                    }
                    break block6;
                }
                return dataSources;
            }
            String message = String.format("\u6570\u636e\u8fc7\u6ee4:%s\u5b9a\u4e49\u7684\u6570\u636e\u6e90:%s\u4e0d\u5b58\u5728", tmDataFilter.getCode(), dataSourceName2);
            throw BusinessException.create((String)ErrorCodeEnum.FILTER_DATA_SOURCE_NOT_EXIST.getErrCode(), (String)message);
        }
        dataSources.put(dataSourceName, tmActivity.getDataSources().get(dataSourceName));
        return dataSources;
    }

    protected abstract T createNewPageDefine();

    protected ExecuteContext createNewContext(ExecuteContext oldExecuteContext) {
        return oldExecuteContext;
    }

    protected void addDefaultConfigInfo(ExecuteContext executeContext, TmActivity tmActivity) {
        AttachmentUtil.addDefaultAttachmentDataSourceProcess((ExecuteContext)executeContext, (TmActivity)tmActivity);
        AttachmentUtil.appendEffectAfterSubmitAction((ExecuteContext)executeContext, (TmActivity)tmActivity);
    }

    protected void analysisApprove(ExecuteContext executeContext, T pageDefine, TmActivity tmActivity, TmPage tmPage, TmDataState dataState) {
    }

    protected void analysisBaseInfo(ExecuteContext executeContext, T pageDefine, TmActivity tmActivity, TmPage tmPage) {
        if (StringUtils.isEmpty((Object)tmPage.getTitle()) && tmActivity.getActivityName() != null) {
            pageDefine.setTitle(tmActivity.getActivityName().toString());
        } else {
            pageDefine.setTitle(tmPage.getTitle());
        }
        if (StringUtils.isEmpty((Object)tmPage.getSubTitle()) && tmActivity.getActivityName() != null) {
            pageDefine.setSubTitle(tmActivity.getActivityName().toString());
        } else {
            pageDefine.setSubTitle(tmPage.getSubTitle());
        }
        pageDefine.setDescription(tmPage.getDescription());
        pageDefine.setSubDescription(tmPage.getSubDescription());
    }

    private void analysisSettings(PageDefine pageDefine, JSONObject settings) {
        pageDefine.setSettings(settings);
    }

    protected void analysisSummaryFields(T pageDefine, TmDataState tmDataState, List<TmSummaryField> summaryFields) {
        ArrayList<DataTag> dataTags = new ArrayList<DataTag>();
        for (TmSummaryField tmSummaryField : summaryFields) {
            DataTag dataTagDTO = new DataTag();
            dataTags.add(dataTagDTO);
            dataTagDTO.setField(String.format("%s.response.%s", tmSummaryField.getActionId(), tmSummaryField.getValue()));
            dataTagDTO.setTag(tmSummaryField.getTag());
            dataTagDTO.setTags(tmSummaryField.getTags());
            dataTagDTO.setBusinessInfo(tmSummaryField.getBusinessInfo());
            dataTagDTO.setSummary(tmSummaryField.getSummary());
            dataTagDTO.setSearchKey(tmSummaryField.getSearchKey());
        }
        pageDefine.setDataTags(dataTags);
    }

    public T createCheckCompleteAction(ExecuteContext executeContext, TmActivity tmActivity) {
        if (tmActivity.getPages() == null) {
            return null;
        }
        TmPage tmPage = tmActivity.getPages();
        if (CollectionUtils.isEmpty((Collection)tmPage.getDataStates())) {
            return null;
        }
        this.addDefaultConfigInfo(executeContext, tmActivity);
        ArrayList<T> pageDefines = new ArrayList<T>();
        for (TmDataState dataState : tmPage.getDataStates()) {
            T pageDefine = this.createCompleteActionPageDefine(executeContext, tmActivity, tmPage, dataState);
            if (pageDefine.isDefaultShow()) {
                return pageDefine;
            }
            pageDefines.add(pageDefine);
        }
        if (CollectionUtils.isNotEmpty(pageDefines)) {
            return (T)((PageDefine)pageDefines.get(0));
        }
        return null;
    }

    private T createCompleteActionPageDefine(ExecuteContext executeContext, TmActivity tmActivity, TmPage tmPage, TmDataState dataState) {
        T pageDefine = this.createNewPageDefine();
        ExecuteContext newExecuteContext = this.createNewContext(executeContext);
        pageDefine.setExecuteContext(newExecuteContext);
        newExecuteContext.setDataStateCode(dataState.getCode());
        pageDefine.setDataStateCode(dataState.getCode());
        pageDefine.setShowSubmitActions(tmPage.getShowSubmitActions());
        this.analysisBaseInfo(newExecuteContext, pageDefine, tmActivity, tmPage);
        pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        TmDataFilter tmDataFilter = null;
        if (CollectionUtils.isNotEmpty((Collection)tmActivity.getDataFilters())) {
            Optional<TmDataFilter> tmDataFilterOptional = tmActivity.getDataFilters().stream().filter(filter -> Objects.equals(filter.getCode(), dataState.getDataFilterCode())).findFirst();
            TmDataFilter tmDataFilter2 = tmDataFilter = tmDataFilterOptional.isPresent() ? tmDataFilterOptional.get() : null;
            if (tmDataFilter != null) {
                pageDefine.setDefaultShow(tmDataFilter.getDefaultFilter().booleanValue());
            }
        }
        if (MapUtils.isNotEmpty((Map)tmActivity.getDataSources())) {
            Map<String, TmQueryAction> dataSources = this.getDataSources(tmDataFilter, tmActivity);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
            this.analysisDataSource(newExecuteContext, pageDefine, tmActivity, dataState, dataSources, tmDataFilter);
        }
        if (CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions())) {
            pageDefine.setSubmitType(null);
        }
        pageDefine.setExtendedFields(tmPage.getExtendedFields());
        return pageDefine;
    }

    protected void analysisSubmitActions(ExecuteContext executeContext, T pageDefine, TmActivity tmActivity, TmDataState dataState, List<TmAction> submitActions) {
    }

    protected void analysisOperators(ExecuteContext executeContext, T pageDefine, TmActivity tmActivity, List<TmOperation> operations) {
    }

    protected abstract void analysisDataSource(ExecuteContext var1, T var2, TmActivity var3, TmDataState var4, Map<String, TmQueryAction> var5, TmDataFilter var6);

    protected void analysisCustomizeTags(T pageDefine, List<TmCustomizeTags> customizeTags) {
        ArrayList<DataTag> dataTags = new ArrayList<DataTag>();
        for (TmCustomizeTags customizeTag : customizeTags) {
            DataTag dataTagDTO = new DataTag();
            dataTags.add(dataTagDTO);
            dataTagDTO.setField(String.format("%s.response.%s", customizeTag.getActionId(), customizeTag.getValue()));
            dataTagDTO.setTag(customizeTag.getTag());
            dataTagDTO.setTags(customizeTag.getTags());
        }
        pageDefine.setDataTags(dataTags);
    }
}

