/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.activity;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.uibot.activity.DesignerAbstractPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.DataSourceDTO;
import com.digiwin.athena.uibot.activity.domain.DataSourceSetDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.SubmitAction;
import com.digiwin.athena.uibot.activity.domain.TmAction;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.activity.domain.TmDataFilter;
import com.digiwin.athena.uibot.activity.domain.TmDataState;
import com.digiwin.athena.uibot.activity.domain.TmOperation;
import com.digiwin.athena.uibot.activity.domain.TmPage;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.activity.parser.BaseDataCombineSubmitActionParser;
import com.digiwin.athena.uibot.activity.service.GeneralDataSourceService;
import com.digiwin.athena.uibot.activity.service.TmPageOperationService;
import com.digiwin.athena.uibot.support.adp.AthenaDesignerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignerBaseDataPageDefineAnalyzer
extends DesignerAbstractPageDefineAnalyzer<PageDefine> {
    @Resource
    private AthenaDesignerService athenaDesignerService;
    @Autowired
    private GeneralDataSourceService generalDataSourceService;
    @Autowired
    private TmPageOperationService tmPageOperationService;

    public List<PageDefine> analysis(ExecuteContext executeContext) {
        TmActivity tmActivity = this.athenaDesignerService.getActivityWithoutTaskId(executeContext.getPageCode(), executeContext.getTmActivityId(), executeContext.getLocale());
        executeContext.appendTmActivityInfo(tmActivity);
        executeContext.setIsDesigner(Boolean.valueOf(true));
        return super.createPageDefines(executeContext, tmActivity);
    }

    @Override
    protected void analysisDataSource(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, TmDataState tmDataState, Map<String, TmQueryAction> dataSources, TmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        DataSourceSetDTO dataSourceSet = this.generalDataSourceService.analysis(executeContext, dataSources);
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsRecycle()) && dataSourceSet != null) {
            for (DataSourceDTO dataSourceDTO : dataSourceSet.getDataSourceList()) {
                dataSourceDTO.setType("RECYCLE");
            }
        }
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }

    @Override
    protected PageDefine createNewPageDefine() {
        return new PageDefine();
    }

    @Override
    protected ExecuteContext createNewContext(ExecuteContext oldExecuteContext) {
        return oldExecuteContext.clone();
    }

    @Override
    protected void analysisSubmitActions(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, TmDataState dataState, List<TmAction> submitActions) {
        String mainDataSourceName = pageDefine.getDataSourceSet().getMainDatasource();
        if (pageDefine.isDefaultShow() && CollectionUtils.isNotEmpty(submitActions)) {
            ArrayList<SubmitAction> actionsList = new ArrayList<SubmitAction>();
            List<SubmitAction> tmpSubmitActions = this.analysisBaseDataSubmitActions(executeContext, mainDataSourceName, dataState, submitActions);
            if (CollectionUtils.isNotEmpty(tmpSubmitActions)) {
                actionsList.addAll(tmpSubmitActions);
            }
            if (!actionsList.isEmpty()) {
                ((SubmitAction)actionsList.get(0)).setDefaultAction(true);
            }
            pageDefine.setSubmitActions(actionsList);
            pageDefine.setSubmitType(dataState.getSubmitType());
            pageDefine.setMultipleSelectMerge(dataState.getMultipleSelectMerge());
        }
    }

    private List<SubmitAction> analysisBaseDataSubmitActions(ExecuteContext executeContext, String mainDataSourceName, TmDataState dataState, List<TmAction> submitActions) {
        BaseDataCombineSubmitActionParser parser = (BaseDataCombineSubmitActionParser)SpringUtil.getBean((String)"baseDataCombineSubmitActionParser", BaseDataCombineSubmitActionParser.class);
        parser.init(executeContext, dataState, mainDataSourceName);
        return parser.parse(submitActions);
    }

    @Override
    protected void analysisOperators(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, List<TmOperation> operations) {
        if (null == executeContext.getIsRecycle() || BooleanUtils.isFalse((Boolean)executeContext.getIsRecycle())) {
            this.tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
        }
    }

    @Override
    protected void analysisBaseInfo(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, TmPage tmPage) {
        super.analysisBaseInfo(executeContext, pageDefine, tmActivity, tmPage);
        if (("browse-page".equals(executeContext.getPageCode()) || "basic-data".equals(executeContext.getPageCode())) && ("DOUBLE-DOCUMENT".equals(executeContext.getCategory()) || "RECYCLE".equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(Boolean.valueOf(false));
        }
        if ("basic-data".equals(executeContext.getPageCode()) && ("SIGN-DOCUMENT".equals(executeContext.getCategory()) || "TREEDATA-SINGLE-DOCUMENT".equals(executeContext.getCategory()) || "SINGLE-DOCUMENT".equals(executeContext.getCategory()))) {
            pageDefine.setCanEdit(Boolean.valueOf(true));
        }
        if (("edit-page".equals(executeContext.getPageCode()) || "basic-data".equals(executeContext.getPageCode())) && "DOUBLE-DOCUMENT".equals(executeContext.getCategory())) {
            pageDefine.setCanEdit(Boolean.valueOf(true));
        }
    }
}

