/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.activity;

import com.digiwin.athena.uibot.activity.DesignerAbstractPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.DataSourceSetDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TmAction;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.activity.domain.TmDataFilter;
import com.digiwin.athena.uibot.activity.domain.TmDataState;
import com.digiwin.athena.uibot.activity.domain.TmOperation;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.activity.service.TmDataSourceService;
import com.digiwin.athena.uibot.activity.service.TmPageOperationService;
import com.digiwin.athena.uibot.activity.service.TmPageSubmitService;
import com.digiwin.athena.uibot.support.adp.AthenaDesignerService;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="designerConditionPageAnalyzer")
public class DesignerConditionPageAnalyzer
extends DesignerAbstractPageDefineAnalyzer<PageDefine> {
    @Resource
    AthenaDesignerService athenaDesignerService;
    @Autowired
    private TmDataSourceService tmDataSourceService;
    @Autowired
    TmPageOperationService tmPageOperationService;
    @Autowired
    TmPageSubmitService tmPageSubmitService;
    @Autowired
    private ThemeMapService themeMapService;

    public PageDefine analysis(ExecuteContext executeContext) {
        TmActivity tmActivity = this.athenaDesignerService.getActivityWithoutTaskId(executeContext.getPageCode(), executeContext.getTmActivityId(), executeContext.getLocale());
        executeContext.appendTmActivityInfo(tmActivity);
        executeContext.setIsDesigner(Boolean.valueOf(true));
        return super.createPageDefine(executeContext, tmActivity);
    }

    @Override
    protected PageDefine createNewPageDefine() {
        return new PageDefine();
    }

    @Override
    protected void analysisSubmitActions(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, TmDataState dataState, List<TmAction> submitActions) {
        pageDefine.setDefaultShow(true);
        this.tmPageSubmitService.processBaseData(executeContext, tmActivity, dataState, pageDefine);
    }

    @Override
    protected void analysisOperators(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, List<TmOperation> operations) {
        this.tmPageOperationService.createOperations(executeContext, pageDefine, tmActivity, operations);
    }

    @Override
    protected void analysisDataSource(ExecuteContext executeContext, PageDefine pageDefine, TmActivity tmActivity, TmDataState tmDataState, Map<String, TmQueryAction> dataSources, TmDataFilter tmDataFilter) {
        pageDefine.setDefaultShow(true);
        DataSourceSetDTO dataSourceSet = this.tmDataSourceService.analysis(executeContext, dataSources);
        pageDefine.setDataSourceSet(dataSourceSet);
        pageDefine.setDataStateCode(tmDataState.getCode());
    }
}

