/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.config;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.PageUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.uibot.dao.WordTaskMetadataDao;
import com.digiwin.athena.uibot.dao.WordTaskTagDao;
import com.digiwin.athena.uibot.domain.word.WordTaskMetadata;
import com.digiwin.athena.uibot.domain.word.WordTaskTag;
import com.digiwin.athena.uibot.support.thememap.domain.MetadataField;
import com.digiwin.athena.uibot.support.thememap.domain.MetadataTagResult;
import com.digiwin.athena.uibot.support.thememap.domain.Task;
import com.digiwin.athena.uibot.support.thememap.domain.ThemeMapTag;
import com.digiwin.athena.uibot.support.thememap.param.WordDimension;
import com.digiwin.athena.uibot.support.thememap.param.req.TaskPageRequest;
import com.digiwin.athena.uibot.support.thememap.param.resp.TaskResponse;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import com.digiwin.athena.uibot.util.UiBotUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FetchTagScheduler {
    private static final Logger log = LoggerFactory.getLogger(FetchTagScheduler.class);
    @Value(value="${uibot.word.tag.fetch.enable}")
    private Boolean fetchEnable;
    @Value(value="${uibot.word.tag.fetch.cron}")
    private String fetchCron;
    @Resource
    private WordTaskTagDao wordTaskTagDao;
    @Resource
    private WordTaskMetadataDao wordTaskMetadataDao;
    @Resource
    private ThemeMapService themeMapService;
    public static final Integer FETCH_PAGE_SIZE = 50;

    @Async
    @Scheduled(cron="${uibot.word.tag.fetch.cron}")
    public void fetchTag() {
        log.info("=== FetchTagEnable: {}, cron: {}", (Object)this.fetchEnable, (Object)this.fetchCron);
        if (BooleanUtils.isNotTrue((Boolean)this.fetchEnable)) {
            return;
        }
        log.info("=== FetchTag begin");
        long start = System.currentTimeMillis();
        TaskResponse taskResponse = this.queryAndSaveBatch(0);
        int totalPage = 1;
        if (taskResponse != null) {
            Integer totalCount = taskResponse.getTotal();
            totalPage = PageUtil.totalPage((int)totalCount, (int)FETCH_PAGE_SIZE);
            for (int i = 1; i < totalPage; ++i) {
                this.queryAndSaveBatch(i);
            }
        }
        long cost = System.currentTimeMillis() - start;
        long average = cost / (long)totalPage;
        log.info("=== FetchTag finish, cost: {}ms, average: {}ms", (Object)cost, (Object)average);
    }

    private TaskResponse queryAndSaveBatch(int pageNum) {
        try {
            TaskPageRequest taskPageRequest = ((TaskPageRequest.TaskPageRequestBuilder)((TaskPageRequest.TaskPageRequestBuilder)TaskPageRequest.builder().pageNum(Integer.valueOf(pageNum))).pageSize(FETCH_PAGE_SIZE)).build();
            TaskResponse taskResponse = this.themeMapService.queryTaskPage(taskPageRequest);
            ((FetchTagScheduler)SpringUtil.getBean(FetchTagScheduler.class)).removeAndSaveBatch(taskResponse);
            return taskResponse;
        }
        catch (Exception e) {
            log.error("Save batch error", (Throwable)e);
            return null;
        }
    }

    @Transactional
    public void removeAndSaveBatch(TaskResponse taskResponsePageResult) {
        if (taskResponsePageResult == null) {
            return;
        }
        ArrayList wordTaskMetadataList = Lists.newArrayList();
        ArrayList wordTaskTagList = Lists.newArrayList();
        this.buildAndCollect(taskResponsePageResult, wordTaskTagList, wordTaskMetadataList);
        if (CollectionUtils.isNotEmpty((Collection)wordTaskTagList)) {
            Set activityIdSet = wordTaskTagList.stream().map(WordTaskTag::getActivityId).collect(Collectors.toSet());
            this.wordTaskTagDao.remove((Wrapper)Wrappers.lambdaQuery(WordTaskTag.class).in(WordTaskTag::getActivityId, activityIdSet));
            this.wordTaskTagDao.saveBatch((Collection)wordTaskTagList);
        }
        if (CollectionUtils.isNotEmpty((Collection)wordTaskMetadataList)) {
            Set actionIdSet = wordTaskMetadataList.stream().map(WordTaskMetadata::getActionId).collect(Collectors.toSet());
            this.wordTaskMetadataDao.remove((Wrapper)Wrappers.lambdaQuery(WordTaskMetadata.class).in(WordTaskMetadata::getActionId, actionIdSet));
            this.wordTaskMetadataDao.saveBatch((Collection)wordTaskMetadataList);
        }
    }

    private void buildAndCollect(TaskResponse taskResponsePageResult, List<WordTaskTag> wordTaskTagList, List<WordTaskMetadata> wordTaskMetadataList) {
        List taskList = taskResponsePageResult.getData();
        Map actionMetaMap = taskResponsePageResult.getActionMetas();
        for (Task task : taskList) {
            List actionIds;
            String actionId;
            MetadataField metadataField;
            String activityId = task.getActivityId();
            String pageCode = task.getPageCode();
            String pattern = task.getPattern();
            String category = task.getCategory();
            Map tagMap = task.getTags();
            String categoryCode = null;
            WordDimension dimension = task.getDimension();
            if (dimension != null) {
                List categories = dimension.getCategories();
                categoryCode = (String)CollUtil.getFirst((Iterable)categories);
            }
            if ((metadataField = (MetadataField)actionMetaMap.get(actionId = (String)CollUtil.getFirst((Iterable)(actionIds = task.getActionIds())))) == null) continue;
            List taskTagList = tagMap.getOrDefault(actionId, Lists.newArrayList());
            Map<String, List<ThemeMapTag>> fieldNameMap = taskTagList.stream().collect(Collectors.toMap(ele -> {
                String response = ele.toString();
                return UiBotUtils.subAfter((String)response, (String)".");
            }, MetadataTagResult::getTags, (v1, v2) -> v2));
            this.markTagOnField(metadataField, fieldNameMap);
            WordTaskTag wordTaskTag = new WordTaskTag();
            wordTaskTag.setActivityId(activityId);
            wordTaskTag.setApplication(task.getApplication());
            wordTaskTag.setPageCode(pageCode);
            wordTaskTag.setPattern(pattern);
            wordTaskTag.setCategory(category);
            wordTaskTag.setCategoryCode(categoryCode);
            wordTaskTag.setActionId(actionId);
            this.buildCollect(metadataField, wordTaskTag, wordTaskTagList, wordTaskMetadataList);
        }
    }

    private void buildCollect(MetadataField metadataField, WordTaskTag wordTaskTag, List<WordTaskTag> wordTaskTagList, List<WordTaskMetadata> wordTaskMetadataList) {
        String fieldName = metadataField.getDataName();
        String dataType = metadataField.getDataType();
        List fieldList = metadataField.getField();
        if ("object".equals(dataType) && CollectionUtils.isNotEmpty((Collection)fieldList)) {
            for (MetadataField field : fieldList) {
                this.buildCollect(field, wordTaskTag, wordTaskTagList, wordTaskMetadataList);
            }
        } else {
            WordTaskTag wordTaskTagInner = (WordTaskTag)BeanUtil.copyProperties((Object)wordTaskTag, WordTaskTag.class, (String[])new String[0]);
            wordTaskTagInner.setWordCode(fieldName);
            wordTaskTagInner.setWordDataType(dataType);
            List tagList = metadataField.getTagList();
            if (CollectionUtils.isNotEmpty((Collection)tagList)) {
                for (ThemeMapTag tag : tagList) {
                    wordTaskTagInner = (WordTaskTag)BeanUtil.copyProperties((Object)wordTaskTagInner, WordTaskTag.class, (String[])new String[0]);
                    wordTaskTagInner.setTagId(tag.getId());
                    wordTaskTagInner.setTagCode(tag.getCode());
                    wordTaskTagInner.setTagName(tag.getName());
                    wordTaskTagInner.setTagCategory(tag.getCategory());
                    wordTaskTagList.add(wordTaskTagInner);
                }
            } else {
                WordTaskMetadata wordTaskMetadata = new WordTaskMetadata();
                wordTaskMetadata.setActionId(wordTaskTag.getActionId());
                wordTaskMetadata.setWordCode(fieldName);
                wordTaskMetadata.setWordDataType(dataType);
                wordTaskMetadataList.add(wordTaskMetadata);
            }
        }
    }

    private void markTagOnField(MetadataField metadataField, Map<String, List<ThemeMapTag>> fieldNameMap) {
        String fieldName = metadataField.getDataName();
        String dataType = metadataField.getDataType();
        List fieldList = metadataField.getField();
        if ("object".equals(dataType) && CollectionUtils.isNotEmpty((Collection)fieldList)) {
            for (MetadataField field : fieldList) {
                this.markTagOnField(field, fieldNameMap);
            }
        } else {
            metadataField.setTagList(fieldNameMap.getOrDefault(fieldName, Lists.newArrayList()));
        }
    }
}

