/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.service.impl;

import com.digiwin.athena.uibot.activity.DesignerBaseDataPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.analyzer.BaseDataDoubleDocumentPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.analyzer.BaseDataTreeDocumentPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.domain.DataSourceDTO;
import com.digiwin.athena.uibot.activity.domain.DoubleDocumentPageDefine;
import com.digiwin.athena.uibot.activity.domain.OperationDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.builder.BaseDataDoubleDocumentPageBuilder;
import com.digiwin.athena.uibot.component.domain.FormComponent;
import com.digiwin.athena.uibot.constant.ActivityConstants;
import com.digiwin.athena.uibot.designering.builder.DesignerBasicDataSingleDocumentPageBuilder;
import com.digiwin.athena.uibot.designering.service.DesigerBaseDataPageService;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.DynamicLayout;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.service.GeneralPageService;
import com.digiwin.athena.uibot.support.atdm.DataQueryService;
import com.digiwin.athena.uibot.template.AbstractBasicDataGeneralPageTemplate;
import com.digiwin.athena.uibot.template.BasicDataTreeDataDocmentGeneralPageTemplate;
import com.digiwin.athena.uibot.template.GeneralPageTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignerBaseDataPageServiceImpl
implements DesigerBaseDataPageService,
InitializingBean {
    private static final String EDIT_TYPE_ADD = "add";
    @Autowired
    BaseDataDoubleDocumentPageBuilder baseDataDoubleDocumentPageBuilder;
    @Autowired
    private DesignerBasicDataSingleDocumentPageBuilder designerBasicDataSingleDocumentPageBuilder;
    @Autowired
    private DesignerBaseDataPageDefineAnalyzer designerBaseDataPageDefineAnalyzer;
    @Autowired
    private BaseDataDoubleDocumentPageDefineAnalyzer baseDataDoubleDocumentPageDefineAnalyzer;
    @Autowired
    private BaseDataTreeDocumentPageDefineAnalyzer baseDataTreeDocumentPageDefineAnalyzer;
    @Autowired
    private List<AbstractBasicDataGeneralPageTemplate> allTemplateService;
    @Autowired
    private GeneralPageService generalPageService;
    @Autowired
    private BasicDataTreeDataDocmentGeneralPageTemplate basicDataTreeDataDocmentGeneralPageTemplate;
    private Map<String, AbstractBasicDataGeneralPageTemplate> templateServiceRegister = new HashMap<String, AbstractBasicDataGeneralPageTemplate>();
    @Autowired
    private DataQueryService dataQueryService;

    public void afterPropertiesSet() throws Exception {
        if (CollectionUtils.isNotEmpty(this.allTemplateService)) {
            for (AbstractBasicDataGeneralPageTemplate basicDataTemplateService : this.allTemplateService) {
                String supportKey = basicDataTemplateService.supportKey();
                if (this.templateServiceRegister.containsKey(supportKey)) {
                    throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\uff0c\u8bf7\u91cd\u4fee\u6539\u4ee3\u7801\uff1a" + supportKey);
                }
                this.templateServiceRegister.put(supportKey, basicDataTemplateService);
            }
        }
    }

    @Override
    public DynamicForm creatDoubleBrowsePageBasicDataTaskTemplateForm(ExecuteContext executeContext) {
        List actionList = this.baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isNotEmpty((Collection)actionList)) {
            QueryResultSet queryResultSet = this.baseDataDoubleDocumentPageBuilder.BuildDataSource(((DoubleDocumentPageDefine)actionList.get(0)).getExecuteContext(), (DoubleDocumentPageDefine)actionList.get(0));
            DynamicForm dynamicForm = this.baseDataDoubleDocumentPageBuilder.createPage(((DoubleDocumentPageDefine)actionList.get(0)).getExecuteContext(), queryResultSet, (DoubleDocumentPageDefine)actionList.get(0));
            return dynamicForm;
        }
        return new DynamicForm();
    }

    @Override
    public DynamicForm creatDoubleEditPageBasicDataTaskTemplateForm(ExecuteContext executeContext, DoubleDocumentPageDefine pageDefine) {
        List actionList = this.baseDataDoubleDocumentPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isNotEmpty((Collection)actionList)) {
            DoubleDocumentPageDefine actionPageDefine = (DoubleDocumentPageDefine)actionList.get(0);
            if (pageDefine.getParameter() == null) {
                actionPageDefine.setEditType(EDIT_TYPE_ADD);
            } else {
                actionPageDefine.setEditType(pageDefine.getEditType());
            }
            actionPageDefine.setParameter(pageDefine.getParameter());
            QueryResultSet queryResultSet = null;
            if (EDIT_TYPE_ADD.equals(actionPageDefine.getEditType())) {
                queryResultSet = QueryResultSet.empty();
                queryResultSet.getMainQueryResult().setDataSourceName(actionPageDefine.getDataSourceName());
            } else {
                queryResultSet = this.getQueryResultSet(actionPageDefine);
            }
            DynamicForm dynamicForm = this.baseDataDoubleDocumentPageBuilder.createPage(actionPageDefine.getExecuteContext(), queryResultSet, actionPageDefine);
            return dynamicForm;
        }
        return new DynamicForm();
    }

    private QueryResultSet getQueryResultSet(DoubleDocumentPageDefine pageDefine) {
        QueryResultSet queryResultSet = this.dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), (PageDefine)pageDefine);
        if (MapUtils.isNotEmpty((Map)queryResultSet.getPageData())) {
            this.appendFieldForRowData(queryResultSet.getPageData());
        }
        return queryResultSet;
    }

    private void appendFieldForRowData(Map<String, Object> pageData) {
        for (Object data : pageData.values()) {
            if (data instanceof List) {
                List rowDataList = (List)data;
                for (Object rowData : rowDataList) {
                    Map rowDataMap = (Map)rowData;
                    rowDataMap.putAll(ActivityConstants.EDIT_TYPE_MAP);
                }
                continue;
            }
            if (!(data instanceof Map)) continue;
            Map rowDataMap = (Map)data;
            rowDataMap.putAll(ActivityConstants.EDIT_TYPE_MAP);
        }
    }

    @Override
    public DynamicForm createBasicDataTaskTemplateForm(ExecuteContext executeContext) {
        List<PageDefine> actionList = this.designerBaseDataPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isNotEmpty(actionList)) {
            if (executeContext.getPattern() != null && "CUSTOM".equals(executeContext.getPattern())) {
                TaskPageDefine taskPageDefine = new TaskPageDefine();
                taskPageDefine.setExecuteContext(executeContext);
                taskPageDefine.setDefaultShow(false);
                taskPageDefine.setParameter(actionList.get(0).getParameter());
                taskPageDefine.setSubmitType(actionList.get(0).getSubmitType());
                taskPageDefine.setDataSourceSet(actionList.get(0).getDataSourceSet());
                return this.generalPageService.createPage(executeContext, (PageDefine)taskPageDefine);
            }
            QueryResultSet queryResultSet = this.designerBasicDataSingleDocumentPageBuilder.BuildDataSource(actionList.get(0).getExecuteContext(), actionList.get(0));
            return this.designerBasicDataSingleDocumentPageBuilder.createPage(executeContext, queryResultSet, actionList.get(0));
        }
        return new DynamicForm();
    }

    @Override
    public DynamicForm createRecycleBasicDataTaskTemplateForm(ExecuteContext executeContext) {
        List<PageDefine> actionList = this.designerBaseDataPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isNotEmpty(actionList)) {
            GeneralPageTemplate generalPageTemplate;
            boolean isDoubleDocument = StringUtils.equals((CharSequence)"DOUBLE-DOCUMENT", (CharSequence)actionList.get(0).getExecuteContext().getCategory());
            if (isDoubleDocument) {
                executeContext.setPageCode("browse-page");
                actionList = this.designerBaseDataPageDefineAnalyzer.analysis(executeContext);
            }
            if (null != (generalPageTemplate = this.findTemplateService(executeContext))) {
                return generalPageTemplate.createTaskPage(executeContext, actionList.get(0), null);
            }
            return new DynamicForm();
        }
        return new DynamicForm();
    }

    private GeneralPageTemplate findTemplateService(ExecuteContext executeContext) {
        String templateName;
        if (BooleanUtils.isTrue((Boolean)executeContext.getIsRecycle()) && this.templateServiceRegister.containsKey(templateName = StringUtils.lowerCase((String)(executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-recycle")))) {
            return (GeneralPageTemplate)this.templateServiceRegister.get(templateName);
        }
        templateName = StringUtils.lowerCase((String)(executeContext.getClientAgent() + "-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + executeContext.getRelationTag().getIdentity()));
        if (this.templateServiceRegister.containsKey(templateName)) {
            return (GeneralPageTemplate)this.templateServiceRegister.get(templateName);
        }
        templateName = StringUtils.lowerCase((String)(executeContext.getClientAgent() + "-" + executeContext.getPattern()));
        if (this.templateServiceRegister.containsKey(templateName)) {
            return (GeneralPageTemplate)this.templateServiceRegister.get(templateName);
        }
        return null;
    }

    @Override
    public Object getToolsShow(ExecuteContext executeContext) {
        ArrayList<String> pageCodes = new ArrayList<String>();
        pageCodes.add("basic-data");
        pageCodes.add("browse-page");
        ArrayList actionList = new ArrayList();
        pageCodes.forEach(pagecode -> {
            executeContext.setPageCode(pagecode);
            actionList.addAll(this.designerBaseDataPageDefineAnalyzer.analysis(executeContext));
        });
        ArrayList<OperationDTO> operations = new ArrayList<OperationDTO>();
        if (CollectionUtils.isNotEmpty(actionList)) {
            for (PageDefine pageDefine : actionList) {
                if (!CollectionUtils.isNotEmpty((Collection)pageDefine.getOperations())) continue;
                for (OperationDTO operation : pageDefine.getOperations()) {
                    if (!BooleanUtils.isTrue((Boolean)operation.getEnableToolShow())) continue;
                    operations.add(operation);
                }
            }
        }
        HashMap<String, ArrayList<OperationDTO>> operationsMap = new HashMap<String, ArrayList<OperationDTO>>();
        operationsMap.put("operations", operations);
        return operationsMap;
    }

    @Override
    public List<DynamicLayout> creatTreeDataBrowsePageBasicDataTaskTemplateForm(ExecuteContext executeContext) {
        List actionList = this.baseDataTreeDocumentPageDefineAnalyzer.analysis(executeContext);
        if (CollectionUtils.isNotEmpty((Collection)actionList)) {
            return this.createTreePage(executeContext, (PageDefine)actionList.get(0));
        }
        return new ArrayList<DynamicLayout>();
    }

    private List<DynamicLayout> createTreePage(ExecuteContext executeContext, PageDefine mainAction) {
        List dynamicLayouts = this.basicDataTreeDataDocmentGeneralPageTemplate.createTreePage(executeContext, mainAction);
        DynamicLayout rightLayout = new DynamicLayout();
        rightLayout.setPosition("right");
        if (mainAction.getDataSourceSet() != null && CollectionUtils.isNotEmpty((Collection)mainAction.getDataSourceSet().getDataSourceList()) && mainAction.getDataSourceSet().getDataSourceList().size() > 0) {
            rightLayout.setTitle(((DataSourceDTO)mainAction.getDataSourceSet().getDataSourceList().get(0)).getTitle());
        }
        rightLayout.setEnableShow(Boolean.valueOf(true));
        if ("TestTreeData".equals(executeContext.getTmActivityId())) {
            executeContext.setCategory("TREEDATA-SINGLE-DOCUMENT");
        }
        ExecuteContext newExecuteContext = executeContext.clone();
        if ("TREEDATA-DOUBLE-DOCUMENT".equals(executeContext.getCategory())) {
            newExecuteContext.setCategory("DOUBLE-DOCUMENT");
            if (mainAction instanceof DoubleDocumentPageDefine) {
                DoubleDocumentPageDefine documentPageDefine = (DoubleDocumentPageDefine)mainAction;
                QueryResultSet queryResultSet = QueryResultSet.empty();
                if (documentPageDefine.getDataSourceSet() != null) {
                    queryResultSet.getMainQueryResult().setDataSourceName(documentPageDefine.getDataSourceSet().getMainDatasource());
                }
                DynamicForm dynamicForm = this.baseDataDoubleDocumentPageBuilder.createPage(newExecuteContext, queryResultSet, documentPageDefine);
                rightLayout.setDynamicForm(dynamicForm);
            }
        } else if ("TREEDATA-SINGLE-DOCUMENT".equals(executeContext.getCategory())) {
            if (executeContext.getPattern() != null && "CUSTOM".equals(executeContext.getPattern())) {
                TaskPageDefine taskPageDefine = new TaskPageDefine();
                taskPageDefine.setExecuteContext(executeContext);
                taskPageDefine.setDefaultShow(false);
                taskPageDefine.setParameter(mainAction.getParameter());
                taskPageDefine.setSubmitType(mainAction.getSubmitType());
                taskPageDefine.setDataSourceSet(mainAction.getDataSourceSet());
                rightLayout.setDynamicForm(this.generalPageService.createOpenPage(executeContext, (PageDefine)taskPageDefine));
            } else {
                List layout;
                newExecuteContext.setCategory("SINGLE-DOCUMENT");
                QueryResultSet queryResultSet = this.designerBasicDataSingleDocumentPageBuilder.BuildDataSource(newExecuteContext, mainAction);
                DynamicForm dynamicForm = this.designerBasicDataSingleDocumentPageBuilder.createPage(newExecuteContext, queryResultSet, mainAction);
                if (CollectionUtils.isNotEmpty((Collection)dynamicForm.getLayout()) && CollectionUtils.isNotEmpty(layout = dynamicForm.getLayout().stream().filter(subLayout -> subLayout instanceof FormComponent).collect(Collectors.toList()))) {
                    rightLayout.setAllBatch(true);
                }
                rightLayout.setDynamicForm(dynamicForm);
            }
        } else {
            rightLayout.setDynamicForm(new DynamicForm());
        }
        dynamicLayouts.add(rightLayout);
        return dynamicLayouts;
    }
}

