/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.service.impl;

import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.builder.TagBuilder;
import com.digiwin.athena.uibot.component.domain.AbstractComponent;
import com.digiwin.athena.uibot.designering.service.DesignerPageBuilder;
import com.digiwin.athena.uibot.domain.BuildContext;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.QueryResult;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.domain.ShowMetadata;
import com.digiwin.athena.uibot.interpreter.ComponentTagInterpreter;
import com.digiwin.athena.uibot.metadata.MetadataService;
import com.digiwin.athena.uibot.metadata.domain.ApiMetadata;
import com.digiwin.athena.uibot.metadata.domain.MetadataField;
import com.digiwin.athena.uibot.service.dealWithService.AnalyseSubmitActionFieldService;
import com.digiwin.athena.uibot.service.dealWithService.EditRangeService;
import com.digiwin.athena.uibot.service.dealWithService.OperationService;
import com.digiwin.athena.uibot.support.adp.AthenaDesignerService;
import com.digiwin.athena.uibot.support.thememap.domain.TaggingData;
import com.digiwin.athena.uibot.tag.domain.TagDefinition;
import com.digiwin.athena.uibot.tag.interpreter.GroupTagInterpreter;
import com.digiwin.athena.uibot.tag.service.DefaultTagUtils;
import com.digiwin.athena.uibot.tag.service.SignTagService;
import com.digiwin.athena.uibot.tag.service.TagDefinitionService;
import com.digiwin.athena.uibot.tag.service.TagService;
import com.digiwin.athena.uibot.util.ApiMetadataUtil;
import com.digiwin.athena.uibot.util.TagUtil;
import io.micrometer.core.instrument.util.StringUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="designerPageBuilder")
public class DesignerPageBuilderBase<T extends PageDefine>
implements DesignerPageBuilder<T> {
    @Autowired
    protected GroupTagInterpreter groupTagInterpreter;
    @Autowired
    protected ComponentTagInterpreter componentTagInterpreter;
    @Autowired
    protected TagService tagService;
    @Autowired
    protected TagDefinitionService tagDefinitionService;
    @Autowired
    protected SignTagService signTagService;
    @Autowired
    AnalyseSubmitActionFieldService analyseSubmitActionFieldService;
    @Autowired
    protected OperationService operationService;
    @Autowired
    EditRangeService editRangeService;
    @Autowired
    AthenaDesignerService athenaDesignerService;
    @Autowired
    TagBuilder tagBuilder;
    @Autowired
    protected MetadataService metadataService;

    @Override
    public String supportKey() {
        return null;
    }

    @Override
    public DynamicForm createPage(ExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine) {
        QueryResult queryResult;
        if (pageDefine == null || pageDefine.getDataSourceSet() == null || pageDefine.getDataSourceSet().getDataSourceList() == null) {
            return new DynamicForm();
        }
        DynamicForm page = new DynamicForm();
        String actionId = null;
        if (pageDefine.getDataSourceSet().getDataSourceList().size() > 0) {
            actionId = pageDefine.getDataSourceSet().getFirstActionId();
        }
        if (Strings.isBlank(actionId)) {
            return new DynamicForm();
        }
        ApiMetadata apiMetadata = null;
        apiMetadata = queryResultSet != null ? ((queryResult = queryResultSet.getMainQueryResult()).getApiMetadataCollection() != null ? queryResult.getApiMetadataCollection().getMasterApiMetadata() : this.athenaDesignerService.getMetadata(executeContext.getLocale(), actionId)) : this.athenaDesignerService.getMetadata(executeContext.getLocale(), actionId);
        if (apiMetadata == null) {
            return new DynamicForm();
        }
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        BuildContext buildContext = this.createBuildContext((PageDefine)pageDefine, queryResultSet, executeContext);
        ShowMetadata showMetadata = this.createShowMetadata(executeContext, (PageDefine)pageDefine, actionId, apiMetadata, queryResultSet);
        page.setStyle(new HashMap());
        HashMap pageData = new HashMap();
        page.setPageData(pageData);
        if (null == executeContext.getRelationTag() || null != executeContext.getRelationTag() && StringUtils.isEmpty((String)executeContext.getRelationTag().getActivityId())) {
            page.setRules(new ArrayList());
        } else {
            page.setRules(this.athenaDesignerService.getRules(executeContext.getRelationTag().getActivityId(), executeContext.getLocale()));
        }
        buildContext.setDynamicForm(page);
        this.operationService.addMetadataOperation(showMetadata, pageDefine.getOperations(), apiMetadata);
        if (showMetadata != null) {
            this.addTagRules("", showMetadata.getShowFields(), page.getRules());
            if (CollectionUtils.isNotEmpty((Collection)showMetadata.getShowFields())) {
                for (MetadataField showField : showMetadata.getShowFields()) {
                    if (pageDefine.getDataSourceSet().getFirstDataQuery().getNotArray() != null && pageDefine.getDataSourceSet().getFirstDataQuery().getName().equals(showField.getName())) {
                        if (pageDefine.getDataSourceSet().getFirstDataQuery().getNotArray().booleanValue()) {
                            showField.setArray(false);
                            ((MetadataField)apiMetadata.getResponseFields().get(0)).setArray(false);
                        } else {
                            showField.setArray(true);
                        }
                    }
                    if (buildContext.getQueryResultSet() == null) continue;
                    boolean isExist = false;
                    for (QueryResult queryResult2 : buildContext.getQueryResultSet().getQueryResults()) {
                        if (showField.getName() == null || !showField.getName().equals(queryResult2.getDataSourceName())) continue;
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                    showField.setName(buildContext.getQueryResultSet().getMainQueryResult().getDataSourceName());
                }
            }
            page.setLayout(this.createComponents(buildContext, showMetadata, apiMetadata));
        }
        this.filterEditRules(executeContext, page.getRules());
        String dataSourceName = "";
        if (queryResultSet == null && pageDefine.getDataSourceSet() != null && pageDefine.getDataSourceSet().getFirstDataQuery() != null) {
            dataSourceName = pageDefine.getDataSourceSet().getFirstDataQuery().getName();
        }
        if (queryResultSet != null && queryResultSet.getMainQueryResult() != null && org.springframework.util.StringUtils.hasText((String)queryResultSet.getMainQueryResult().getDataSourceName())) {
            dataSourceName = queryResultSet.getMainQueryResult().getDataSourceName();
        }
        if (StringUtils.isNotEmpty((String)dataSourceName)) {
            if (CollectionUtils.isNotEmpty((Collection)apiMetadata.getResponseFields()) && apiMetadata.getResponseFields().size() > 0 && !((MetadataField)apiMetadata.getResponseFields().get(0)).isArray()) {
                pageData.put(dataSourceName, new HashMap());
            } else {
                this.mockPageData(showMetadata.getShowFields(), pageData, dataSourceName);
            }
            page.setPageData(pageData);
        }
        page.setPageCountSize(Integer.valueOf(0));
        this.BuildActions(executeContext, pageDefine, page);
        return page;
    }

    protected ShowMetadata createShowMetadata(ExecuteContext executeContext, PageDefine pageDefine, String actionId, ApiMetadata apiMetadata, QueryResultSet queryResultSet) {
        ShowMetadata showMetadata;
        TaggingData taggingData = null;
        this.analyseSubmitActionFieldService.submitMetadataFiledToGetMetadata(executeContext, apiMetadata, pageDefine.getSubmitActions());
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        taggingData = this.tagService.getThemeMapTag(pageDefine.getQueryTagSuffix(), executeContext.getRelationTag(), actionId, "TAG", executeContext);
        if (taggingData != null) {
            this.tagDefinitionService.processTagDefinitions(taggingData, executeContext);
        }
        if ((showMetadata = this.tagBuilder.createShowMetadata(executeContext, pageDefine, taggingData, apiMetadata)) == null) {
            List needShowFields = apiMetadata.getResponseFields();
            for (MetadataField needShowField : needShowFields) {
                needShowField.flatMetaData(null);
            }
            showMetadata = new ShowMetadata();
            showMetadata.setActionId(apiMetadata.getActionId());
            showMetadata.setServiceName(apiMetadata.getServiceName());
            showMetadata.setShowFields(needShowFields);
        }
        this.addDefaultTag(showMetadata.getShowFields());
        return showMetadata;
    }

    protected void addDefaultTag(List<MetadataField> showFields) {
        if (CollectionUtils.isEmpty(showFields)) {
            return;
        }
        for (MetadataField showField : showFields) {
            if (CollectionUtils.isEmpty((Collection)showField.getTagDefinitions()) && !"object".equals(showField.getDataType())) {
                showField.setTagDefinitions(DefaultTagUtils.createDataTypeTagDefinitions((MetadataField)showField));
            }
            this.addDefaultTag(showField.getSubFields());
        }
    }

    @Override
    public ShowMetadata createShowMetadata(ExecuteContext executeContext, PageDefine pageDefine) {
        String actionId = null;
        if (pageDefine.getDataSourceSet().getDataSourceList().size() > 0) {
            actionId = pageDefine.getDataSourceSet().getFirstActionId();
        }
        if (Strings.isBlank(actionId)) {
            return null;
        }
        if (!Objects.equals("ESP", pageDefine.getDataSourceSet().getFirstAction().getCategory())) {
            return null;
        }
        ApiMetadata apiMetadata = this.athenaDesignerService.getMetadata(executeContext.getLocale(), actionId);
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        TaggingData taggingData = this.tagService.getThemeMapTag(pageDefine.getQueryTagSuffix(), executeContext.getRelationTag(), actionId, "TEMPLATE", executeContext);
        if (taggingData == null || CollectionUtils.isEmpty((Collection)taggingData.getMetadataTagResult())) {
            return null;
        }
        return this.tagBuilder.createShowMetadata(executeContext, pageDefine, taggingData, apiMetadata);
    }

    protected List<AbstractComponent> createComponents(BuildContext buildContext, ShowMetadata showMetadata, ApiMetadata apiMetadata) {
        ArrayList<AbstractComponent> components = new ArrayList<AbstractComponent>();
        if (CollectionUtils.isNotEmpty((Collection)showMetadata.getShowFields())) {
            for (MetadataField showField : showMetadata.getShowFields()) {
                AbstractComponent layout = this.createComponent(showField, showField.getSubFields(), buildContext, apiMetadata);
                components.add(layout);
            }
        }
        return components;
    }

    public AbstractComponent createComponent(MetadataField metadataField, List<MetadataField> subFields, BuildContext buildContext, ApiMetadata apiMetadata) {
        ArrayList<MetadataField> bodyShowFields = new ArrayList<MetadataField>();
        if (TagUtil.renderObjectMetadataField((MetadataField)metadataField)) {
            bodyShowFields.add(metadataField);
        } else {
            for (MetadataField showField : subFields) {
                if (TagUtil.renderObjectMetadataField((MetadataField)showField)) {
                    bodyShowFields.add(showField);
                    continue;
                }
                if (showField.getDataType().equals("object") && showField.isArray() && showField.getSubFields() != null && showField.getSubFields().size() > 0 && !"check_result".equals(showField.getName()) && !"count_result".equals(showField.getName())) {
                    MetadataField newMetadataField = new MetadataField();
                    newMetadataField.setDataType("object");
                    newMetadataField.setDescription(showField.getDescription());
                    newMetadataField.setName(showField.getName());
                    newMetadataField.setTagDefinitions(showField.getTagDefinitions());
                    newMetadataField.setObjectData((Object)this.createComponent(showField, showField.getSubFields(), buildContext, apiMetadata));
                    newMetadataField.setExportTableFields(showField.getExportTableFields());
                    bodyShowFields.add(newMetadataField);
                    continue;
                }
                bodyShowFields.add(showField);
            }
        }
        List groupMetadataFields = this.groupTagInterpreter.analysisTagGroup(bodyShowFields, buildContext);
        AbstractComponent component = this.componentTagInterpreter.componentInterpreter(metadataField, groupMetadataFields, buildContext, apiMetadata);
        return component;
    }

    BuildContext createBuildContext(PageDefine pageDefine, QueryResultSet queryResultSet, ExecuteContext executeContext) {
        BuildContext buildContext = new BuildContext();
        buildContext.setPageDefine(pageDefine);
        buildContext.setQueryResultSet(queryResultSet);
        buildContext.setExecuteContext(executeContext);
        buildContext.setIsOrder(Boolean.valueOf(true));
        return buildContext;
    }

    protected void BuildActions(ExecuteContext executeContext, T pageDefine, DynamicForm dynamicForm) {
        dynamicForm.setActions(pageDefine.getSubmitActions());
    }

    private void filterEditRules(ExecuteContext executeContext, List<Map<String, Object>> rules) {
        if (executeContext.getRelationTag() != null && CollectionUtils.isNotEmpty(rules) && (!"performer".equals(executeContext.getRelationTag().getIdentity()) || executeContext.isShared())) {
            ListIterator<Map<String, Object>> iterator = rules.listIterator();
            while (iterator.hasNext()) {
                Map rule = (Map)iterator.next();
                if (!rule.containsKey("scope") || !Objects.equals("EDIT", rule.get("scope"))) continue;
                iterator.remove();
            }
        }
    }

    private void addTagRules(String path, List<MetadataField> showFields, List<Map<String, Object>> rules) {
        for (MetadataField showField : showFields) {
            String pathName = "";
            pathName = StringUtils.isBlank((String)path) ? showField.getName() : path + "." + showField.getName();
            if ("object".equals(showField.getDataType())) {
                this.addTagRules(pathName, showField.getSubFields(), rules);
                continue;
            }
            if (!CollectionUtils.isNotEmpty((Collection)showField.getTagDefinitions()) || !showField.isCanEdit()) continue;
            for (TagDefinition tagDefinition : showField.getTagDefinitions()) {
                if (tagDefinition.getRuleDefinition() == null || !CollectionUtils.isNotEmpty((Collection)tagDefinition.getRuleDefinition().getRules())) continue;
                for (JSONObject rule : tagDefinition.getRuleDefinition().getRules()) {
                    rule.put((Object)"path", (Object)path);
                    rules.add((Map<String, Object>)rule);
                }
            }
        }
    }

    public QueryResultSet BuildDataSource(ExecuteContext executeContext, PageDefine pageDefine) {
        return null;
    }

    protected void BuildLayout(ExecuteContext executeContext, QueryResultSet queryResultSet, T pageDefine, DynamicForm dynamicForm) {
        dynamicForm.setExecuteContext(executeContext);
    }

    private void mockPageData(List<MetadataField> fields, Map pageData, String dataSourceName) {
        List data = null;
        for (MetadataField metadataField : fields) {
            if (!"object".equals(metadataField.getDataType()) || !CollectionUtils.isNotEmpty((Collection)metadataField.getSubFields())) continue;
            if (metadataField.isArray()) {
                data = this.builderData(metadataField);
                pageData.put(dataSourceName, data);
                break;
            }
            pageData.put(dataSourceName, new HashMap());
            break;
        }
    }

    private List builderData(MetadataField subFields) {
        ArrayList data = new ArrayList();
        Set keys = subFields.getSubFields().stream().map(MetadataField::getName).collect(Collectors.toSet());
        if (keys.isEmpty()) {
            return data;
        }
        int indexMax = 2;
        if (subFields.isArray()) {
            indexMax = 11;
        }
        for (int index = 1; index < indexMax; ++index) {
            HashMap<String, Object> pageDataMap = new HashMap<String, Object>();
            for (String key : keys) {
                Optional<String> dataType = subFields.getSubFields().stream().filter(field -> key.equals(field.getName())).map(MetadataField::getDataType).findAny();
                Optional<String> fieldName = subFields.getSubFields().stream().filter(field -> key.equals(field.getName())).map(MetadataField::getDescription).findAny();
                if (!dataType.isPresent()) continue;
                String type = dataType.get();
                if ("number".equals(type) || "numeric".equals(type)) {
                    pageDataMap.put(key, index);
                    continue;
                }
                if ("boolean".equals(type)) {
                    if (index / 2 == 1) {
                        pageDataMap.put(key, true);
                        continue;
                    }
                    pageDataMap.put(key, false);
                    continue;
                }
                if ("date".equals(type)) {
                    pageDataMap.put(key, LocalDateTime.now());
                    continue;
                }
                if ("datetime".equals(type)) {
                    pageDataMap.put(key, LocalDateTime.now());
                    continue;
                }
                if ("array".equals(type)) {
                    pageDataMap.put(key, new Object[0]);
                    continue;
                }
                if ("object".equals(type)) {
                    pageDataMap.put(key, new HashMap());
                    continue;
                }
                String name = key;
                if (fieldName.isPresent()) {
                    name = fieldName.get();
                }
                pageDataMap.put(key, name + index);
            }
            data.add(pageDataMap);
        }
        return data;
    }
}

