/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.service.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.uibot.activity.DesignerTaskPageAnalyzer;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.activity.domain.TmQueryAction;
import com.digiwin.athena.uibot.builder.PageBuilder;
import com.digiwin.athena.uibot.constant.ErrorCodeEnum;
import com.digiwin.athena.uibot.dao.UserDefinedMongoMapper;
import com.digiwin.athena.uibot.designering.service.DesignerTaskPageService;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.UserDesignerCenterDTO;
import com.digiwin.athena.uibot.template.TemplateService;
import com.digiwin.athena.uibot.util.ExceptionMessageUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DesignerTaskPageServiceImpl
implements DesignerTaskPageService,
InitializingBean {
    @Autowired
    private List<TemplateService> templateList;
    private final Map<String, TemplateService> templateContainer = new HashMap<String, TemplateService>();
    @Autowired
    private List<PageBuilder> pageBuilders;
    private final Map<String, PageBuilder> builderContainer = new HashMap<String, PageBuilder>();
    @Autowired
    private DesignerTaskPageAnalyzer designerTaskPageAnalyzer;
    @Autowired
    UserDefinedMongoMapper userDefinedMongoMapper;
    @Autowired
    private ExceptionMessageUtils exceptionMessageUtils;

    public void afterPropertiesSet() throws Exception {
        if (this.templateList != null) {
            for (TemplateService template : this.templateList) {
                if (this.templateContainer.containsKey(template.supportKey())) {
                    throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684\u6a21\u677f\uff0c\u8bf7\u91cd\u4fee\u6539\u4ee3\u7801\uff1a" + template.supportKey());
                }
                this.templateContainer.put(template.supportKey(), template);
            }
        }
        if (this.pageBuilders != null) {
            for (PageBuilder pageBuilder : this.pageBuilders) {
                if (this.builderContainer.containsKey(pageBuilder.supportKey())) {
                    throw new IllegalStateException("\u5b58\u5728\u91cd\u590d\u7684builder\uff0c\u8bf7\u91cd\u4fee\u6539\u4ee3\u7801\uff1a" + pageBuilder.supportKey());
                }
                this.builderContainer.put(pageBuilder.supportKey(), pageBuilder);
            }
        }
    }

    @Override
    public DynamicForm createNewActionsPage(ExecuteContext executeContext, Map<String, Object> dataSourcesObj) {
        TemplateService templateService;
        TmQueryAction tmQueryAction = (TmQueryAction)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)dataSourcesObj.values().iterator().next()), TmQueryAction.class);
        HashMap<String, TmQueryAction> dataSources = new HashMap<String, TmQueryAction>();
        if (dataSourcesObj.keySet().iterator().hasNext()) {
            dataSources.put(dataSourcesObj.keySet().iterator().next(), tmQueryAction);
        } else {
            dataSources.put(tmQueryAction.getName(), tmQueryAction);
        }
        List<TaskPageDefine> taskPageDefines = this.designerTaskPageAnalyzer.newPageAnalysis(executeContext, dataSources);
        if (CollectionUtils.isNotEmpty(taskPageDefines) && (templateService = this.getTemplate(executeContext)) != null) {
            DynamicForm page = templateService.createTaskPage(executeContext, (PageDefine)taskPageDefines.get(0), taskPageDefines);
            page.setActions(null);
            page.setRules(null);
            return page;
        }
        return new DynamicForm();
    }

    private TemplateService getTemplate(ExecuteContext executeContext) {
        String templateName = StringUtils.lowerCase((String)(executeContext.getClientAgent() + "-designer-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + executeContext.getRelationTag().getIdentity()));
        if (this.templateContainer.containsKey(templateName)) {
            return this.templateContainer.get(templateName);
        }
        templateName = StringUtils.lowerCase((String)(executeContext.getClientAgent() + "-designer-" + executeContext.getPattern() + "-" + executeContext.getCategory() + "-" + executeContext.getRelationTag().getIdentity()));
        if (this.templateContainer.containsKey(templateName)) {
            return this.templateContainer.get(templateName);
        }
        templateName = StringUtils.lowerCase((String)(executeContext.getClientAgent() + "-designer-" + executeContext.getPattern() + "-" + executeContext.getRelationTag().getIdentity()));
        if (this.templateContainer.containsKey(templateName)) {
            return this.templateContainer.get(templateName);
        }
        templateName = StringUtils.lowerCase((String)"webplatform-designer-business-process-performer");
        if (this.templateContainer.containsKey(templateName)) {
            return this.templateContainer.get(templateName);
        }
        return null;
    }

    @Override
    public void save(AuthoredUser user, JSONObject fieldJson) {
        if (fieldJson != null) {
            UserDesignerCenterDTO userDesigner = new UserDesignerCenterDTO();
            if (fieldJson.containsKey((Object)"pageCode") && fieldJson.get("pageCode") != null) {
                userDesigner.setPageCode(fieldJson.getString("pageCode"));
            }
            if (fieldJson.containsKey((Object)"tmActivityId") && fieldJson.get("tmActivityId") != null) {
                userDesigner.setTmActivityId(fieldJson.getString("tmActivityId"));
            }
            if (fieldJson.containsKey((Object)"tmProjectId") && fieldJson.get("tmProjectId") != null && StringUtils.isNotEmpty((CharSequence)fieldJson.getString("tmProjectId"))) {
                userDesigner.setTmProjectId(fieldJson.getString("tmProjectId"));
            } else {
                userDesigner.setTmProjectId("__uibot__designer__");
            }
            if (fieldJson.containsKey((Object)"version") && fieldJson.get("version") != null && StringUtils.isNotEmpty((CharSequence)fieldJson.getString("version"))) {
                userDesigner.setVersion(fieldJson.getString("version"));
            } else {
                userDesigner.setVersion("tenant_version");
            }
            if (!fieldJson.containsKey((Object)"dynamicForm") || fieldJson.get("dynamicForm") == null) {
                return;
            }
            JSONObject dynamicFormObj = JSONObject.fromObject((Object)fieldJson.get("dynamicForm"));
            userDesigner.setDynamicForm(dynamicFormObj);
            userDesigner.setUserId(user.getUserId());
            userDesigner.setTenantId(user.getTenantId());
            this.userDefinedMongoMapper.save(userDesigner);
        }
    }

    @Override
    public void release(ExecuteContext executeContext, String tenantId, String version) {
        UserDesignerCenterDTO userDesigner = new UserDesignerCenterDTO();
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        userDesigner.setTenantId(tenantId);
        if (StringUtils.isEmpty((CharSequence)tenantId)) {
            userDesigner.setTenantId(authoredUser.getTenantId());
        }
        userDesigner.setVersion(version);
        if (StringUtils.isEmpty((CharSequence)version)) {
            userDesigner.setVersion("tenant_version");
        }
        userDesigner.setPageCode(executeContext.getPageCode());
        userDesigner.setTmActivityId(executeContext.getTmActivityId());
        userDesigner.setTmProjectId("__uibot__designer__");
        UserDesignerCenterDTO getUserDesinger = this.userDefinedMongoMapper.getDynamicForm(userDesigner);
        if (getUserDesinger == null || getUserDesinger.getDynamicForm() == null) {
            String message = this.exceptionMessageUtils.getMessageWithDefaultLocale("exception.task.not.save");
            throw BusinessException.create((String)ErrorCodeEnum.TASK_NOT_SAVE.getErrCode(), (String)message);
        }
        getUserDesinger.setIsRelease(true);
        getUserDesinger.setReleaseDynamicForm(getUserDesinger.getDynamicForm());
        if ("tenant_version".equals(userDesigner.getVersion())) {
            this.userDefinedMongoMapper.releaseTenantVersion(getUserDesinger);
        } else {
            this.userDefinedMongoMapper.releaseStandardVersionToTenant(getUserDesinger);
        }
    }
}

