/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.designering.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.TypeReference;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.NamingCase;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.uibot.constant.TagConstant;
import com.digiwin.athena.uibot.dao.WordTaskTagDao;
import com.digiwin.athena.uibot.designering.service.DesignerViewTagService;
import com.digiwin.athena.uibot.designering.service.convert.WordConvert;
import com.digiwin.athena.uibot.domain.word.WordTaskTag;
import com.digiwin.athena.uibot.param.req.WordRequestV2;
import com.digiwin.athena.uibot.param.resp.WordOtherResponse;
import com.digiwin.athena.uibot.support.thememap.domain.ThemeMapTag;
import com.digiwin.athena.uibot.util.TagUtil;
import com.digiwin.athena.uibot.util.UiBotUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DesignerViewTagServiceImpl
implements DesignerViewTagService {
    private static final Logger log = LoggerFactory.getLogger(DesignerViewTagServiceImpl.class);
    @Resource
    private WordTaskTagDao wordTaskTagDao;

    @Override
    public void markRecommendTag(WordRequestV2 wordRequest, List<WordOtherResponse> wordOtherResponseList) {
        if (CollectionUtils.isEmpty((Collection)wordRequest.getFields()) || CollectionUtils.isEmpty(wordOtherResponseList)) {
            return;
        }
        long start = System.currentTimeMillis();
        List<WordTaskTag> taskTagList = this.getWordAllTagList(wordRequest);
        if (CollectionUtils.isEmpty(taskTagList)) {
            log.info("=== No history tags, markRecommendTag finish");
            return;
        }
        Map<String, List<ThemeMapTag>> wordTagsHistoryMap = this.groupByWord(wordRequest, taskTagList);
        Map<String, WordOtherResponse> wordOtherMap = this.groupByWord(wordOtherResponseList);
        this.markRecommendTagInner(wordTagsHistoryMap, wordOtherMap);
        log.info("=== markRecommendTag cost: {} ms", (Object)(System.currentTimeMillis() - start));
    }

    private Map<String, List<ThemeMapTag>> groupByWord(WordRequestV2 wordRequest, List<WordTaskTag> taskTagList) {
        List fieldList = wordRequest.getFields();
        HashMap<String, List<ThemeMapTag>> wordTagsHistoryMap = new HashMap<String, List<ThemeMapTag>>();
        taskTagList.stream().filter(new TagPredicate(fieldList)).collect(Collectors.groupingBy(WordTaskTag::getWordCode)).forEach((word, wordTagList) -> {
            wordTagsHistoryMap.putIfAbsent((String)word, Lists.newArrayList());
            wordTagList.stream().collect(Collectors.groupingBy(WordTaskTag::getActivityId)).forEach((activityId, activityTagList) -> {
                List<ThemeMapTag> wordTagListInner = WordConvert.convertTaskTag(activityTagList);
                ThemeMapTag componentTag = TagUtil.getComponentTagOrNull(wordTagListInner);
                ((List)wordTagsHistoryMap.get(word)).add(componentTag);
            });
        });
        return wordTagsHistoryMap;
    }

    private Map<String, WordOtherResponse> groupByWord(List<WordOtherResponse> wordOtherResponseList) {
        return wordOtherResponseList.stream().collect(Collectors.toMap(WordOtherResponse::getWord, Function.identity(), (first, second) -> second));
    }

    private void markRecommendTagInner(Map<String, List<ThemeMapTag>> wordTagsHistoryMap, Map<String, WordOtherResponse> wordOtherMap) {
        for (Map.Entry<String, List<ThemeMapTag>> wordTagEntry : wordTagsHistoryMap.entrySet()) {
            String word = wordTagEntry.getKey();
            List<ThemeMapTag> tagList = wordTagEntry.getValue();
            if (CollectionUtils.isEmpty(tagList)) continue;
            int totalTagCount = tagList.size();
            long nullTagCount = tagList.stream().filter(ele -> "null".equals(ele.getCode())).count();
            double div = NumberUtil.div((float)nullTagCount, (float)totalTagCount);
            if (div >= 0.5) continue;
            Map<String, List<ThemeMapTag>> tagCodeMap = tagList.stream().filter(ele -> StringUtils.isNotEmpty((CharSequence)ele.getCode())).collect(Collectors.groupingBy(ThemeMapTag::getCode));
            List maxTagList = (List)tagCodeMap.entrySet().stream().max(Comparator.comparingInt(v -> ((List)v.getValue()).size())).orElse(MapUtil.entry((Object)"null", (Object)Lists.newArrayList((Object[])new ThemeMapTag[]{ThemeMapTag.empty()}))).getValue();
            ThemeMapTag lastTag = (ThemeMapTag)CollUtil.getLast((Collection)maxTagList);
            WordOtherResponse wordOther = wordOtherMap.get(word);
            this.markTagFinal(lastTag, wordOther);
        }
    }

    private void markTagFinal(ThemeMapTag lastTag, WordOtherResponse wordOther) {
        if (TagConstant.ComponentTagCodeEnum.isContain((String)lastTag.getCode()) && wordOther != null) {
            this.setStandardExtendedInfo(lastTag);
            this.resetBeforeRecommend(lastTag);
            wordOther.setTagList((List)Lists.newArrayList((Object[])new ThemeMapTag[]{lastTag}));
        }
    }

    private void resetBeforeRecommend(ThemeMapTag lastTag) {
        lastTag.setId(null);
        lastTag.setCode(lastTag.getCode());
        lastTag.setCategory("DISPLAY");
    }

    private void setStandardExtendedInfo(ThemeMapTag tag) {
        String tagCode = tag.getCode();
        if (StringUtils.isEmpty((CharSequence)tagCode) || "null".equals(tagCode)) {
            return;
        }
        String fileName = NamingCase.toCamelCase((CharSequence)tagCode);
        String fileRelativePath = StrUtil.format((CharSequence)"tag/extendedinfo/{}.json", (Object[])new Object[]{fileName});
        Map extendedInfo = (Map)UiBotUtils.toBean((String)fileRelativePath, (TypeReference)new TypeReference<Map<String, Object>>(){});
        tag.setExtendedInfo(extendedInfo);
    }

    public List<WordTaskTag> getWordAllTagList(WordRequestV2 wordRequest) {
        if (CollectionUtils.isEmpty((Collection)wordRequest.getCategories())) {
            return Lists.newArrayList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(WordTaskTag.class).in(WordTaskTag::getWordCode, (Collection)wordRequest.getFields())).in(WordTaskTag::getCategoryCode, (Collection)wordRequest.getCategories());
        Map fieldMap = wordRequest.getFieldMap();
        List wordTaskTags = this.wordTaskTagDao.list((Wrapper)queryWrapper);
        return wordTaskTags.stream().filter(taskTag -> {
            String wordCode = taskTag.getWordCode();
            String wordDataType = taskTag.getWordDataType();
            return fieldMap.getOrDefault(wordCode, "null").equals(wordDataType);
        }).collect(Collectors.toList());
    }

    public static class MetadataTagKeyFunction
    implements Function<WordTaskTag, String> {
        @Override
        public String apply(WordTaskTag wordTaskTag) {
            return wordTaskTag.getWordCode();
        }
    }

    public static class TagPredicate
    implements Predicate<WordTaskTag> {
        private final List<String> fieldList;

        public TagPredicate(List<String> fieldList) {
            this.fieldList = fieldList;
        }

        @Override
        public boolean test(WordTaskTag taskTag) {
            return this.fieldList.contains(taskTag.getWordCode());
        }
    }
}

