/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.template;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.SubmitAction;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.component.ApprovalDescriptionComponentImpl;
import com.digiwin.athena.uibot.component.domain.AbstractComponent;
import com.digiwin.athena.uibot.component.domain.ApprovalDescriptionComponent;
import com.digiwin.athena.uibot.component.domain.CommonComponent;
import com.digiwin.athena.uibot.domain.BuildContext;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.domain.ShowMetadata;
import com.digiwin.athena.uibot.metadata.domain.MetadataField;
import com.digiwin.athena.uibot.support.atmc.domain.BacklogData;
import com.digiwin.athena.uibot.support.atmc.domain.TaskWithBacklogData;
import com.digiwin.athena.uibot.template.DesignerPageTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class DesignerBusinessApprovalPerformerImpl
extends DesignerPageTemplate {
    @Autowired
    private MessageUtils messageUtils;
    private static final String ACTIVITY_DESCRIPTION_SCHEMA_NAME = "uiBot__APPROVAL_DESCRIPTION";

    @Override
    public String supportKey() {
        return "webplatform-designer-business-approval-performer";
    }

    @Override
    protected QueryResultSet BuildDataSource(ExecuteContext executeContext, TaskPageDefine pageDefine, DynamicForm dynamicForm) {
        QueryResultSet queryResultSet = super.BuildDataSource(executeContext, pageDefine, dynamicForm);
        Map pageData = dynamicForm.getPageData();
        if (queryResultSet.getMainQueryResult() != null && queryResultSet.getMainQueryResult().size() > 0) {
            pageData.put(ACTIVITY_DESCRIPTION_SCHEMA_NAME, queryResultSet.getMainQueryResult().getData().get(0));
        }
        pageData.put("uiBot__approvalMessage", "");
        return queryResultSet;
    }

    @Override
    protected void createHeader(ExecuteContext executeContext, TaskPageDefine pageDefine, List<AbstractComponent> layout) {
        layout.add((AbstractComponent)this.createHeadArea(executeContext));
        ShowMetadata showMetadata = super.createShowMetadata(executeContext, (PageDefine)pageDefine);
        if (showMetadata != null) {
            this.addFiledToMetadata(showMetadata, executeContext);
            ApprovalDescriptionComponent object = this.createApprovalDescriptionComponent(executeContext, pageDefine, showMetadata);
            layout.add((AbstractComponent)object);
        }
        AbstractComponent signOffProgressLinkComponent = this.createSignOffProgress();
        layout.add(signOffProgressLinkComponent);
    }

    @Override
    protected void BuildActions(ExecuteContext executeContext, TaskPageDefine pageDefine, DynamicForm dynamicForm) {
        List actions = pageDefine.getSubmitActions();
        if (CollectionUtils.isNotEmpty((Collection)actions)) {
            for (SubmitAction action : actions) {
                this.setExtendedFieldsForAction(executeContext, action);
            }
        }
        dynamicForm.setActions(actions);
    }

    private void addFiledToMetadata(ShowMetadata showMetadata, ExecuteContext executeContext) {
        if ("purchaseApproval".equals(executeContext.getRelationTag().getActivityId())) {
            MetadataField metadataField = new MetadataField();
            metadataField.setName("uiBot__activity");
            metadataField.setDataType("object");
            ArrayList<MetadataField> subMetadataField = new ArrayList<MetadataField>();
            MetadataField metadataFieldTaskSourceIds = new MetadataField();
            metadataFieldTaskSourceIds.setName("taskSourceIds");
            metadataFieldTaskSourceIds.setDescription(this.messageUtils.getMessage("uibot.template.approval.taskSourceIds"));
            subMetadataField.add(metadataFieldTaskSourceIds);
            MetadataField metadataFieldBpmSignReason = new MetadataField();
            metadataFieldBpmSignReason.setName("bpmSignReason");
            metadataFieldBpmSignReason.setDescription(this.messageUtils.getMessage("uibot.template.approval.bpmSignReason"));
            subMetadataField.add(metadataFieldBpmSignReason);
            metadataField.setSubFields(subMetadataField);
            showMetadata.getShowFields().add(metadataField);
        }
    }

    private AbstractComponent createSignOffProgress() {
        CommonComponent commonComponent = new CommonComponent();
        commonComponent.setId(UUID.randomUUID().toString());
        commonComponent.setType("SIGN_OFF_PROGRESS_LINK");
        commonComponent.setSchema("uiBot__activity");
        return commonComponent;
    }

    private ApprovalDescriptionComponent createApprovalDescriptionComponent(ExecuteContext executeContext, TaskPageDefine pageDefine, ShowMetadata showMetadata) {
        ApprovalDescriptionComponent approvalDescriptionComponent = new ApprovalDescriptionComponent();
        if (CollectionUtils.isNotEmpty((Collection)showMetadata.getShowFields())) {
            approvalDescriptionComponent.setId(UUID.randomUUID().toString());
            approvalDescriptionComponent.setType("APPROVAL_DESCRIPTION");
            approvalDescriptionComponent.setSchema(((MetadataField)showMetadata.getShowFields().get(0)).getName());
            BuildContext buildContext = new BuildContext();
            buildContext.setExecuteContext(executeContext);
            buildContext.setPageDefine((PageDefine)pageDefine);
            ArrayList group = new ArrayList();
            ApprovalDescriptionComponentImpl.createGroupByShowMetadata(group, null, (List)showMetadata.getShowFields(), (BuildContext)buildContext);
            approvalDescriptionComponent.setGroup(group);
        }
        approvalDescriptionComponent.setSchema(ACTIVITY_DESCRIPTION_SCHEMA_NAME);
        return approvalDescriptionComponent;
    }

    private void setExtendedFieldsForAction(ExecuteContext executeContext, SubmitAction action) {
        if ("WF".equals(action.getCategory()) && action.getServiceId() != null && ("reexecute".equals(action.getServiceId().getName()) || "reapprove".equals(action.getServiceId().getName()))) {
            TaskWithBacklogData taskData = executeContext.getTaskWithBacklogData();
            HashMap extend = new HashMap();
            action.setExtendedFields(extend);
            HashMap<String, Object> reExecuteData = new HashMap<String, Object>();
            extend.put("reexecuteData", reExecuteData);
            if (taskData != null) {
                Map workitem;
                List workitemList;
                reExecuteData.put("processSerialNumber", taskData.getProcessSerialNumber());
                if (CollectionUtils.isNotEmpty((Collection)taskData.getBacklog()) && CollectionUtils.isNotEmpty((Collection)(workitemList = ((BacklogData)taskData.getBacklog().get(0)).getWorkitemList())) && (workitem = (Map)workitemList.get(0)).containsKey("workitemId")) {
                    reExecuteData.put("workitemId", workitem.get("workitemId"));
                }
            }
            reExecuteData.put("tmActivityIds", action.getStartApproveActivity());
            reExecuteData.put("locale", LocaleContextHolder.getLocale());
            if ("reexecute".equals(action.getServiceId().getName()) && action.getParas() != null && !CollectionUtils.isEmpty((Collection)action.getStartApproveActivity())) {
                Map para = action.getParas();
                para.put("taskId", action.getStartApproveActivity().get(0));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)action.getAttachActions())) {
            for (SubmitAction attachAction : action.getAttachActions()) {
                this.setExtendedFieldsForAction(executeContext, attachAction);
            }
        }
    }
}

