/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.template;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.appcore.util.TimeUtils;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.OperationDTO;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.SubmitAction;
import com.digiwin.athena.uibot.component.domain.AbstractComponent;
import com.digiwin.athena.uibot.component.domain.CommonComponent;
import com.digiwin.athena.uibot.component.domain.ContainExplicitFormComponent;
import com.digiwin.athena.uibot.component.domain.FormComponent;
import com.digiwin.athena.uibot.component.domain.SelectComponent;
import com.digiwin.athena.uibot.constant.ErrorCodeEnum;
import com.digiwin.athena.uibot.domain.ActionParameterMapping;
import com.digiwin.athena.uibot.domain.BuildContext;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.domain.ShowMetadata;
import com.digiwin.athena.uibot.interpreter.FormInterpreter;
import com.digiwin.athena.uibot.metadata.MetadataService;
import com.digiwin.athena.uibot.metadata.domain.ApiMetadata;
import com.digiwin.athena.uibot.metadata.domain.MetadataField;
import com.digiwin.athena.uibot.service.dealWithService.OperationService;
import com.digiwin.athena.uibot.support.adp.AthenaDesignerService;
import com.digiwin.athena.uibot.support.thememap.domain.TaggingData;
import com.digiwin.athena.uibot.tag.interpreter.EocSelectInterpreter;
import com.digiwin.athena.uibot.tag.interpreter.GroupTagInterpreter;
import com.digiwin.athena.uibot.tag.interpreter.OrderTagInterpreter;
import com.digiwin.athena.uibot.tag.interpreter.UnEditableTagUtils;
import com.digiwin.athena.uibot.tag.service.DefaultTagUtils;
import com.digiwin.athena.uibot.tag.service.SignTagService;
import com.digiwin.athena.uibot.tag.service.TagDefinitionService;
import com.digiwin.athena.uibot.tag.service.TagMergeService;
import com.digiwin.athena.uibot.tag.service.TagService;
import com.digiwin.athena.uibot.template.GeneralPageTemplate;
import com.digiwin.athena.uibot.util.ApiMetadataUtil;
import com.digiwin.athena.uibot.util.PropertyPlaceholderUtil;
import com.digiwin.athena.uibot.util.TagUtil;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.PropertyPlaceholderHelper;

@Component(value="designerConditionPageTemplate")
public class DesignerConditionPageTemplate
extends GeneralPageTemplate {
    private static final Logger log = LoggerFactory.getLogger(DesignerConditionPageTemplate.class);
    private static final String SUPPORT_KEY = "webplatform-designer-statement-general-page-template";
    private static final String RESID = "STATEMENT__resid";
    private static final String SCHEMA_KEY = "UIBOT__schema";
    private static final DateTimePlaceHolderResolver dateTimePlaceHolderResolver = new DateTimePlaceHolderResolver();
    @Autowired
    AthenaDesignerService athenaDesignerService;
    @Autowired
    private TagService tagService;
    @Autowired
    private TagDefinitionService tagDefService;
    @Autowired
    private SignTagService signTagService;
    @Autowired
    private OrderTagInterpreter orderTagInterpreter;
    @Autowired
    private OperationService operationService;
    @Autowired
    private GroupTagInterpreter groupTagInterpreter;
    @Autowired
    private TagMergeService tagMergeService;
    @Autowired
    private FormInterpreter formInterpreter;
    @Autowired
    private JsonConfig jsonConfig;

    public String supportKey() {
        return SUPPORT_KEY;
    }

    protected QueryResultSet BuildDataSource(ExecuteContext executeContext, PageDefine pageDefine, DynamicForm dynamicForm) {
        return null;
    }

    protected void BuildLayout(ExecuteContext executeContext, QueryResultSet queryResultSet, PageDefine pageDefine, List pageDefines, DynamicForm dynamicForm) {
        this.createDynamicForm(executeContext, pageDefine, dynamicForm);
        this.regularFormColumns(dynamicForm.getLayout());
        Map pageData = dynamicForm.getPageData();
        this.putExtendedFieldToPageData(pageData, pageDefine.getExtendedFields());
        pageData.put("UIBOT__activityName", pageDefine.getSubTitle());
    }

    private void putExtendedFieldToPageData(Map<String, Object> pageData, Map<String, Object> extendedFields) {
        if (MapUtils.isEmpty(extendedFields)) {
            return;
        }
        String locale = LocaleContextHolder.getLocale().toString();
        String targetResid = "STATEMENT__resid_" + locale;
        String finalResid = RESID;
        Set<Map.Entry<String, Object>> entries = extendedFields.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (!StringUtils.equalsIgnoreCase((String)entry.getKey(), (String)targetResid)) continue;
            finalResid = entry.getKey();
            break;
        }
        entries = extendedFields.entrySet();
        for (Map.Entry<String, Object> entry : entries) {
            if (StringUtils.startsWith((String)entry.getKey(), (String)RESID)) {
                if (!StringUtils.equalsIgnoreCase((String)entry.getKey(), (String)finalResid)) continue;
                pageData.put(RESID, entry.getValue());
                continue;
            }
            pageData.put(entry.getKey(), entry.getValue());
        }
    }

    private void regularFormColumns(List layoutList) {
        if (CollectionUtils.isEmpty((Collection)layoutList)) {
            return;
        }
        for (Object layout : layoutList) {
            FormComponent formComponent = (FormComponent)layout;
            this.setFormComponentPlaceholder(formComponent);
        }
    }

    private void setFormComponentPlaceholder(FormComponent formComponent) {
        for (Object column : formComponent.getGroup()) {
            CommonComponent commonComponent;
            if (column instanceof FormComponent) {
                this.setFormComponentPlaceholder((FormComponent)column);
                continue;
            }
            if (column instanceof CommonComponent) {
                commonComponent = (CommonComponent)column;
                commonComponent.setPlaceholder(commonComponent.getHeaderName());
                commonComponent.setHeaderName(null);
                commonComponent.setTitle(null);
                continue;
            }
            if (column instanceof SelectComponent) {
                commonComponent = (SelectComponent)column;
                commonComponent.setPlaceholder(commonComponent.getHeaderName());
                commonComponent.setHeaderName(null);
                commonComponent.setTitle(null);
                continue;
            }
            if (!(column instanceof ContainExplicitFormComponent)) continue;
            ContainExplicitFormComponent containExplicitFormComponent = (ContainExplicitFormComponent)column;
            if (containExplicitFormComponent.getColumns() != null) {
                for (Object col : containExplicitFormComponent.getColumns()) {
                    if (!(col instanceof CommonComponent)) continue;
                    CommonComponent commonComponent2 = (CommonComponent)col;
                    commonComponent2.setPlaceholder(commonComponent2.getHeaderName());
                    commonComponent2.setHeaderName(null);
                    commonComponent2.setTitle(null);
                }
            }
            containExplicitFormComponent.setPlaceholder(containExplicitFormComponent.getHeaderName());
            containExplicitFormComponent.setHeaderName(null);
            containExplicitFormComponent.setTitle(null);
        }
    }

    private String getActionId(PageDefine mainQueryDTO) {
        return Optional.ofNullable(mainQueryDTO.getSubmitActions()).map(submitActions -> {
            if (CollectionUtils.isNotEmpty((Collection)submitActions)) {
                return ((SubmitAction)submitActions.get(0)).getActionId();
            }
            return "";
        }).orElse("");
    }

    private void createDynamicForm(ExecuteContext executeContext, PageDefine mainQueryDTO, DynamicForm dynamicForm) {
        String actionId = this.getActionId(mainQueryDTO);
        if (StringUtils.isBlank((String)actionId)) {
            return;
        }
        ApiMetadata apiMetadata = this.athenaDesignerService.getMetadata(executeContext.getLocale(), actionId);
        this.handleAttachActions(mainQueryDTO, executeContext);
        this.appendEocMetadataField(mainQueryDTO, apiMetadata);
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        TaggingData taggingData = this.getMetadataTags(mainQueryDTO, executeContext, actionId);
        this.signTagService.sinTagToMetadata(taggingData, apiMetadata);
        this.tagFieldCanEdit(apiMetadata.getRequestFields());
        ShowMetadata showMetadata = this.getRequestShowFields(apiMetadata);
        UnEditableTagUtils.analysisTag((List)showMetadata.getShowFields());
        this.orderTagInterpreter.analysisTag(showMetadata);
        this.operationService.addMetadataOperation(showMetadata, mainQueryDTO.getOperations(), apiMetadata);
        this.createConditionPage(executeContext, showMetadata, mainQueryDTO, dynamicForm, apiMetadata);
    }

    private void handleAttachActions(PageDefine mainQueryDTO, ExecuteContext executeContext) {
        List attachActions = ((SubmitAction)mainQueryDTO.getSubmitActions().get(0)).getAttachActions();
        if (CollectionUtils.isEmpty((Collection)attachActions)) {
            return;
        }
        for (SubmitAction attachAction : attachActions) {
            if (StringUtils.isBlank((String)attachAction.getActionId())) continue;
            if (null == attachAction.getExtendParas()) {
                attachAction.setExtendParas(new HashMap());
            }
            if (attachAction.getExtendParas().containsKey(SCHEMA_KEY)) continue;
            ApiMetadata apiMetadata = ((MetadataService)SpringUtil.getBean(MetadataService.class)).getMetadata(executeContext.getLocale(), attachAction.getActionId());
            String schema = ((MetadataField)apiMetadata.getRequestFields().get(0)).getName();
            attachAction.getExtendParas().put(SCHEMA_KEY, schema);
        }
    }

    private void appendEocMetadataField(PageDefine mainQueryDTO, ApiMetadata apiMetadata) {
        Optional<Map> optional = Optional.ofNullable(mainQueryDTO.getExtendedFields()).map(extendedFields -> (Map)extendedFields.get("UIBOT__appendEocFields"));
        if (!optional.isPresent()) {
            return;
        }
        Map appendEocFields = optional.get();
        if (MapUtils.isEmpty((Map)appendEocFields)) {
            return;
        }
        Set entrySet = appendEocFields.entrySet();
        for (Map.Entry entry : entrySet) {
            if (StringUtils.isBlank((String)((String)entry.getKey())) || CollectionUtils.isEmpty((Collection)((Collection)entry.getValue()))) continue;
            for (MetadataField requestField : apiMetadata.getRequestFields()) {
                if (!"object".equals(requestField.getDataType()) || !requestField.getName().equals(entry.getKey())) continue;
                List<MetadataField> eocFields = this.createEocMetadataFields((List)entry.getValue());
                requestField.getSubFields().addAll(eocFields);
            }
        }
    }

    private List<MetadataField> createEocMetadataFields(List<Object> fieldObjects) {
        ArrayList<MetadataField> eocFields = new ArrayList<MetadataField>(fieldObjects.size());
        for (Object fieldObject : fieldObjects) {
            MetadataField metadataField;
            block3: {
                metadataField = new MetadataField();
                try {
                    BeanUtils.copyProperties((Object)metadataField, (Object)fieldObject);
                    String description = this.parseDescriptionByLang(fieldObject);
                    if (!StringUtils.isNotBlank((String)description)) break block3;
                    metadataField.setDescription(description);
                }
                catch (Exception ex) {
                    log.error("[ConditionPageTemplate] create eoc field throw exception: ", (Throwable)ex);
                    continue;
                }
            }
            eocFields.add(metadataField);
        }
        return eocFields;
    }

    private String parseDescriptionByLang(Object fieldObj) {
        JSONObject descJsonObj;
        JSONObject langJsonObj;
        if (null == fieldObj) {
            return null;
        }
        String locale = LocaleContextHolder.getLocale().toString();
        JSONObject fieldJsonObj = JSONObject.fromObject((Object)fieldObj, (JsonConfig)this.jsonConfig);
        if (null != fieldJsonObj && fieldJsonObj.containsKey((Object)"language") && null != (langJsonObj = fieldJsonObj.getJSONObject("language")) && langJsonObj.containsKey((Object)"description") && null != (descJsonObj = langJsonObj.getJSONObject("description")) && !descJsonObj.isEmpty() && descJsonObj.containsKey((Object)locale)) {
            return descJsonObj.getString(locale);
        }
        return null;
    }

    private void createConditionPage(ExecuteContext executeContext, ShowMetadata showMetadata, PageDefine pageDefine, DynamicForm dynamicForm, ApiMetadata apiMetadata) {
        if (executeContext.getRelationTag() != null && executeContext.getRelationTag().getIdentity() != null && executeContext.getRelationTag().getIdentity().equals("performer") && executeContext.isNotShared()) {
            this.tagMergeService.addTagRules("", showMetadata.getShowFields(), dynamicForm.getRules());
            this.cleanRule(dynamicForm, pageDefine);
        }
        BuildContext buildContext = this.createBuildContext(pageDefine, null, executeContext);
        ArrayList<Object> topLayout = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)showMetadata.getShowFields())) {
            for (MetadataField showField : showMetadata.getShowFields()) {
                AbstractComponent layout = this.createConditionPage(buildContext, showField, showField.getSubFields(), dynamicForm, apiMetadata);
                if (layout instanceof Collection) {
                    topLayout.addAll((Collection)layout);
                    continue;
                }
                if (layout instanceof FormComponent) {
                    FormComponent layoutForm = (FormComponent)layout;
                    if (!CollectionUtils.isNotEmpty((Collection)layoutForm.getGroup())) continue;
                    layoutForm.setDirection("COLUMN");
                    topLayout.add(layoutForm);
                    continue;
                }
                topLayout.add(layout);
            }
        }
        dynamicForm.setLayout(topLayout);
        this.setActionOperations(executeContext, pageDefine);
        dynamicForm.setPageData(this.initConditionPageData(pageDefine, apiMetadata.getRequestFields()));
    }

    private Map<String, Object> initConditionPageData(PageDefine pageDefine, List<MetadataField> showMetadataList) {
        Map<String, Object> pageData = this.initConditionPageData(showMetadataList, 1);
        if (MapUtils.isNotEmpty(pageData)) {
            for (Map.Entry<String, Object> entry : pageData.entrySet()) {
                pageData.put(SCHEMA_KEY, entry.getKey());
            }
        }
        this.parseConstantSubmitActionParams(pageDefine.getSubmitActions(), pageData);
        return pageData;
    }

    private void parseConstantSubmitActionParams(List<SubmitAction> submitActions, Map<String, Object> pageData) {
        if (CollectionUtils.isEmpty(submitActions) || MapUtils.isEmpty(pageData)) {
            return;
        }
        List actionParamList = submitActions.get(0).getActionParams();
        if (CollectionUtils.isEmpty((Collection)actionParamList)) {
            return;
        }
        String schema = String.valueOf(pageData.get(SCHEMA_KEY));
        Map dataSrcMap = (Map)((Object[])pageData.get(schema))[0];
        for (ActionParameterMapping actionParamMapping : actionParamList) {
            if (!"CONSTANT".equals(actionParamMapping.getType())) continue;
            String[] namePathList = actionParamMapping.getName().split("\\.");
            for (int idx = 1; idx < namePathList.length; ++idx) {
                this.parseConstantSubmitActionParams(dataSrcMap, namePathList, idx, actionParamMapping);
            }
        }
    }

    private void parseConstantSubmitActionParams(Map<String, Object> dataSrcMap, String[] namePathList, int idx, ActionParameterMapping actionParamMapping) {
        String name = namePathList[idx];
        if (idx < namePathList.length - 1) {
            HashMap<String, Object> valueMap = (HashMap<String, Object>)dataSrcMap.get(name);
            if (null == valueMap) {
                valueMap = new HashMap<String, Object>();
            }
            this.parseConstantSubmitActionParams(valueMap, namePathList, idx++, actionParamMapping);
        } else {
            String value = this.parseValueConfig(actionParamMapping.getValue());
            dataSrcMap.put(name, value);
        }
    }

    private String parseValueConfig(String value) {
        if (StringUtils.isBlank((String)value)) {
            return value;
        }
        String actualValue = PropertyPlaceholderUtil.HELPER.replacePlaceholders(value, (PropertyPlaceholderHelper.PlaceholderResolver)dateTimePlaceHolderResolver);
        return actualValue;
    }

    private Map<String, Object> initConditionPageData(List<MetadataField> showMetadataList, int level) {
        HashMap<String, Object> pageData = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(showMetadataList)) {
            return pageData;
        }
        for (MetadataField showField : showMetadataList) {
            Object[] objects;
            if (1 == level) {
                if (!showField.isArray()) continue;
                objects = new Object[1];
                if (showField.getDataType().equals("object")) {
                    objects[0] = this.initConditionPageData(showField.getSubFields(), ++level);
                    pageData.put(showField.getName(), objects);
                    continue;
                }
                objects[0] = DefaultTagUtils.genPrimitiveTypeDefaultValue((MetadataField)showField);
                pageData.put(showField.getName(), objects);
                continue;
            }
            if (showField.isArray()) {
                objects = new Object[]{};
                pageData.put(showField.getName(), objects);
                continue;
            }
            if (showField.getDataType().equals("object")) {
                pageData.put(showField.getName(), new HashMap());
                continue;
            }
            pageData.put(showField.getName(), DefaultTagUtils.genPrimitiveTypeDefaultValue((MetadataField)showField));
        }
        return pageData;
    }

    private void setActionOperations(ExecuteContext executeContext, PageDefine pageDefine) {
        List operations = pageDefine.getOperations();
        if (CollectionUtils.isNotEmpty((Collection)operations)) {
            for (OperationDTO operation : operations) {
                operation.setRelationTag(executeContext.getRelationTag());
                operation.setPageCode(executeContext.getPageCode());
            }
        }
    }

    private void cleanRule(DynamicForm page, PageDefine pageDefine) {
        ArrayList<Map> newRules = new ArrayList<Map>();
        List rules = page.getRules();
        if (CollectionUtils.isNotEmpty((Collection)rules)) {
            for (Map rule : rules) {
                String scope;
                if (rule == null) continue;
                String string = scope = !rule.containsKey("scope") || rule.get("scope") == null ? "" : rule.get("scope").toString();
                if ("EDIT".equals(scope) && CollectionUtils.isEmpty((Collection)pageDefine.getSubmitActions())) continue;
                newRules.add(rule);
            }
            page.setRules(newRules);
        }
    }

    private AbstractComponent createConditionPage(BuildContext buildContext, MetadataField headMetadataField, List<MetadataField> subFields, DynamicForm page, ApiMetadata apiMetadata) {
        ArrayList<MetadataField> bodyShowFields = new ArrayList<MetadataField>();
        if (TagUtil.renderObjectMetadataField((MetadataField)headMetadataField)) {
            bodyShowFields.add(headMetadataField);
        } else if (CollectionUtils.isNotEmpty(subFields)) {
            for (MetadataField showField : subFields) {
                if (TagUtil.renderObjectMetadataField((MetadataField)showField)) {
                    bodyShowFields.add(showField);
                    continue;
                }
                if (showField.getDataType().equals("object")) {
                    MetadataField newMetadataField = new MetadataField();
                    newMetadataField.setDataType("object");
                    newMetadataField.setDescription(showField.getDescription());
                    newMetadataField.setName(showField.getName());
                    newMetadataField.setTagDefinitions(showField.getTagDefinitions());
                    newMetadataField.setObjectData((Object)this.createConditionPage(buildContext, showField, showField.getSubFields(), page, apiMetadata));
                    newMetadataField.setExportTableFields(showField.getExportTableFields());
                    bodyShowFields.add(newMetadataField);
                    continue;
                }
                bodyShowFields.add(showField);
            }
        }
        List groupMetadataFields = this.groupTagInterpreter.analysisTagGroup(bodyShowFields, buildContext);
        EocSelectInterpreter.handleEocGroup((List)groupMetadataFields);
        AbstractComponent component = this.formInterpreter.createComponent(headMetadataField, groupMetadataFields, buildContext, apiMetadata);
        if (component instanceof FormComponent) {
            FormComponent formComponent = (FormComponent)component;
            formComponent.setAllFields(null);
        }
        return component;
    }

    private void tagFieldCanEdit(List<MetadataField> requestFields) {
        for (MetadataField metadataField : requestFields) {
            metadataField.setCanEdit(true);
            if (!"object".equals(metadataField.getDataType())) continue;
            this.tagFieldCanEdit(metadataField.getSubFields());
        }
    }

    private ShowMetadata getRequestShowFields(ApiMetadata masterMetadata) {
        ShowMetadata showMetadata = new ShowMetadata();
        if (masterMetadata == null) {
            return showMetadata;
        }
        showMetadata.setActionId(masterMetadata.getActionId());
        showMetadata.setServiceName(masterMetadata.getServiceName());
        List requestFields = masterMetadata.getRequestFields();
        showMetadata.setShowFields(new ArrayList());
        List<MetadataField> tagMetadata = this.showFields(requestFields);
        if (CollectionUtils.isNotEmpty(tagMetadata)) {
            showMetadata.getShowFields().addAll(tagMetadata);
        } else {
            showMetadata.getShowFields().addAll(requestFields);
        }
        return showMetadata;
    }

    private List<MetadataField> showFields(List<MetadataField> metadataFields) {
        ArrayList<MetadataField> showFields = new ArrayList<MetadataField>();
        for (MetadataField metadataField : metadataFields) {
            List<MetadataField> sonTagFields;
            if ("object".equals(metadataField.getDataType()) && (CollectionUtils.isNotEmpty(sonTagFields = this.showFields(metadataField.getSubFields())) || CollectionUtils.isNotEmpty((Collection)metadataField.getTagDefinitions()))) {
                MetadataField newMetadataField = this.createMetadataField(metadataField, sonTagFields);
                showFields.add(newMetadataField);
            }
            if (!CollectionUtils.isNotEmpty((Collection)metadataField.getTagDefinitions()) || "object".equals(metadataField.getDataType())) continue;
            showFields.add(metadataField);
        }
        return showFields;
    }

    private MetadataField createMetadataField(MetadataField metadataField, List<MetadataField> sonTagFields) {
        MetadataField newMetadataField = new MetadataField();
        newMetadataField.setDataType(metadataField.getDataType());
        newMetadataField.setDataKey(metadataField.getDataKey());
        newMetadataField.setRemark(metadataField.getRemark());
        newMetadataField.setDescription(metadataField.getDescription());
        newMetadataField.setRequired(metadataField.isRequired());
        newMetadataField.setName(metadataField.getName());
        newMetadataField.setArray(metadataField.isArray());
        newMetadataField.setCanEdit(metadataField.isCanEdit());
        newMetadataField.setTagDefinitions(metadataField.getTagDefinitions());
        newMetadataField.setFieldType(metadataField.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        return newMetadataField;
    }

    private TaggingData getMetadataTags(PageDefine mainQueryDTO, ExecuteContext executeContext, String actionId) {
        TaggingData taggingData = this.tagService.getThemeMapTag(mainQueryDTO.getQueryTagSuffix(), executeContext.getRelationTag(), actionId, "TAG", executeContext);
        if (taggingData != null) {
            this.tagDefService.processTagDefinitions(taggingData, executeContext);
        }
        return taggingData;
    }

    private BuildContext createBuildContext(PageDefine pageDefine, QueryResultSet queryResultSet, ExecuteContext executeContext) {
        BuildContext buildContext = new BuildContext();
        buildContext.setPageDefine(pageDefine);
        buildContext.setQueryResultSet(queryResultSet);
        buildContext.setExecuteContext(executeContext);
        return buildContext;
    }

    private static class DateTimePlaceHolderResolver
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private DateTimePlaceHolderResolver() {
        }

        public String resolvePlaceholder(String placeholderName) {
            if (!StringUtils.startsWithIgnoreCase((String)placeholderName, (String)"DATE")) {
                return null;
            }
            String[] arr = StringUtils.split((String)placeholderName, (String)";");
            String[] strArr = StringUtils.split((String)arr[0], (String)":");
            LocalDateTime dateTime = null;
            if (1 == strArr.length) {
                dateTime = LocalDateTime.now();
            } else if (3 <= strArr.length) {
                dateTime = this.parseDateTime(placeholderName, strArr);
            } else {
                throw BusinessException.create((String)ErrorCodeEnum.REPORT_WORK_DEF_INVALID_DATE_EXPRESSION.getErrCode(), (String)("invalid date expression: {}" + placeholderName));
            }
            String pattern = 1 < arr.length ? arr[1] : "yyyy-MM-dd";
            return TimeUtils.format((LocalDateTime)dateTime, (String)pattern);
        }

        private LocalDateTime parseDateTime(String placeholderName, String[] strArr) {
            LocalDateTime dateTime = LocalDateTime.now();
            int amountToAdd = -1;
            try {
                amountToAdd = Integer.parseInt(strArr[2]);
            }
            catch (NumberFormatException ex) {
                throw BusinessException.create((String)ErrorCodeEnum.REPORT_WORK_DEF_INVALID_DATE_EXPRESSION.getErrCode(), (String)("invalid date expression: {}" + placeholderName));
            }
            ChronoUnit timeUnit = null;
            switch (strArr[1]) {
                case "YEAR": {
                    timeUnit = ChronoUnit.YEARS;
                    break;
                }
                case "MONTH": {
                    timeUnit = ChronoUnit.MONTHS;
                    break;
                }
                case "DAY": {
                    timeUnit = ChronoUnit.DAYS;
                    break;
                }
                case "WEEK": {
                    timeUnit = ChronoUnit.WEEKS;
                    break;
                }
                default: {
                    throw BusinessException.create((String)ErrorCodeEnum.REPORT_WORK_DEF_INVALID_DATE_EXPRESSION.getErrCode(), (String)("invalid date expression: {}" + placeholderName));
                }
            }
            return dateTime.plus(amountToAdd, timeUnit);
        }
    }
}

