/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.model;

import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.google.gson.JsonObject;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class RequestModel {
    private InvokeTypeEnum invokeType;
    private String hostProd;
    private String hostVer;
    private String hostId;
    private String hostAcct;
    private String tenantId;
    private String serviceProd;
    private String serviceProdUid;
    private String serviceName;
    private Map<String, String> datakeys;
    private Map<String, String> headers;
    private String bodyJsonString;
    private Map<String, String> eocIds;

    public InvokeTypeEnum getInvokeType() {
        return this.invokeType;
    }

    public void setInvokeType(InvokeTypeEnum invokeType) {
        this.invokeType = invokeType;
    }

    public String getHostProd() {
        return this.hostProd;
    }

    public void setHostProd(String hostProd) {
        this.hostProd = hostProd;
    }

    public String getHostVer() {
        return this.hostVer;
    }

    public void setHostVer(String hostVer) {
        this.hostVer = hostVer;
    }

    public String getHostId() {
        return this.hostId;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostAcct() {
        return this.hostAcct;
    }

    public void setHostAcct(String hostAcct) {
        this.hostAcct = hostAcct;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getServiceProd() {
        return this.serviceProd;
    }

    public void setServiceProd(String serviceProd) {
        this.serviceProd = serviceProd;
    }

    public String getServiceProdUid() {
        return this.serviceProdUid;
    }

    public void setServiceProdUid(String serviceProdUid) {
        this.serviceProdUid = serviceProdUid;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, String> getDatakeys() {
        return this.datakeys;
    }

    public void setDatakeys(Map<String, String> datakeys) {
        this.datakeys = datakeys;
    }

    public void addDatakey(String key, String value) {
        if (this.datakeys == null) {
            this.datakeys = new HashMap<String, String>();
        }
        this.datakeys.put(key, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void addHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new HashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public String getBodyJsonString() {
        return this.bodyJsonString;
    }

    public void setBodyJsonString(String bodyJsonString) {
        this.bodyJsonString = bodyJsonString;
    }

    public Map<String, String> getEocIds() {
        return this.eocIds;
    }

    public void setEocIds(Map<String, String> eocIds) {
        this.eocIds = eocIds;
    }

    public void addEocIds(String tag, String value) {
        if (this.eocIds == null) {
            this.eocIds = new HashMap<String, String>();
        }
        this.eocIds.put(tag, value);
    }

    public Map<String, String> getHttpHeaders() {
        HashMap<String, String> tMap = new HashMap<String, String>();
        tMap.put("digi-type", this.invokeType.toString().toLowerCase());
        JsonObject tHostJsonObject = new JsonObject();
        tHostJsonObject.addProperty("prod", this.hostProd);
        tHostJsonObject.addProperty("ver", this.hostVer);
        tHostJsonObject.addProperty("ip", "");
        if (this.hostId != null) {
            tHostJsonObject.addProperty("id", this.hostId);
        }
        tHostJsonObject.addProperty("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(Calendar.getInstance().getTime()));
        if (this.hostAcct != null) {
            if ("athena".equals(this.hostAcct)) {
                switch (this.serviceProd) {
                    case "E10": {
                        tHostJsonObject.addProperty("acct", "dcms");
                        break;
                    }
                    case "WFGP": {
                        tHostJsonObject.addProperty("acct", "DS");
                        break;
                    }
                    default: {
                        tHostJsonObject.addProperty("acct", this.hostAcct);
                        break;
                    }
                }
            } else {
                tHostJsonObject.addProperty("acct", this.hostAcct);
            }
        }
        tMap.put("digi-host", tHostJsonObject.toString());
        JsonObject tServiceJsonObject = new JsonObject();
        tServiceJsonObject.addProperty("prod", this.serviceProd);
        tServiceJsonObject.addProperty("tenant_id", this.tenantId);
        tServiceJsonObject.addProperty("name", this.serviceName);
        if (this.serviceProdUid != null) {
            tServiceJsonObject.addProperty("uid", this.serviceProdUid);
        }
        tMap.put("digi-service", tServiceJsonObject.toString());
        String keyStr = tHostJsonObject.toString() + tServiceJsonObject.toString();
        String md5Key = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(keyStr.getBytes("UTF-8"));
            byte[] digest = md.digest();
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < digest.length; ++i) {
                byte b;
                int value = (b & 0x7F) + ((b = digest[i]) < 0 ? 128 : 0);
                buffer.append(value < 16 ? "0" : "");
                buffer.append(Integer.toHexString(value));
            }
            md5Key = buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tMap.put("digi-key", md5Key);
        if (this.datakeys != null && !this.datakeys.isEmpty()) {
            JsonObject tDatakeyJsonObject = new JsonObject();
            for (String tKey : this.datakeys.keySet()) {
                tDatakeyJsonObject.addProperty(tKey, this.datakeys.get(tKey));
            }
            tMap.put("digi-datakey", tDatakeyJsonObject.toString());
        }
        if (this.headers != null) {
            tMap.putAll(this.headers);
        }
        return tMap;
    }
}

