/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.InvokeTypeEnum;
import com.digiwin.athena.esp.sdk.exception.ESPInvocationException;
import com.digiwin.athena.esp.sdk.exception.MDCInvocationException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.EocOmTransformUtil;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class Invoker {
    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString) throws MDCInvocationException, ProductUIDNotFoundException, ESPInvocationException {
        return Invoker.invokeRestSync(hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, null);
    }

    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString, Map<String, String> eocIds) throws MDCInvocationException, ProductUIDNotFoundException, ESPInvocationException {
        MessageModel tMessageModel = Invoker.convertToMessageModel(InvokeTypeEnum.SYNC, hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, eocIds);
        Invoker.invokeRest(tMessageModel);
        EocOmTransformUtil.transformResponse(tMessageModel);
        return tMessageModel.getResponseModel().getBodyJsonString();
    }

    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString) throws MDCInvocationException, ProductUIDNotFoundException, ESPInvocationException {
        return Invoker.invokeRestFasync(hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, null);
    }

    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString, Map<String, String> eocIds) throws MDCInvocationException, ProductUIDNotFoundException, ESPInvocationException {
        MessageModel tMessageModel = Invoker.convertToMessageModel(InvokeTypeEnum.FASYNC, hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakeys, headers, bodyJsonString, eocIds);
        Invoker.invokeRest(tMessageModel);
        return tMessageModel.getResponseModel();
    }

    private static void invokeRest(MessageModel messageModel) throws MDCInvocationException, ProductUIDNotFoundException, ESPInvocationException {
        EocOmTransformUtil.transformRequest(messageModel);
        try {
            HttpPost tHttpPost = new HttpPost(URLConstant.ESP_REST_BASE_URL);
            CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
            Map<String, String> headers = messageModel.getRequestModel().getHttpHeaders();
            Set<String> tKeySet = messageModel.getRequestModel().getHttpHeaders().keySet();
            for (String tKey : tKeySet) {
                tHttpPost.setHeader(tKey, headers.get(tKey));
            }
            StringEntity tStringEntity = new StringEntity(messageModel.getRequestModel().getBodyJsonString(), ContentType.APPLICATION_JSON);
            tHttpPost.setEntity((HttpEntity)tStringEntity);
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
            HashMap<String, String> tHeaders = new HashMap<String, String>();
            Header[] headerArray = tHttpResponse.getAllHeaders();
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header tHeader = headerArray[n2];
                tHeaders.put(tHeader.getName(), tHeader.getValue());
                ++n2;
            }
            ResponseModel tResponseModel = new ResponseModel(tHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
            messageModel.setResponseModel(tResponseModel);
        }
        catch (IOException e) {
            ESPInvocationException e1 = new ESPInvocationException(ErrorMsg.getInvokeEspFailed(new String[]{URLConstant.ESP_REST_BASE_URL}), e.getCause());
            e1.addSuppressed(e);
            throw e1;
        }
    }

    private static MessageModel convertToMessageModel(InvokeTypeEnum type, String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakeys, Map<String, String> headers, String bodyJsonString, Map<String, String> eocIds) {
        RequestModel requestModel = new RequestModel();
        requestModel.setInvokeType(type);
        requestModel.setHostProd(hostProd);
        requestModel.setHostVer(hostVer);
        requestModel.setHostId(hostId);
        requestModel.setHostAcct(hostAcct);
        requestModel.setTenantId(tenantId);
        requestModel.setServiceProd(serviceProd);
        requestModel.setServiceProdUid(serviceProdUid);
        requestModel.setServiceName(serviceName);
        requestModel.setDatakeys(datakeys);
        requestModel.setHeaders(headers);
        requestModel.setBodyJsonString(bodyJsonString);
        requestModel.setEocMap(eocIds);
        MessageModel messageModel = new MessageModel();
        messageModel.setRequestModel(requestModel);
        return messageModel;
    }

    private static class ErrorMsg {
        private static final String INVOKE_ESP_FAILED = "An error occurred while invoking ESP: {0}";
        private static final String UID_NOT_FOUND = "Cannot found product UID. Tenant Id: {0}, Product: {1}";
        private static final String EOC_NOT_FOUND = "Cannot transfer {0}: EOC info not found. Tenant Id: {1}, Product: {2}, Source: [";

        private ErrorMsg() {
        }

        private static String getInvokeEspFailed(String ... args) {
            return MessageFormat.format(INVOKE_ESP_FAILED, args);
        }
    }
}

