/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum EocTypeEnum {
    COMPANY(1, "org_type_company", "eoc_company_id", "om_company_id"),
    SITE(2, "org_type_site", "eoc_site_id", "om_site_id"),
    REGION(3, "org_type_region", "eoc_region_id", "om_region_id");

    private Integer level;
    private String levelTag;
    private String eocTag;
    private String omTag;
    private static Map<Integer, EocTypeEnum> enumList;
    private static int minLevel;
    private static int maxLevel;

    static {
        enumList = new HashMap<Integer, EocTypeEnum>();
        minLevel = 1;
        maxLevel = 3;
        for (EocTypeEnum eocType : EnumSet.allOf(EocTypeEnum.class)) {
            enumList.put(eocType.getLevel(), eocType);
        }
    }

    private EocTypeEnum(Integer level, String levelTag, String eocTag, String omTag) {
        this.level = level;
        this.levelTag = levelTag;
        this.eocTag = eocTag;
        this.omTag = omTag;
    }

    public int getLevel() {
        return this.level;
    }

    public String getLevelTag() {
        return this.levelTag;
    }

    public String getEocTag() {
        return this.eocTag;
    }

    public String getOmTag() {
        return this.omTag;
    }

    public static EocTypeEnum getEocTypeEnum(Integer level) {
        return enumList.get(level);
    }

    public static int getMinLevel() {
        return minLevel;
    }

    public static int getMaxLevel() {
        return maxLevel;
    }
}

