/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.TenantInfoEnum;
import com.digiwin.athena.esp.sdk.exception.TargetInvocationException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class TenantInfoUtil {
    private static final String PATH_MDC_TENANTID_GET = "/OmTenantId/Get";
    private static final String PATH_TM_SECRETKEY_GET = "/restful/service/knowledgegraph/app/licenseKey?tenantId=";
    private static final String PATH_IAM_USERTOKEN_GET = "/api/iam/v2/identity/login";

    public static Map<String, String> getTenantIdAndToken(String eaiUid, String prodUid, String omMap) throws Exception {
        String tTenantId = TenantInfoUtil.getTenantId(eaiUid, prodUid, omMap);
        String tSecretKey = TenantInfoUtil.getSecretKey(tTenantId);
        String tUserToken = TenantInfoUtil.getUserToken(tSecretKey);
        HashMap<String, String> tMap = new HashMap<String, String>();
        tMap.put(TenantInfoEnum.TENANT_ID.toString(), tTenantId);
        tMap.put(TenantInfoEnum.USER_TOKEN.toString(), tUserToken);
        return tMap;
    }

    private static String getTenantId(String eaiUid, String prodUid, String omMap) throws Exception {
        JsonObject tReturnJsonObject;
        try {
            JsonParser tJsonParser = new JsonParser();
            JsonObject tOmMapJsonObject = (JsonObject)tJsonParser.parse(omMap);
            JsonObject tJsonObject = new JsonObject();
            tJsonObject.addProperty("eai_uid", eaiUid);
            tJsonObject.addProperty("prod_uid", prodUid);
            tJsonObject.add("om_map", (JsonElement)tOmMapJsonObject);
            HttpPost tHttpPost = new HttpPost(URLConstant.MDC_BASE_URL + PATH_MDC_TENANTID_GET);
            CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
            StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
            tHttpPost.setEntity((HttpEntity)tStringEntity);
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
            tReturnJsonObject = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
        }
        catch (Exception e) {
            TargetInvocationException e1 = new TargetInvocationException(ErrorMsg.getMdcError(new String[]{e.toString()}));
            e1.addSuppressed(e);
            throw e1;
        }
        if (!tReturnJsonObject.get("tenant_id").getAsString().equals("")) {
            return tReturnJsonObject.get("tenant_id").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getTenantIdNotFound(new String[]{URLConstant.MDC_BASE_URL}));
    }

    private static String getSecretKey(String tenantId) throws Exception {
        JsonObject tReturnJsonObject;
        try {
            HttpGet tHttpGet = new HttpGet(URLConstant.TM_BASE_URL + PATH_TM_SECRETKEY_GET + tenantId);
            CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpGet);
            JsonParser tJsonParser = new JsonParser();
            tReturnJsonObject = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
        }
        catch (Exception e) {
            TargetInvocationException e1 = new TargetInvocationException(ErrorMsg.getTmError(new String[]{e.toString()}));
            e1.addSuppressed(e);
            throw e1;
        }
        String tStatus = null;
        if (tReturnJsonObject.get("status") != null) {
            tStatus = tReturnJsonObject.get("status").getAsString();
        }
        if ("200".equals(tStatus)) {
            return TenantInfoUtil.decodeAES(tReturnJsonObject.get("response").getAsString());
        }
        String tErrorMessage = null;
        if (tReturnJsonObject.get("errorMessage") != null) {
            tErrorMessage = tReturnJsonObject.get("errorMessage").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getLicenseKeyNotFound(new String[]{URLConstant.TM_BASE_URL, tStatus, tErrorMessage}));
    }

    private static String getUserToken(String secretKey) throws TargetInvocationException, TenantInfoNotFoundException {
        JsonObject tReturnJsonObject;
        try {
            HttpPost tHttpPost = new HttpPost(URLConstant.IAM_BASE_URL + PATH_IAM_USERTOKEN_GET);
            CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
            JsonObject tJsonObject = new JsonObject();
            tJsonObject.addProperty("secretKey", secretKey);
            tJsonObject.addProperty("identityType", "secretKey");
            StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
            tHttpPost.setEntity((HttpEntity)tStringEntity);
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
            JsonParser tJsonParser = new JsonParser();
            tReturnJsonObject = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
        }
        catch (Exception e) {
            TargetInvocationException e1 = new TargetInvocationException(ErrorMsg.getIamError(new String[]{e.toString()}));
            e1.addSuppressed(e);
            throw e1;
        }
        if (tReturnJsonObject.get("success") == null || tReturnJsonObject.get("success").getAsString().equals("true")) {
            return tReturnJsonObject.get("token").getAsString();
        }
        String tCode = null;
        String tMessge = null;
        if (tReturnJsonObject.get("code") != null) {
            tCode = tReturnJsonObject.get("code").getAsString();
        }
        if (tReturnJsonObject.get("message") != null) {
            tMessge = tReturnJsonObject.get("message").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getUserTokenNotFound(new String[]{URLConstant.IAM_BASE_URL, tCode, tMessge}));
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result = new byte[]{};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)secretKey), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        return new String(result);
    }

    private static class ErrorMsg {
        private static final String MDC_ERROR = "An error occurred while getting Tenant Id from MDC. Cause: [{0}]";
        private static final String TM_ERROR = "An error occurred while getting license key from TM. Cause: [{0}]";
        private static final String IAM_ERROR = "An error occurred while getting user token from IAM. Cause: [{0}]";
        private static final String TENANT_ID_NOT_FOUND = "Cannot find Tenant ID from MDC. MDC host:[{0}]";
        private static final String LICENSE_KEY_NOT_FOUND = "Cannot find License key from TM. TM host:[{0}], Status:[{1}], Error Message:[{2}]";
        private static final String USER_TOKEN_NOT_FOUND = "Cannot find User token from IAM. IAM host:[{0}], Code:[{1}], Message:[{2}]";

        private ErrorMsg() {
        }

        private static String getMdcError(String ... args) {
            return MessageFormat.format(MDC_ERROR, args);
        }

        private static String getTmError(String ... args) {
            return MessageFormat.format(TM_ERROR, args);
        }

        private static String getIamError(String ... args) {
            return MessageFormat.format(IAM_ERROR, args);
        }

        private static String getTenantIdNotFound(String ... args) {
            return MessageFormat.format(TENANT_ID_NOT_FOUND, args);
        }

        private static String getLicenseKeyNotFound(String ... args) {
            return MessageFormat.format(LICENSE_KEY_NOT_FOUND, args);
        }

        private static String getUserTokenNotFound(String ... args) {
            return MessageFormat.format(USER_TOKEN_NOT_FOUND, args);
        }
    }
}

