/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.EocTypeEnum;
import com.digiwin.athena.esp.sdk.exception.MDCInvocationException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.exception.TargetInvocationException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.util.TenantInfoUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class EocOmTransformUtil {
    private static final String PATH_EOC_MAPPING_GET = "/TenantProductOperationList/Get";
    private static final String REGULAR = "[\"'](eoc|om)_(company|site|region)_id[\"']\\s*:\\s*[\"'].+[\"']";
    private static final String DATAKEY = "datakey";
    private static final String UID = "uid";

    public static Map<String, String> transform(Map<String, String> targetMap, Map<String, String> sourceMap, String tenantId, String product) throws MDCInvocationException {
        if (!sourceMap.isEmpty()) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"message", tenantId, product}));
            JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
            EocOmTransformUtil.transform(targetMap, sourceMap, tMappingJsonObject, EocTypeEnum.getMinLevel(), tSB);
        }
        return targetMap;
    }

    public static String transform(String message, String tenantId, String product) throws MDCInvocationException {
        if (EocOmTransformUtil.checkTransform(message)) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"message", tenantId, product}));
            JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
            return EocOmTransformUtil.transform(message, tMappingJsonObject, tSB);
        }
        return message;
    }

    public static void transformRequest(MessageModel messageModel) throws MDCInvocationException, ProductUIDNotFoundException, TargetInvocationException, TenantInfoNotFoundException {
        String tBody;
        if (messageModel.getRequestModel().getServiceProd() == null) {
            messageModel.getRequestModel().setServiceProd(TenantInfoUtil.getExecutionProduct(messageModel.getRequestModel().getServiceName(), messageModel.getRequestModel().getHeader("token")));
        }
        String tenantId = messageModel.getRequestModel().getTenantId();
        String product = messageModel.getRequestModel().getServiceProd();
        messageModel.setEocMappingJsonObject(EocOmTransformUtil.getMappingJsonObject(tenantId, product));
        if (messageModel.getEocMappingJsonObject().get(UID) == null) {
            throw new ProductUIDNotFoundException(ErrorMsg.getUidNotFound(new String[]{tenantId, product}));
        }
        messageModel.getRequestModel().setServiceProdUid(messageModel.getEocMappingJsonObject().get(UID).getAsString());
        Map<String, String> tEocIds = messageModel.getRequestModel().getEocMap();
        if (tEocIds != null && !tEocIds.isEmpty()) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"request datakey", tenantId, product}));
            if (messageModel.getRequestModel().getDatakeyMap() == null) {
                messageModel.getRequestModel().setDatakeyMap(new HashMap<String, String>());
            }
            EocOmTransformUtil.transformDatakey(messageModel.getRequestModel().getDatakeyMap(), tEocIds, messageModel.getEocMappingJsonObject(), EocTypeEnum.getMinLevel(), tSB);
        }
        if (EocOmTransformUtil.checkTransform(tBody = messageModel.getRequestModel().getBodyJsonString())) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"request body", tenantId, product}));
            messageModel.getRequestModel().setBodyJsonString(EocOmTransformUtil.transform(tBody, messageModel.getEocMappingJsonObject(), tSB));
        }
    }

    public static void transformResponse(MessageModel messageModel) throws MDCInvocationException {
        String tBody;
        String tenantId = messageModel.getRequestModel().getTenantId();
        String product = messageModel.getRequestModel().getServiceProd();
        if (messageModel.getEocMappingJsonObject() == null) {
            messageModel.setEocMappingJsonObject(EocOmTransformUtil.getMappingJsonObject(tenantId, product));
        }
        if (messageModel.getEocMappingJsonObject().get(EocTypeEnum.COMPANY.getLevelTag()).getAsJsonArray().size() > 0 && EocOmTransformUtil.checkTransform(tBody = messageModel.getResponseModel().getBodyJsonString())) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"response body", tenantId, product}));
            messageModel.getResponseModel().setBodyJsonString(EocOmTransformUtil.transform(tBody, messageModel.getEocMappingJsonObject(), tSB));
        }
    }

    public static void transformDatakey(Map<String, String> datakeys, Map<String, String> eocIds, JsonObject mappingJsonObject, int level, StringBuilder errorMsg) {
        JsonObject tEntObject;
        if (mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()) != null && (tEntObject = mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()).getAsJsonObject()).has(DATAKEY)) {
            datakeys.put(tEntObject.get(DATAKEY).getAsString(), tEntObject.get(EocTypeEnum.ENTERPRISE.getOmTag()).getAsString());
        }
        JsonObject tSubMappingJsonObject = mappingJsonObject;
        EocTypeEnum eocType = EocTypeEnum.getEocTypeEnum(level);
        String sourceTag = eocType.getEocTag();
        String targetTag = eocType.getOmTag();
        String datakeyTag = null;
        if (eocIds.containsKey(sourceTag)) {
            JsonArray tJsonArray;
            String sourceValue = eocIds.get(sourceTag);
            errorMsg.append(sourceTag).append("=").append(sourceValue).append(", ");
            String targetValue = null;
            if (mappingJsonObject.has(eocType.getLevelTag()) && (tJsonArray = mappingJsonObject.get(eocType.getLevelTag()).getAsJsonArray()).size() > 0) {
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    JsonObject tObj = tJsonArray.get(i).getAsJsonObject();
                    if (!sourceValue.equals(tObj.get(sourceTag).getAsString())) continue;
                    datakeyTag = tObj.has(DATAKEY) ? tObj.get(DATAKEY).getAsString() : null;
                    targetValue = tObj.get(targetTag).getAsString();
                    tSubMappingJsonObject = tObj;
                    break;
                }
                if (targetValue == null) {
                    errorMsg.replace(errorMsg.toString().lastIndexOf(", "), errorMsg.length(), "].");
                } else if (datakeyTag != null) {
                    datakeys.put(datakeyTag, targetValue);
                }
            }
        }
        if (level < EocTypeEnum.getMaxLevel()) {
            EocOmTransformUtil.transformDatakey(datakeys, eocIds, tSubMappingJsonObject, level + 1, errorMsg);
        }
    }

    private static String transform(String message, JsonObject mappingJsonObject, StringBuilder errorMsg) {
        JsonParser tJsonParser = new JsonParser();
        JsonObject tMessageJsonObject = tJsonParser.parse(message).getAsJsonObject();
        EocOmTransformUtil.transform(tMessageJsonObject, mappingJsonObject, errorMsg.toString());
        return tMessageJsonObject.toString();
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, String errorMsg) {
        StringBuilder tSB = new StringBuilder();
        tSB.append(errorMsg);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.getMinLevel(), tSB);
        Set tKeySet = messageJsonObject.keySet();
        for (String tKey : tKeySet) {
            if (messageJsonObject.get(tKey).isJsonArray()) {
                JsonArray tJsonArray = messageJsonObject.get(tKey).getAsJsonArray();
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    EocOmTransformUtil.transform(tJsonArray.get(i).getAsJsonObject(), mappingJsonObject, errorMsg);
                }
                continue;
            }
            if (!messageJsonObject.get(tKey).isJsonObject()) continue;
            EocOmTransformUtil.transform(messageJsonObject.get(tKey).getAsJsonObject(), mappingJsonObject, errorMsg);
        }
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, int level, StringBuilder errorMsg) {
        JsonObject tSubMappingJsonObject = mappingJsonObject;
        EocTypeEnum eocType = EocTypeEnum.getEocTypeEnum(level);
        String sourceTag = null;
        String targetTag = null;
        JsonElement element = null;
        element = messageJsonObject.get(EocTypeEnum.getEocTypeEnum(level).getEocTag());
        if (element != null && !"".equals(element.getAsString())) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else {
            element = messageJsonObject.get(EocTypeEnum.getEocTypeEnum(level).getOmTag());
            if (element != null && !"".equals(element.getAsString())) {
                sourceTag = eocType.getOmTag();
                targetTag = eocType.getEocTag();
            }
        }
        if (sourceTag != null) {
            JsonArray tJsonArray;
            String sourceValue = element.getAsString();
            errorMsg.append(sourceTag).append("=").append(sourceValue).append(", ");
            if (mappingJsonObject.has(eocType.getLevelTag()) && (tJsonArray = mappingJsonObject.get(eocType.getLevelTag()).getAsJsonArray()).size() > 0) {
                String targetValue = null;
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    JsonObject tObj = tJsonArray.get(i).getAsJsonObject();
                    if (!sourceValue.equals(tObj.get(sourceTag).getAsString())) continue;
                    targetValue = tObj.get(targetTag).getAsString();
                    tSubMappingJsonObject = tObj;
                    break;
                }
                if (targetValue == null) {
                    errorMsg.replace(errorMsg.toString().lastIndexOf(", "), errorMsg.length(), "].");
                } else {
                    messageJsonObject.addProperty(targetTag, targetValue);
                }
            }
        }
        if (level < EocTypeEnum.getMaxLevel()) {
            EocOmTransformUtil.transform(messageJsonObject, tSubMappingJsonObject, level + 1, errorMsg);
        }
    }

    private static void transform(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject, int level, StringBuilder errorMsg) {
        JsonObject tSubMappingJsonObject = mappingJsonObject;
        EocTypeEnum eocType = EocTypeEnum.getEocTypeEnum(level);
        String sourceTag = null;
        String targetTag = null;
        if (sourceMap.containsKey(eocType.getEocTag())) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else if (sourceMap.containsKey(eocType.getOmTag())) {
            sourceTag = eocType.getOmTag();
            targetTag = eocType.getEocTag();
        }
        if (sourceTag != null) {
            JsonArray tJsonArray;
            String sourceValue = sourceMap.get(sourceTag);
            errorMsg.append(sourceTag).append("=").append(sourceValue).append(", ");
            if (mappingJsonObject.has(eocType.getLevelTag()) && (tJsonArray = mappingJsonObject.get(eocType.getLevelTag()).getAsJsonArray()).size() > 0) {
                String targetValue = null;
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    JsonObject tObj = tJsonArray.get(i).getAsJsonObject();
                    if (!sourceValue.equals(tObj.get(sourceTag).getAsString())) continue;
                    targetValue = tObj.get(targetTag).getAsString();
                    tSubMappingJsonObject = tObj;
                    break;
                }
                if (targetValue == null) {
                    errorMsg.replace(errorMsg.toString().lastIndexOf(", "), errorMsg.length(), "].");
                } else {
                    targetMap.put(targetTag, targetValue);
                }
            }
        }
        if (level < EocTypeEnum.getMaxLevel()) {
            EocOmTransformUtil.transform(targetMap, sourceMap, tSubMappingJsonObject, level + 1, errorMsg);
        }
    }

    private static JsonObject getMappingJsonObject(String tenantId, String product) throws MDCInvocationException {
        try {
            HttpPost tHttpPost = new HttpPost(URLConstant.MDC_BASE_URL + PATH_EOC_MAPPING_GET);
            CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
            JsonObject tJsonObject = new JsonObject();
            tJsonObject.addProperty("tenant_id", tenantId);
            tJsonObject.addProperty("prod_name", product);
            StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
            tHttpPost.setEntity((HttpEntity)tStringEntity);
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
            JsonParser tJsonParser = new JsonParser();
            JsonObject tReturnJsonObject = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
            return tReturnJsonObject;
        }
        catch (Exception e) {
            MDCInvocationException e1 = new MDCInvocationException(ErrorMsg.getGetEocFailed(new String[]{URLConstant.MDC_BASE_URL}), e.getCause());
            e1.addSuppressed(e);
            throw e1;
        }
    }

    private static boolean checkTransform(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        Pattern tRegexP = Pattern.compile(REGULAR);
        Matcher tMatch = tRegexP.matcher(message);
        return tMatch.find();
    }

    private static class ErrorMsg {
        private static final String GET_EOC_FAILED = "An error occurred while getting EOC info from MDC: {0}";
        private static final String UID_NOT_FOUND = "Product UID not found. Tenant id: {0}, product: {1}";
        private static final String EOC_NOT_FOUND = "Cannot transfer {0}: EOC info not found. Tenant id: {1}, product: {2}, source: [";

        private ErrorMsg() {
        }

        private static String getGetEocFailed(String ... args) {
            return MessageFormat.format(GET_EOC_FAILED, args);
        }

        private static String getUidNotFound(String ... args) {
            return MessageFormat.format(UID_NOT_FOUND, args);
        }

        private static String getEocNotFound(String ... args) {
            return MessageFormat.format(EOC_NOT_FOUND, args);
        }
    }
}

