/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.connection.HttpClientFactory;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.EocTypeEnum;
import com.digiwin.athena.esp.sdk.exception.MDCInvocationException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.TenantInfoUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class EocOmTransformUtil {
    private static final String PATH_MDC_TENANT_PRODUCT_OPERATION_LIST_GET = "/TenantProductOperationList/Get";
    private static final String PATH_EOC_EMP_ID = "/api/eoc/v2/emp/id";
    private static final String REGULAR = "[\"'](ex_){0,1}(eoc|om)_(company|site|region)_id[\"']\\s*:\\s*[\"'].+[\"']";
    private static final String DATAKEY = "datakey";
    private static final String UID = "uid";
    private static final String REGION_TYPE = "region_type";
    private static final String EX_REGION_TYPE = "ex_region_type";

    public static String transform(String message, String tenantId, String product) throws MDCInvocationException {
        if (EocOmTransformUtil.checkTransform(message)) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"message", tenantId, product}));
            JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
            return EocOmTransformUtil.transform(message, tMappingJsonObject, tSB);
        }
        return message;
    }

    public static void transformRequest(MessageModel messageModel) throws Exception {
        String tBody;
        Map<String, String> tEocMap;
        JsonObject tEntObject;
        RequestModel requestModel = messageModel.getRequestModel();
        if (requestModel.getServiceProd() == null) {
            requestModel.setServiceProd(TenantInfoUtil.getExecutionProduct(requestModel.getTenantId(), requestModel.getServiceName(), requestModel.getHeader("token")));
        }
        EocOmTransformUtil.transformAcct(requestModel);
        String tenantId = requestModel.getTenantId();
        String product = requestModel.getServiceProd();
        JsonObject mappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
        messageModel.setEocMappingJsonObject(mappingJsonObject);
        if (mappingJsonObject.get(UID) == null) {
            throw new ProductUIDNotFoundException(ErrorMsg.getUidNotFound(new String[]{tenantId, product}));
        }
        requestModel.setServiceProdUid(mappingJsonObject.get(UID).getAsString());
        if (mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()) != null && (tEntObject = mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()).getAsJsonObject()).has(DATAKEY)) {
            requestModel.addDatakey(tEntObject.get(DATAKEY).getAsString(), tEntObject.get(EocTypeEnum.ENTERPRISE.getOmTag()).getAsString());
        }
        if ((tEocMap = messageModel.getRequestModel().getEocMap()) != null && !tEocMap.isEmpty()) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"request datakey", tenantId, product}));
            if (requestModel.getDatakeyMap() == null) {
                requestModel.setDatakeyMap(new HashMap<String, String>());
            }
            EocOmTransformUtil.transformDatakey(requestModel.getDatakeyMap(), tEocMap, messageModel.getEocMappingJsonObject(), tSB);
        }
        if (EocOmTransformUtil.checkTransform(tBody = messageModel.getRequestModel().getBodyJsonString())) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"request body", tenantId, product}));
            messageModel.getRequestModel().setBodyJsonString(EocOmTransformUtil.transform(tBody, messageModel.getEocMappingJsonObject(), tSB));
        }
    }

    public static void transformResponse(MessageModel messageModel) throws MDCInvocationException {
        ResponseModel resposeModel = messageModel.getResponseModel();
        String tBody = resposeModel.getBodyJsonString();
        if (EocOmTransformUtil.checkTransform(tBody)) {
            StringBuilder tSB = new StringBuilder();
            String tenantId = messageModel.getRequestModel().getTenantId();
            String product = messageModel.getRequestModel().getServiceProd();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"response body", tenantId, product}));
            if (messageModel.getEocMappingJsonObject() == null) {
                messageModel.setEocMappingJsonObject(EocOmTransformUtil.getMappingJsonObject(tenantId, product));
            }
            resposeModel.setBodyJsonString(EocOmTransformUtil.transform(tBody, messageModel.getEocMappingJsonObject(), tSB));
        }
    }

    private static void transformAcct(RequestModel requestModel) throws Exception {
        String tEocAcct = requestModel.getHostAcct();
        if (tEocAcct != null && !tEocAcct.trim().equals("")) {
            if (tEocAcct.trim().equals("athena")) {
                String serviceProd;
                switch (serviceProd = requestModel.getServiceProd()) {
                    case "E10": {
                        requestModel.setHostEmpAcct("dcms");
                        break;
                    }
                    case "WFGP": {
                        requestModel.setHostEmpAcct("DS");
                        break;
                    }
                    case "T100": 
                    case "TIPTOP": {
                        requestModel.setHostEmpAcct("tiptop");
                        break;
                    }
                    default: {
                        requestModel.setHostEmpAcct(tEocAcct);
                        break;
                    }
                }
            } else {
                HttpPost tHttpPost = new HttpPost(URLConstant.EOC_BASE_URL + PATH_EOC_EMP_ID);
                CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
                JsonObject tJsonObject = new JsonObject();
                tJsonObject.addProperty("userId", tEocAcct);
                StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
                tHttpPost.setEntity((HttpEntity)tStringEntity);
                tHttpPost.addHeader("digi-middleware-auth-user", requestModel.getHeader("token"));
                tHttpPost.addHeader("routerKey", requestModel.getTenantId());
                CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
                JsonParser tJsonParser = new JsonParser();
                JsonObject tReturnJsonObject = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
                if (tReturnJsonObject.get("code") != null && tReturnJsonObject.get("code").getAsString().equals("200")) {
                    requestModel.setHostEmpAcct(tReturnJsonObject.get("data").getAsString());
                } else {
                    throw new Exception("Cannot find empId from Eoc. User Id: " + tEocAcct + "; User token: " + requestModel.getHeader("token"));
                }
            }
        }
    }

    private static void transformDatakey(Map<String, String> datakeys, Map<String, String> eocmap, JsonObject mappingJsonObject, StringBuilder errorMsg) {
        EocOmTransformUtil.transformDatakey(datakeys, eocmap, mappingJsonObject, EocTypeEnum.COMPANY, errorMsg);
        EocOmTransformUtil.transformDatakey(datakeys, eocmap, mappingJsonObject, EocTypeEnum.REGION, errorMsg);
    }

    private static void transformDatakey(Map<String, String> datakeys, Map<String, String> eocmap, JsonObject mappingJsonObject, EocTypeEnum eocType, StringBuilder errorMsg) {
        if (eocmap.get(eocType.getEocTag()) != null) {
            JsonObject tSubObj;
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(eocType.getEocTag(), eocmap.get(eocType.getEocTag()));
            if (eocType.equals((Object)EocTypeEnum.REGION) && eocmap.get(REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, eocmap.get(REGION_TYPE));
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null && tSubObj.has(DATAKEY)) {
                datakeys.put(tSubObj.get(DATAKEY).getAsString(), tSubObj.get(eocType.getOmTag()).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformDatakey(datakeys, eocmap, tSubObj, EocTypeEnum.SITE, errorMsg);
                }
            }
        }
    }

    public static Map<String, String> transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, String tenantId, String product) throws MDCInvocationException {
        if (!sourceMap.isEmpty()) {
            StringBuilder tSB = new StringBuilder();
            tSB.append(ErrorMsg.getEocNotFound(new String[]{"message", tenantId, product}));
            JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
            EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tMappingJsonObject, EocTypeEnum.COMPANY, tSB);
            EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tMappingJsonObject, EocTypeEnum.REGION, tSB);
        }
        return targetMap;
    }

    private static String transform(String message, JsonObject mappingJsonObject, StringBuilder errorMsg) {
        JsonParser tJsonParser = new JsonParser();
        JsonObject tMessageJsonObject = tJsonParser.parse(message).getAsJsonObject();
        EocOmTransformUtil.transform(tMessageJsonObject, mappingJsonObject, errorMsg.toString());
        return tMessageJsonObject.toString();
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, String errorMsg) {
        StringBuilder tSB = new StringBuilder();
        tSB.append(errorMsg);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.COMPANY, tSB);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.REGION, tSB);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.EX_COMPANY, tSB);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.EX_REGION, tSB);
        Set tKeySet = messageJsonObject.keySet();
        for (String tKey : tKeySet) {
            if (messageJsonObject.get(tKey).isJsonArray()) {
                JsonArray tJsonArray = messageJsonObject.get(tKey).getAsJsonArray();
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    EocOmTransformUtil.transform(tJsonArray.get(i).getAsJsonObject(), mappingJsonObject, errorMsg);
                }
                continue;
            }
            if (!messageJsonObject.get(tKey).isJsonObject()) continue;
            EocOmTransformUtil.transform(messageJsonObject.get(tKey).getAsJsonObject(), mappingJsonObject, errorMsg);
        }
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, EocTypeEnum eocType, StringBuilder errorMsg) {
        String sourceTag = null;
        String targetTag = null;
        JsonElement element = null;
        element = messageJsonObject.get(eocType.getEocTag());
        if (element != null && !"".equals(element.getAsString())) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else {
            element = messageJsonObject.get(eocType.getOmTag());
            if (element != null && !"".equals(element.getAsString())) {
                sourceTag = eocType.getOmTag();
                targetTag = eocType.getEocTag();
            }
        }
        if (sourceTag != null) {
            String sourceValue = element.getAsString();
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag.replace("ex_", ""), sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && messageJsonObject.get(REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, messageJsonObject.get(REGION_TYPE).getAsString());
            }
            if (eocType.equals((Object)EocTypeEnum.EX_REGION) && messageJsonObject.get(EX_REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, messageJsonObject.get(EX_REGION_TYPE).getAsString());
            }
            errorMsg.append(sourceTag).append("=").append(sourceValue).append(", ");
            JsonObject tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap);
            if (tSubObj == null) {
                errorMsg.replace(errorMsg.toString().lastIndexOf(", "), errorMsg.length(), "].");
            } else {
                messageJsonObject.addProperty(targetTag, tSubObj.get(targetTag.replace("ex_", "")).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transform(messageJsonObject, tSubObj, EocTypeEnum.SITE, errorMsg);
                }
                if (eocType.equals((Object)EocTypeEnum.EX_COMPANY)) {
                    EocOmTransformUtil.transform(messageJsonObject, tSubObj, EocTypeEnum.EX_SITE, errorMsg);
                }
            }
        }
    }

    private static void transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject, EocTypeEnum eocType, StringBuilder errorMsg) {
        String sourceTag = null;
        String targetTag = null;
        if (sourceMap.containsKey(eocType.getEocTag())) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else if (sourceMap.containsKey(eocType.getOmTag())) {
            sourceTag = eocType.getOmTag();
            targetTag = eocType.getEocTag();
        }
        if (sourceTag != null) {
            String sourceValue = sourceMap.get(sourceTag);
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag, sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && sourceMap.get(REGION_TYPE) != null) {
                targetMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
                tConditionMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
            }
            errorMsg.append(sourceTag).append("=").append(sourceValue).append(", ");
            JsonObject tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap);
            if (tSubObj == null) {
                errorMsg.replace(errorMsg.toString().lastIndexOf(", "), errorMsg.length(), "].");
            } else {
                targetMap.put(targetTag, tSubObj.get(targetTag).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tSubObj, EocTypeEnum.SITE, errorMsg);
                }
            }
        }
    }

    private static JsonObject getMappingJsonObject(String tenantId, String product) throws MDCInvocationException {
        try {
            HttpPost tHttpPost = new HttpPost(URLConstant.MDC_BASE_URL + PATH_MDC_TENANT_PRODUCT_OPERATION_LIST_GET);
            CloseableHttpClient tClient = HttpClientFactory.createHttpClient();
            JsonObject tJsonObject = new JsonObject();
            tJsonObject.addProperty("tenant_id", tenantId);
            tJsonObject.addProperty("prod_name", product);
            StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
            tHttpPost.setEntity((HttpEntity)tStringEntity);
            tHttpPost.addHeader("routerKey", tenantId);
            CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
            JsonParser tJsonParser = new JsonParser();
            JsonObject tReturnJsonObject = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
            return tReturnJsonObject;
        }
        catch (Exception e) {
            MDCInvocationException e1 = new MDCInvocationException(ErrorMsg.getGetEocFailed(new String[]{URLConstant.MDC_BASE_URL}), e.getCause());
            e1.addSuppressed(e);
            throw e1;
        }
    }

    private static boolean checkTransform(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        Pattern tRegexP = Pattern.compile(REGULAR);
        Matcher tMatch = tRegexP.matcher(message);
        return tMatch.find();
    }

    private static JsonObject searchSubEocJsonObject(JsonObject eocJsonObject, EocTypeEnum eocType, Map<String, String> conditionMap) {
        JsonArray eocJsonArray;
        if (eocJsonObject.get(eocType.getLevelTag()) != null && (eocJsonArray = eocJsonObject.get(eocType.getLevelTag()).getAsJsonArray()).size() > 0) {
            Set<String> keySet = conditionMap.keySet();
            for (int i = 0; i < eocJsonArray.size(); ++i) {
                boolean result = true;
                JsonObject tObj = eocJsonArray.get(i).getAsJsonObject();
                for (String key : keySet) {
                    if (conditionMap.get(key).equals(tObj.get(key).getAsString())) continue;
                    result = false;
                    break;
                }
                if (!result) continue;
                return tObj;
            }
        }
        return null;
    }

    private static class ErrorMsg {
        private static final String GET_EOC_FAILED = "An error occurred while getting EOC info from MDC: {0}";
        private static final String UID_NOT_FOUND = "Product UID not found. Tenant id: {0}, product: {1}";
        private static final String EOC_NOT_FOUND = "Cannot transfer {0}: EOC info not found. Tenant id: {1}, product: {2}, source: [";

        private ErrorMsg() {
        }

        private static String getGetEocFailed(String ... args) {
            return MessageFormat.format(GET_EOC_FAILED, args);
        }

        private static String getUidNotFound(String ... args) {
            return MessageFormat.format(UID_NOT_FOUND, args);
        }

        private static String getEocNotFound(String ... args) {
            return MessageFormat.format(EOC_NOT_FOUND, args);
        }
    }
}

