/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Invoker {
    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString) throws ClientProtocolException, IOException {
        HttpResponse tHttpResponse = Invoker.invokeRest("sync", hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakey, headers, bodyJsonString);
        return EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
    }

    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString) throws ClientProtocolException, IOException {
        HttpResponse tHttpResponse = Invoker.invokeRest("fasync", hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakey, headers, bodyJsonString);
        HashMap<String, String> tHeaders = new HashMap<String, String>();
        Header[] headerArray = tHttpResponse.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header tHeader = headerArray[n2];
            tHeaders.put(tHeader.getName(), tHeader.getValue());
            ++n2;
        }
        return new ResponseModel(tHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
    }

    private static HttpResponse invokeRest(String type, String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString) throws ClientProtocolException, IOException {
        JsonObject tHostJsonObject;
        CloseableHttpClient tClient;
        HttpPost tHttpPost;
        block19: {
            block20: {
                tHttpPost = new HttpPost("http://esp.digiwincloud.com.cn/CROSS/RESTful");
                tClient = HttpClients.createDefault();
                tHttpPost.setHeader("digi-type", type);
                tHostJsonObject = new JsonObject();
                tHostJsonObject.addProperty("prod", hostProd);
                tHostJsonObject.addProperty("ver", hostVer);
                tHostJsonObject.addProperty("ip", "");
                if (hostId != null) {
                    tHostJsonObject.addProperty("id", hostId);
                }
                tHostJsonObject.addProperty("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(Calendar.getInstance().getTime()));
                if (hostAcct == null) break block19;
                if (!"athena".equals(hostAcct)) break block20;
                switch (serviceProd) {
                    case "E10": {
                        tHostJsonObject.addProperty("acct", "dcms");
                        break;
                    }
                    case "WFGP": {
                        tHostJsonObject.addProperty("acct", "DS");
                        break;
                    }
                    default: {
                        tHostJsonObject.addProperty("acct", hostAcct);
                        break;
                    }
                }
                break block19;
            }
            tHostJsonObject.addProperty("acct", hostAcct);
        }
        tHttpPost.setHeader("digi-host", tHostJsonObject.toString());
        JsonObject tServiceJsonObject = new JsonObject();
        tServiceJsonObject.addProperty("prod", serviceProd);
        if (serviceProdUid != null) {
            tServiceJsonObject.addProperty("uid", serviceProdUid);
        }
        tServiceJsonObject.addProperty("tenant_id", tenantId);
        tServiceJsonObject.addProperty("name", serviceName);
        tHttpPost.setHeader("digi-service", tServiceJsonObject.toString());
        String keyStr = String.valueOf(tHostJsonObject.toString()) + tServiceJsonObject.toString();
        String md5Key = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(keyStr.getBytes("UTF-8"));
            byte[] digest = md.digest();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                byte b;
                int value = (b & 0x7F) + ((b = digest[i]) < 0 ? 128 : 0);
                buffer.append(value < 16 ? "0" : "");
                buffer.append(Integer.toHexString(value));
                ++i;
            }
            md5Key = buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tHttpPost.setHeader("digi-key", md5Key);
        if (datakey != null) {
            JsonObject tDatakeyJsonObject = new JsonObject();
            for (String tKey : datakey.keySet()) {
                tDatakeyJsonObject.addProperty(tKey, datakey.get(tKey));
            }
            tHttpPost.setHeader("digi-datakey", tDatakeyJsonObject.toString());
        }
        if (headers != null) {
            Set<String> tKeySet = headers.keySet();
            for (String tKey : tKeySet) {
                tHttpPost.setHeader(tKey, headers.get(tKey));
            }
        }
        StringEntity tStringEntity = new StringEntity(bodyJsonString, ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        return tClient.execute((HttpUriRequest)tHttpPost);
    }
}

