/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.TenantInfoEnum;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.exception.TenantInfoNotFoundException;
import com.digiwin.athena.esp.sdk.util.EocOmTransformUtil;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class TenantInfoUtil {
    private static final String PATH_MDC_TENANTID_GET = "/OmTenantId/Get";
    private static final String PATH_TM_SECRETKEY_GET = "/restful/service/knowledgegraph/app/licenseKey?tenantId=";
    private static final String PATH_IAM_USERTOKEN_GET = "/api/iam/v2/identity/login";
    private static final String PATH_TM_QUERY_EXECUTION_INFO_GET = "/restful/service/knowledgegraph/action/queryExecutionInfo";

    public static Map<String, String> getTenantIdAndToken(String eaiUid, String prodUid, String omMap) throws Exception {
        String tTenantId = TenantInfoUtil.getTenantId(eaiUid, prodUid, omMap);
        String tSecretKey = TenantInfoUtil.getSecretKey(tTenantId);
        String tUserToken = TenantInfoUtil.getUserToken(tSecretKey);
        HashMap<String, String> tMap = new HashMap<String, String>();
        tMap.put(TenantInfoEnum.TENANT_ID.toString(), tTenantId);
        tMap.put(TenantInfoEnum.USER_TOKEN.toString(), tUserToken);
        return tMap;
    }

    public static String getEocMap(String tenantId, String product, String omMap) throws ClientProtocolException, IOException, ParseException, JsonFormatException {
        String result = "{}";
        JsonParser tJsonParser = new JsonParser();
        JsonObject tJsonObject = (JsonObject)tJsonParser.parse(omMap);
        HashMap<String, String> tOmMap = new HashMap<String, String>();
        HashMap<String, String> tEocMap = new HashMap<String, String>();
        for (String key : tJsonObject.keySet()) {
            tOmMap.put(key, tJsonObject.get(key).getAsString());
        }
        EocOmTransformUtil.transformEocOmMap(tEocMap, tOmMap, tenantId, product);
        if (!tEocMap.isEmpty()) {
            JsonObject tEocMapJsonObject = new JsonObject();
            for (String tKey : tEocMap.keySet()) {
                tEocMapJsonObject.addProperty(tKey, (String)tEocMap.get(tKey));
            }
            result = tEocMapJsonObject.toString();
        }
        return result;
    }

    private static String getTenantId(String eaiUid, String prodUid, String omMap) throws ClientProtocolException, IOException, TenantInfoNotFoundException, ParseException, JsonFormatException {
        JsonParser tJsonParser = new JsonParser();
        JsonObject tOmMapJsonObject = (JsonObject)tJsonParser.parse(omMap);
        String tURL = URLConstant.MDC_BASE_URL + PATH_MDC_TENANTID_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("eai_uid", eaiUid);
        tJsonObject.addProperty("prod_uid", prodUid);
        tJsonObject.add("om_map", (JsonElement)tOmMapJsonObject);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        if (!tReturnJsonObject.get("tenant_id").getAsString().equals("")) {
            return tReturnJsonObject.get("tenant_id").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getTenantIdNotFound(new String[]{URLConstant.MDC_BASE_URL}));
    }

    private static String getSecretKey(String tenantId) throws Exception {
        String tURL = URLConstant.TM_BASE_URL + PATH_TM_SECRETKEY_GET;
        HttpGet tHttpGet = new HttpGet(tURL + tenantId);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpGet);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        String tStatus = null;
        if (tReturnJsonObject.get("status") != null) {
            tStatus = tReturnJsonObject.get("status").getAsString();
        }
        if ("200".equals(tStatus)) {
            return TenantInfoUtil.decodeAES(tReturnJsonObject.get("response").getAsString());
        }
        String tErrorMessage = null;
        if (tReturnJsonObject.get("errorMessage") != null) {
            tErrorMessage = tReturnJsonObject.get("errorMessage").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getLicenseKeyNotFound(new String[]{URLConstant.TM_BASE_URL, tStatus, tErrorMessage}));
    }

    public static String getTenantIdBySecretKey(String secretKey) throws TenantInfoNotFoundException, ClientProtocolException, IOException, ParseException, JsonFormatException {
        return TenantInfoUtil.getIAMUserInfoBySecretKey(secretKey, IAMEnum.TENANT_ID);
    }

    private static String getUserToken(String secretKey) throws TenantInfoNotFoundException, ClientProtocolException, IOException, ParseException, JsonFormatException {
        return TenantInfoUtil.getIAMUserInfoBySecretKey(secretKey, IAMEnum.USER_TOKEN);
    }

    private static String getIAMUserInfoBySecretKey(String secretKey, IAMEnum iamEnum) throws TenantInfoNotFoundException, ClientProtocolException, IOException, ParseException, JsonFormatException {
        String tURL = URLConstant.IAM_BASE_URL + PATH_IAM_USERTOKEN_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("secretKey", secretKey);
        tJsonObject.addProperty("identityType", "secretKey");
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        if (tReturnJsonObject.get("success") == null || tReturnJsonObject.get("success").getAsString().equals("true")) {
            switch (iamEnum) {
                case TENANT_ID: {
                    return tReturnJsonObject.get("tenantId").getAsString();
                }
                case USER_TOKEN: {
                    return tReturnJsonObject.get("token").getAsString();
                }
            }
            return "";
        }
        String tCode = null;
        String tMessge = null;
        if (tReturnJsonObject.get("code") != null) {
            tCode = tReturnJsonObject.get("code").getAsString();
        }
        if (tReturnJsonObject.get("message") != null) {
            tMessge = tReturnJsonObject.get("message").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getUserTokenNotFound(new String[]{URLConstant.IAM_BASE_URL, tCode, tMessge}));
    }

    protected static String getExecutionProduct(String tenantId, String apiName, String userToken) throws TenantInfoNotFoundException, ClientProtocolException, IOException, ParseException, JsonFormatException {
        String tURL = URLConstant.TM_BASE_URL + PATH_TM_QUERY_EXECUTION_INFO_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("actionId", "esp_" + apiName);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader("token", userToken);
        tHttpPost.addHeader("routerKey", tenantId);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        String tStatus = null;
        if (tReturnJsonObject.get("status") != null) {
            tStatus = tReturnJsonObject.get("status").getAsString();
        }
        if ("200".equals(tStatus)) {
            return tReturnJsonObject.get("response").getAsJsonObject().get("productName").getAsString();
        }
        String tErrorMessage = null;
        if (tReturnJsonObject.get("errorMessage") != null) {
            tErrorMessage = tReturnJsonObject.get("errorMessage").getAsString();
        }
        throw new TenantInfoNotFoundException(ErrorMsg.getExecutionProductNotFound(new String[]{URLConstant.TM_BASE_URL, tStatus, tErrorMessage}));
    }

    private static String decodeAES(String secretFile) throws Exception {
        byte[] result = new byte[]{};
        String secretKey = "C40605DBA4C2D6D3FA353C7CA35752B9";
        SecretKeySpec key1 = new SecretKeySpec(Hex.decodeHex((String)secretKey), "AES");
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        cipher.init(2, key1);
        result = cipher.doFinal(Hex.decodeHex((String)secretFile));
        return new String(result);
    }

    private static enum IAMEnum {
        TENANT_ID,
        USER_TOKEN;

    }

    private static class ErrorMsg {
        private static final String MDC_ERROR = "An error occurred while getting Tenant Id from MDC. Cause: [{0}]";
        private static final String TM_lICKEY_ERROR = "An error occurred while getting license key from TM. Cause: [{0}]";
        private static final String TM_EXEPROD_ERROR = "An error occurred while getting execution product from TM. Cause: [{0}]";
        private static final String IAM_ERROR = "An error occurred while getting user token from IAM. Cause: [{0}]";
        private static final String TENANT_ID_NOT_FOUND = "Cannot find Tenant ID from MDC. MDC host:[{0}]";
        private static final String LICENSE_KEY_NOT_FOUND = "Cannot find License key from TM. TM host:[{0}], Status:[{1}], Error Message:[{2}]";
        private static final String USER_INFO_NOT_FOUND = "Cannot find user info from IAM. IAM host:[{0}], Code:[{1}], Message:[{2}]";
        private static final String EXECUTION_KEY_NOT_FOUND = "Cannot find execution product from TM. TM host:[{0}], Status:[{1}], Error Message:[{2}]";

        private ErrorMsg() {
        }

        private static String getMdcError(String ... args) {
            return MessageFormat.format(MDC_ERROR, args);
        }

        private static String getTmLicLeyError(String ... args) {
            return MessageFormat.format(TM_lICKEY_ERROR, args);
        }

        private static String getTmExeProdError(String ... args) {
            return MessageFormat.format(TM_EXEPROD_ERROR, args);
        }

        private static String getIamError(String ... args) {
            return MessageFormat.format(IAM_ERROR, args);
        }

        private static String getTenantIdNotFound(String ... args) {
            return MessageFormat.format(TENANT_ID_NOT_FOUND, args);
        }

        private static String getLicenseKeyNotFound(String ... args) {
            return MessageFormat.format(LICENSE_KEY_NOT_FOUND, args);
        }

        private static String getUserTokenNotFound(String ... args) {
            return MessageFormat.format(USER_INFO_NOT_FOUND, args);
        }

        private static String getExecutionProductNotFound(String ... args) {
            return MessageFormat.format(EXECUTION_KEY_NOT_FOUND, args);
        }
    }
}

