/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.util;

import com.digiwin.athena.esp.sdk.constants.URLConstant;
import com.digiwin.athena.esp.sdk.enums.EocTypeEnum;
import com.digiwin.athena.esp.sdk.exception.JsonFormatException;
import com.digiwin.athena.esp.sdk.exception.ProductUIDNotFoundException;
import com.digiwin.athena.esp.sdk.model.MessageModel;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.athena.esp.sdk.util.HttpInvokeUtil;
import com.digiwin.athena.esp.sdk.util.JsonUtil;
import com.digiwin.athena.esp.sdk.util.StringUtil;
import com.digiwin.athena.esp.sdk.util.TenantInfoUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;

public class EocOmTransformUtil {
    private static Log log = LogFactory.getLog(EocOmTransformUtil.class);
    private static final String PATH_MDC_TENANT_PRODUCT_OPERATION_LIST_GET = "/TenantProductOperationList/Get";
    private static final String PATH_EOC_EMP_ID = "/api/eoc/v2/emp/id";
    private static final String REGULAR = "[\"'](ex_){0,1}(eoc|om)_(company|site|region)_id[\"']\\s*:\\s*[\"'].+[\"']";
    private static final String DATAKEY = "datakey";
    private static final String UID = "uid";
    private static final String REGION_TYPE = "region_type";
    private static final String EX_REGION_TYPE = "ex_region_type";

    public static String transform(String message, String tenantId, String product) throws Exception {
        if (EocOmTransformUtil.checkTransform(message)) {
            JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
            return EocOmTransformUtil.transform(message, tMappingJsonObject);
        }
        return message;
    }

    public static void transformRequest(MessageModel messageModel) throws Exception {
        String tBody;
        Map<String, String> tEocMap;
        JsonObject tEntObject;
        RequestModel requestModel = messageModel.getRequestModel();
        if (requestModel.getServiceProd() == null) {
            requestModel.setServiceProd(TenantInfoUtil.getExecutionProduct(requestModel.getTenantId(), requestModel.getServiceName(), requestModel.getHeader("token")));
        }
        EocOmTransformUtil.transformAcct(requestModel);
        JsonObject mappingJsonObject = EocOmTransformUtil.getMappingJsonObject(requestModel.getTenantId().trim(), requestModel.getServiceProd().trim());
        messageModel.setEocMappingJsonObject(mappingJsonObject);
        if (mappingJsonObject.get(UID) == null) {
            throw new ProductUIDNotFoundException(String.format("Product UID not found. MDC host:[%s], tenantId:[%s], product:[%s]", URLConstant.MDC_BASE_URL, requestModel.getTenantId().trim(), requestModel.getServiceProd().trim()));
        }
        requestModel.setServiceProdUid(mappingJsonObject.get(UID).getAsString());
        if (mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()) != null && (tEntObject = mappingJsonObject.get(EocTypeEnum.ENTERPRISE.getLevelTag()).getAsJsonObject()).has(DATAKEY)) {
            requestModel.addDatakey(tEntObject.get(DATAKEY).getAsString(), tEntObject.get(EocTypeEnum.ENTERPRISE.getOmTag()).getAsString());
        }
        if ((tEocMap = messageModel.getRequestModel().getEocMap()) != null && !tEocMap.isEmpty()) {
            if (requestModel.getDatakeyMap() == null) {
                requestModel.setDatakeyMap(new HashMap<String, String>());
            }
            EocOmTransformUtil.transformDatakey(requestModel.getDatakeyMap(), tEocMap, mappingJsonObject);
            if (requestModel.getOmMap() == null) {
                requestModel.setOmMap(new HashMap<String, String>());
            }
            EocOmTransformUtil.transformEocOmMap(requestModel.getOmMap(), tEocMap, mappingJsonObject);
        }
        if (EocOmTransformUtil.checkTransform(tBody = messageModel.getRequestModel().getBodyJsonString())) {
            messageModel.getRequestModel().setBodyJsonString(EocOmTransformUtil.transform(tBody, mappingJsonObject));
        }
    }

    public static void transformResponse(MessageModel messageModel) throws Exception {
        ResponseModel resposeModel = messageModel.getResponseModel();
        String tBody = resposeModel.getBodyJsonString();
        if (EocOmTransformUtil.checkTransform(tBody)) {
            String tenantId = messageModel.getRequestModel().getTenantId();
            String product = messageModel.getRequestModel().getServiceProd();
            if (messageModel.getEocMappingJsonObject() == null) {
                messageModel.setEocMappingJsonObject(EocOmTransformUtil.getMappingJsonObject(tenantId, product));
            }
            resposeModel.setBodyJsonString(EocOmTransformUtil.transform(tBody, messageModel.getEocMappingJsonObject()));
        }
    }

    private static void transformAcct(RequestModel requestModel) throws Exception {
        String tUserId = requestModel.getHostAcct();
        if (tUserId != null && !tUserId.trim().equals("")) {
            if (tUserId.trim().equals("athena")) {
                String serviceProd;
                switch (serviceProd = requestModel.getServiceProd()) {
                    case "E10": {
                        requestModel.setHostEmpAcct("dcms");
                        break;
                    }
                    case "WFGP": {
                        requestModel.setHostEmpAcct("DS");
                        break;
                    }
                    case "T100": 
                    case "TIPTOP": {
                        requestModel.setHostEmpAcct("tiptop");
                        break;
                    }
                    default: {
                        requestModel.setHostEmpAcct(tUserId);
                        break;
                    }
                }
            } else {
                String tURL = URLConstant.EOC_BASE_URL + PATH_EOC_EMP_ID;
                HttpPost tHttpPost = new HttpPost(tURL);
                JsonObject tJsonObject = new JsonObject();
                tJsonObject.addProperty("userId", tUserId.trim());
                StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
                tHttpPost.setEntity((HttpEntity)tStringEntity);
                tHttpPost.addHeader("digi-middleware-auth-user", requestModel.getHeader("token"));
                tHttpPost.addHeader("routerKey", requestModel.getTenantId());
                HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
                JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
                if (tReturnJsonObject.get("code") != null && tReturnJsonObject.get("code").getAsString().equals("200")) {
                    requestModel.setHostEmpAcct(tReturnJsonObject.get("data").getAsString());
                } else {
                    String tCode = null;
                    String tErrorMessage = null;
                    if (tReturnJsonObject.get("code") != null) {
                        tCode = tReturnJsonObject.get("code").getAsString();
                    }
                    if (tReturnJsonObject.get("errorMessage") != null) {
                        tErrorMessage = tReturnJsonObject.get("errorMessage").getAsString();
                    }
                    throw new Exception(String.format("EmpId not found. EOC host:[%s], user id:[%s], user token:[%s], response code:[%s], error message:[%s]", URLConstant.EOC_BASE_URL, tUserId.trim(), requestModel.getHeader("token"), tCode, tErrorMessage));
                }
            }
        }
    }

    private static void transformDatakey(Map<String, String> datakeys, Map<String, String> eocmap, JsonObject mappingJsonObject) {
        EocOmTransformUtil.transformDatakey(datakeys, eocmap, mappingJsonObject, EocTypeEnum.COMPANY);
        EocOmTransformUtil.transformDatakey(datakeys, eocmap, mappingJsonObject, EocTypeEnum.REGION);
    }

    private static void transformDatakey(Map<String, String> datakeys, Map<String, String> eocmap, JsonObject mappingJsonObject, EocTypeEnum eocType) {
        if (eocmap.get(eocType.getEocTag()) != null) {
            JsonObject tSubObj;
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(eocType.getEocTag(), eocmap.get(eocType.getEocTag()));
            if (eocType.equals((Object)EocTypeEnum.REGION) && eocmap.get(REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, eocmap.get(REGION_TYPE));
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null && tSubObj.has(DATAKEY)) {
                datakeys.put(tSubObj.get(DATAKEY).getAsString(), tSubObj.get(eocType.getOmTag()).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformDatakey(datakeys, eocmap, tSubObj, EocTypeEnum.SITE);
                }
            }
        }
    }

    public static Map<String, String> transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, String tenantId, String product) throws Exception {
        if (!sourceMap.isEmpty()) {
            JsonObject tMappingJsonObject = EocOmTransformUtil.getMappingJsonObject(tenantId, product);
            EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tMappingJsonObject);
        }
        return targetMap;
    }

    private static void transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject) {
        EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, mappingJsonObject, EocTypeEnum.COMPANY);
        EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, mappingJsonObject, EocTypeEnum.REGION);
    }

    private static String transform(String message, JsonObject mappingJsonObject) {
        JsonParser tJsonParser = new JsonParser();
        JsonObject tMessageJsonObject = tJsonParser.parse(message).getAsJsonObject();
        EocOmTransformUtil.transform(tMessageJsonObject, mappingJsonObject);
        return tMessageJsonObject.toString();
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject) {
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.COMPANY);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.REGION);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.EX_COMPANY);
        EocOmTransformUtil.transform(messageJsonObject, mappingJsonObject, EocTypeEnum.EX_REGION);
        Set tKeySet = messageJsonObject.keySet();
        for (String tKey : tKeySet) {
            if (messageJsonObject.get(tKey).isJsonArray()) {
                JsonArray tJsonArray = messageJsonObject.get(tKey).getAsJsonArray();
                for (int i = 0; i < tJsonArray.size(); ++i) {
                    EocOmTransformUtil.transform(tJsonArray.get(i).getAsJsonObject(), mappingJsonObject);
                }
                continue;
            }
            if (!messageJsonObject.get(tKey).isJsonObject()) continue;
            EocOmTransformUtil.transform(messageJsonObject.get(tKey).getAsJsonObject(), mappingJsonObject);
        }
    }

    private static void transform(JsonObject messageJsonObject, JsonObject mappingJsonObject, EocTypeEnum eocType) {
        String sourceTag = null;
        String targetTag = null;
        JsonElement element = null;
        element = messageJsonObject.get(eocType.getEocTag());
        if (element != null && !"".equals(element.getAsString())) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else {
            element = messageJsonObject.get(eocType.getOmTag());
            if (element != null && !"".equals(element.getAsString())) {
                sourceTag = eocType.getOmTag();
                targetTag = eocType.getEocTag();
            }
        }
        if (sourceTag != null) {
            JsonObject tSubObj;
            String sourceValue = element.getAsString();
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag.replace("ex_", ""), sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && messageJsonObject.get(REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, messageJsonObject.get(REGION_TYPE).getAsString());
            }
            if (eocType.equals((Object)EocTypeEnum.EX_REGION) && messageJsonObject.get(EX_REGION_TYPE) != null) {
                tConditionMap.put(REGION_TYPE, messageJsonObject.get(EX_REGION_TYPE).getAsString());
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null) {
                messageJsonObject.addProperty(targetTag, tSubObj.get(targetTag.replace("ex_", "")).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transform(messageJsonObject, tSubObj, EocTypeEnum.SITE);
                }
                if (eocType.equals((Object)EocTypeEnum.EX_COMPANY)) {
                    EocOmTransformUtil.transform(messageJsonObject, tSubObj, EocTypeEnum.EX_SITE);
                }
            }
        }
    }

    private static void transformEocOmMap(Map<String, String> targetMap, Map<String, String> sourceMap, JsonObject mappingJsonObject, EocTypeEnum eocType) {
        String sourceTag = null;
        String targetTag = null;
        if (!StringUtil.isEmptyOrSpace(sourceMap.get(eocType.getEocTag()))) {
            sourceTag = eocType.getEocTag();
            targetTag = eocType.getOmTag();
        } else if (!StringUtil.isEmptyOrSpace(sourceMap.get(eocType.getOmTag()))) {
            sourceTag = eocType.getOmTag();
            targetTag = eocType.getEocTag();
        }
        if (sourceTag != null) {
            JsonObject tSubObj;
            String sourceValue = sourceMap.get(sourceTag);
            HashMap<String, String> tConditionMap = new HashMap<String, String>();
            tConditionMap.put(sourceTag, sourceValue);
            if (eocType.equals((Object)EocTypeEnum.REGION) && sourceMap.get(REGION_TYPE) != null) {
                targetMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
                tConditionMap.put(REGION_TYPE, sourceMap.get(REGION_TYPE));
            }
            if ((tSubObj = EocOmTransformUtil.searchSubEocJsonObject(mappingJsonObject, eocType, tConditionMap)) != null) {
                targetMap.put(targetTag, tSubObj.get(targetTag).getAsString());
                if (eocType.equals((Object)EocTypeEnum.COMPANY)) {
                    EocOmTransformUtil.transformEocOmMap(targetMap, sourceMap, tSubObj, EocTypeEnum.SITE);
                }
            }
        }
    }

    private static JsonObject getMappingJsonObject(String tenantId, String product) throws ClientProtocolException, IOException, ParseException, JsonFormatException {
        String tURL = URLConstant.MDC_BASE_URL + PATH_MDC_TENANT_PRODUCT_OPERATION_LIST_GET;
        HttpPost tHttpPost = new HttpPost(tURL);
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("tenant_id", tenantId);
        tJsonObject.addProperty("prod_name", product);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        tHttpPost.addHeader("routerKey", tenantId);
        HttpResponse tHttpResponse = HttpInvokeUtil.executeHttpRequest((HttpUriRequest)tHttpPost);
        JsonObject tReturnJsonObject = JsonUtil.parseHttpResponseBody(tHttpResponse, tURL);
        return tReturnJsonObject;
    }

    private static boolean checkTransform(String message) {
        if (message == null || message.isEmpty()) {
            return false;
        }
        Pattern tRegexP = Pattern.compile(REGULAR);
        Matcher tMatch = tRegexP.matcher(message);
        return tMatch.find();
    }

    private static JsonObject searchSubEocJsonObject(JsonObject eocJsonObject, EocTypeEnum eocType, Map<String, String> conditionMap) {
        JsonArray eocJsonArray;
        if (eocJsonObject.get(eocType.getLevelTag()) != null && (eocJsonArray = eocJsonObject.get(eocType.getLevelTag()).getAsJsonArray()).size() > 0) {
            Set<String> keySet = conditionMap.keySet();
            for (int i = 0; i < eocJsonArray.size(); ++i) {
                boolean result = true;
                JsonObject tObj = eocJsonArray.get(i).getAsJsonObject();
                for (String key : keySet) {
                    if (conditionMap.get(key).equals(tObj.get(key).getAsString())) continue;
                    result = false;
                    break;
                }
                if (!result) continue;
                return tObj;
            }
        }
        return null;
    }
}

