/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk;

import com.digiwin.athena.esp.sdk.enums.EocTypeEnum;
import com.digiwin.athena.esp.sdk.exception.ProductOperationIdNotFoundException;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class Invoker {
    private static Properties properties = new Properties();

    static {
        String confPath = Invoker.getConfPath();
        if (confPath == null) {
            throw new RuntimeException("esp-proxy\u914d\u7f6e\u6587\u4ef6esp-proxy.properties\u52a0\u8f7d\u5931\u8d25");
        }
        InputStream in = null;
        try {
            try {
                in = new BufferedInputStream(new FileInputStream(confPath));
                properties.load(in);
            }
            catch (Exception e) {
                throw new RuntimeException("esp-proxy\u52a0\u8f7desp-proxy.properties\u914d\u7f6e\u5931\u8d25");
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString) throws ClientProtocolException, IOException {
        HttpResponse tHttpResponse = Invoker.invokeRest("sync", hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakey, headers, bodyJsonString);
        return EntityUtils.toString((HttpEntity)tHttpResponse.getEntity());
    }

    public static String invokeRestSync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString, Map<String, String> eocId) throws ProductOperationIdNotFoundException, ClientProtocolException, IOException {
        if (eocId != null && !eocId.isEmpty()) {
            if (datakey == null) {
                datakey = new HashMap<String, String>();
            }
            Invoker.putProdOperIdInDatakeyMap(tenantId, serviceProd, eocId, datakey);
        }
        return Invoker.invokeRestSync(hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakey, headers, bodyJsonString);
    }

    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString) throws ClientProtocolException, IOException {
        HttpResponse tHttpResponse = Invoker.invokeRest("fasync", hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakey, headers, bodyJsonString);
        HashMap<String, String> tHeaders = new HashMap<String, String>();
        Header[] headerArray = tHttpResponse.getAllHeaders();
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header tHeader = headerArray[n2];
            tHeaders.put(tHeader.getName(), tHeader.getValue());
            ++n2;
        }
        return new ResponseModel(tHeaders, EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
    }

    public static ResponseModel invokeRestFasync(String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString, Map<String, String> eocId) throws ProductOperationIdNotFoundException, ClientProtocolException, IOException {
        if (eocId != null && !eocId.isEmpty()) {
            if (datakey == null) {
                datakey = new HashMap<String, String>();
            }
            Invoker.putProdOperIdInDatakeyMap(tenantId, serviceProd, eocId, datakey);
        }
        return Invoker.invokeRestFasync(hostProd, hostVer, hostId, hostAcct, tenantId, serviceProd, serviceProdUid, serviceName, datakey, headers, bodyJsonString);
    }

    private static HttpResponse invokeRest(String type, String hostProd, String hostVer, String hostId, String hostAcct, String tenantId, String serviceProd, String serviceProdUid, String serviceName, Map<String, String> datakey, Map<String, String> headers, String bodyJsonString) throws ClientProtocolException, IOException {
        JsonObject tHostJsonObject;
        CloseableHttpClient tClient;
        HttpPost tHttpPost;
        block20: {
            block21: {
                tHttpPost = new HttpPost("http://" + Invoker.getEspDomain() + "/CROSS/RESTful");
                tClient = HttpClients.createDefault();
                tHttpPost.setHeader("digi-type", type);
                tHostJsonObject = new JsonObject();
                tHostJsonObject.addProperty("prod", hostProd);
                tHostJsonObject.addProperty("ver", hostVer);
                tHostJsonObject.addProperty("ip", "");
                if (hostId != null) {
                    tHostJsonObject.addProperty("id", hostId);
                }
                tHostJsonObject.addProperty("timestamp", new SimpleDateFormat("yyyyMMddHHmmssSSS").format(Calendar.getInstance().getTime()));
                if (hostAcct == null) break block20;
                if (!"athena".equals(hostAcct)) break block21;
                switch (serviceProd) {
                    case "E10": {
                        tHostJsonObject.addProperty("acct", "dcms");
                        break;
                    }
                    case "WFGP": {
                        tHostJsonObject.addProperty("acct", "DS");
                        break;
                    }
                    default: {
                        tHostJsonObject.addProperty("acct", hostAcct);
                        break;
                    }
                }
                break block20;
            }
            tHostJsonObject.addProperty("acct", hostAcct);
        }
        tHttpPost.setHeader("digi-host", tHostJsonObject.toString());
        JsonObject tServiceJsonObject = new JsonObject();
        tServiceJsonObject.addProperty("prod", serviceProd);
        if (serviceProdUid != null) {
            tServiceJsonObject.addProperty("uid", serviceProdUid);
        }
        tServiceJsonObject.addProperty("tenant_id", tenantId);
        tServiceJsonObject.addProperty("name", serviceName);
        tHttpPost.setHeader("digi-service", tServiceJsonObject.toString());
        String keyStr = String.valueOf(tHostJsonObject.toString()) + tServiceJsonObject.toString();
        String md5Key = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(keyStr.getBytes("UTF-8"));
            byte[] digest = md.digest();
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < digest.length) {
                byte b;
                int value = (b & 0x7F) + ((b = digest[i]) < 0 ? 128 : 0);
                buffer.append(value < 16 ? "0" : "");
                buffer.append(Integer.toHexString(value));
                ++i;
            }
            md5Key = buffer.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tHttpPost.setHeader("digi-key", md5Key);
        JsonObject tDatakeyJsonObject = new JsonObject();
        if (datakey != null && !datakey.isEmpty()) {
            for (String tKey : datakey.keySet()) {
                tDatakeyJsonObject.addProperty(tKey, datakey.get(tKey));
            }
        }
        if (tDatakeyJsonObject.size() > 0) {
            tHttpPost.setHeader("digi-datakey", tDatakeyJsonObject.toString());
        }
        if (headers != null) {
            Set<String> tKeySet = headers.keySet();
            for (String tKey : tKeySet) {
                tHttpPost.setHeader(tKey, headers.get(tKey));
            }
        }
        StringEntity tStringEntity = new StringEntity(bodyJsonString, ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        return tClient.execute((HttpUriRequest)tHttpPost);
    }

    private static void putProdOperIdInDatakeyMap(String tenantId, String prodName, Map<String, String> eocId, Map<String, String> datakey) throws ProductOperationIdNotFoundException, ClientProtocolException, IOException {
        datakey.putAll(Invoker.getOmIdMap(tenantId, prodName, eocId));
    }

    private static Map<String, String> getOmIdMap(String tenantId, String prodName, Map<String, String> eocId) throws ProductOperationIdNotFoundException, ClientProtocolException, IOException {
        HttpPost tHttpPost = new HttpPost("http://" + Invoker.getMdcDomain() + "/ESP/MetadataCache/TenantOrganizationTrans/Get");
        CloseableHttpClient tClient = HttpClients.createDefault();
        String tEocId = eocId.get(EocTypeEnum.OM_COMPANY_ID.getEocTag());
        JsonObject tJsonObject = new JsonObject();
        tJsonObject.addProperty("tenant_id", tenantId);
        tJsonObject.addProperty("target", "prod");
        tJsonObject.addProperty("prod_name", prodName);
        JsonObject tSourceJsonObject = new JsonObject();
        tSourceJsonObject.addProperty("level", EocTypeEnum.OM_COMPANY_ID.getMdcTag());
        tSourceJsonObject.addProperty("id", tEocId);
        JsonArray tJsonArray = new JsonArray();
        tJsonArray.add((JsonElement)tSourceJsonObject);
        tJsonObject.add("source", (JsonElement)tJsonArray);
        StringEntity tStringEntity = new StringEntity(tJsonObject.toString(), ContentType.APPLICATION_JSON);
        tHttpPost.setEntity((HttpEntity)tStringEntity);
        CloseableHttpResponse tHttpResponse = tClient.execute((HttpUriRequest)tHttpPost);
        JsonParser tJsonParser = new JsonParser();
        JsonObject tJsonElement = (JsonObject)tJsonParser.parse(EntityUtils.toString((HttpEntity)tHttpResponse.getEntity()));
        tJsonElement.getAsJsonObject("data").getAsJsonArray("result").get(0).getAsJsonObject().get("id");
        String tResult = tJsonElement.getAsJsonObject("data").getAsJsonArray("result").get(0).getAsJsonObject().get("value").getAsString();
        if (tResult == null || "".equals(tResult) || "null".equals(tResult)) {
            StringBuilder tSB = new StringBuilder();
            tSB.append("Cannot found Product Operation ID. Tenant ID: ").append(tenantId).append(", Product: ").append(prodName).append(", EOC ID: ").append(tEocId).append(", Level: ").append(EocTypeEnum.OM_COMPANY_ID.getEocTag()).append(".");
            throw new ProductOperationIdNotFoundException(tSB.toString());
        }
        HashMap<String, String> tResultMap = new HashMap<String, String>();
        tResultMap.put(EocTypeEnum.OM_COMPANY_ID.getDatakeyTag(), tResult);
        return tResultMap;
    }

    private static String getConfPath() {
        String userDir = System.getProperty("user.dir");
        String filePath = "/esp-proxy.properties";
        String classRootPathParentPath = Invoker.getClassRootPathParentFolder();
        ArrayList<String> pathList = new ArrayList<String>();
        pathList.add(String.valueOf(userDir) + "/application/conf" + filePath);
        pathList.add(String.valueOf(userDir) + filePath);
        pathList.add(String.valueOf(classRootPathParentPath) + filePath);
        pathList.add(String.valueOf(classRootPathParentPath) + "/properties" + filePath);
        for (String path : pathList) {
            if (!Invoker.fileExists(path)) continue;
            return path;
        }
        return null;
    }

    private static boolean fileExists(String filePath) {
        File file = new File(filePath);
        return file.exists();
    }

    private static String getClassRootPathParentFolder() {
        URL url = Invoker.getClassRootPath(Invoker.class);
        try {
            File rootFolder = new File(url.toURI());
            return rootFolder.getParentFile().getPath();
        }
        catch (URISyntaxException var3) {
            var3.printStackTrace();
            return "";
        }
    }

    private static URL getClassRootPath(Class<?> targetClass) {
        ClassLoader classLoader = targetClass.getClassLoader();
        URL url = classLoader.getResource("");
        if (url == null) {
            url = ClassLoader.getSystemClassLoader().getResource("");
        }
        return url;
    }

    private static String getEspDomain() {
        return properties.getProperty("esp.domain");
    }

    private static String getMdcDomain() {
        return properties.getProperty("mdc.domain");
    }
}

