/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.esp.sdk.init;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.digiwin.athena.esp.sdk.constants.AppConstant;
import com.digiwin.athena.esp.sdk.constants.URLConstant;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EspSdkInitialize {
    private static Log log = LogFactory.getLog(EspSdkInitialize.class);

    public static void initMQConfig(String mqUrl) {
        URLConstant.MQ_URL = mqUrl.trim();
    }

    public static void initAppConfig(String appid, String apptoken) {
        AppConstant.APP_ID = appid.trim();
        AppConstant.APP_TOKEN = apptoken.trim();
    }

    public static void initLmcConfig(String LmcUrl) {
        if (LmcUrl != null) {
            URLConstant.LMC_BASE_URL = LmcUrl.trim().startsWith("http") ? LmcUrl.trim() : "http://" + LmcUrl.trim();
        }
    }

    public static void enableEspRouting(boolean value) {
    }

    public static void initConfig(String espDomain, String mdcDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, null, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String tmDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, tmDomain, null, null);
    }

    public static void initConfig(String espDomain, String mdcDomain, String tmDomain, String eocDomain) {
        EspSdkInitialize.initConfig(espDomain, mdcDomain, tmDomain, eocDomain, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initConfig(String espDomain, String mdcDomain, String tmDomain, String eocDomain, String iamDomain) {
        Class<EspSdkInitialize> clazz = EspSdkInitialize.class;
        synchronized (EspSdkInitialize.class) {
            if (espDomain != null) {
                URLConstant.ESP_REST_BASE_URL = espDomain.trim().startsWith("http") ? String.valueOf(espDomain.trim()) + "/CROSS/RESTful" : "http://" + espDomain.trim() + "/CROSS/RESTful";
            }
            if (mdcDomain != null) {
                URLConstant.MDC_BASE_URL = mdcDomain.trim().startsWith("http") ? String.valueOf(mdcDomain.trim()) + "/ESP/MetadataCache" : "http://" + mdcDomain.trim() + "/ESP/MetadataCache";
            }
            if (tmDomain != null) {
                URLConstant.TM_BASE_URL = tmDomain.trim().startsWith("http") ? tmDomain.trim() : "http://" + tmDomain.trim();
            }
            if (eocDomain != null) {
                URLConstant.EOC_BASE_URL = eocDomain.trim().startsWith("http") ? eocDomain.trim() : "http://" + eocDomain.trim();
            }
            if (iamDomain != null) {
                URLConstant.IAM_BASE_URL = iamDomain.trim().startsWith("http") ? iamDomain.trim() : "http://" + iamDomain.trim();
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public static void initConfigbyApollo(String url) {
        EspSdkInitialize.initConfigbyApollo(url, false);
    }

    public static void initConfigbyApollo(String url, final boolean isPaas) {
        System.setProperty("apollo.meta", url);
        final Config config = ConfigService.getConfig((String)"esp_sdk");
        EspSdkInitialize.setConfigbyApollo(config, isPaas);
        config.addChangeListener(new ConfigChangeListener(){

            public void onChange(ConfigChangeEvent changeEvent) {
                for (String key : changeEvent.changedKeys()) {
                    ConfigChange change = changeEvent.getChange(key);
                    log.info((Object)String.format("Parameter changed - key: %s, oldValue: %s, newValue: %s, changeType: %s", change.getPropertyName(), change.getOldValue(), change.getNewValue(), change.getChangeType()));
                }
                EspSdkInitialize.setConfigbyApollo(config, isPaas);
            }
        });
    }

    private static void setConfigbyApollo(Config config, boolean isPaas) {
        if (isPaas) {
            URLConstant.ESP_REST_BASE_URL = String.valueOf(config.getProperty("esp.url.paas", null).trim()) + "/CROSS/RESTful";
            URLConstant.MDC_BASE_URL = String.valueOf(config.getProperty("mdc.url.paas", null).trim()) + "/ESP/MetadataCache";
            URLConstant.TM_BASE_URL = config.getProperty("thememap.url.paas", null);
            URLConstant.EOC_BASE_URL = config.getProperty("eoc.url.paas", null);
            URLConstant.IAM_BASE_URL = config.getProperty("iam.url.paas", null);
        } else {
            URLConstant.ESP_REST_BASE_URL = String.valueOf(config.getProperty("esp.url", null).trim()) + "/CROSS/RESTful";
            URLConstant.MDC_BASE_URL = String.valueOf(config.getProperty("mdc.url", null).trim()) + "/ESP/MetadataCache";
            URLConstant.TM_BASE_URL = config.getProperty("thememap.url", null);
            URLConstant.EOC_BASE_URL = config.getProperty("eoc.url", null);
            URLConstant.IAM_BASE_URL = config.getProperty("iam.url", null);
        }
    }
}

